/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbranks.impl.condition;

import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbranks.api.Rank;
import dev.ftb.mods.ftbranks.api.RankCondition;
import dev.ftb.mods.ftbranks.api.RankException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;

public class XorCondition
implements RankCondition {
    private final List<RankCondition> conditions = new ArrayList<RankCondition>();

    public XorCondition(Rank rank, SNBTCompoundTag tag) throws RankException {
        for (Tag t : tag.getList("conditions", Tag.class)) {
            this.conditions.add(rank.getManager().createCondition(rank, t));
        }
        if (this.conditions.size() != 2) {
            throw new RuntimeException("XOR condition takes exactly two sub-conditions");
        }
    }

    @Override
    public String getType() {
        return "xor";
    }

    @Override
    public boolean isRankActive(ServerPlayer player) {
        return this.conditions.get(0).isRankActive(player) != this.conditions.get(1).isRankActive(player);
    }

    @Override
    public void save(SNBTCompoundTag tag) {
        ListTag a = new ListTag();
        for (RankCondition condition : this.conditions) {
            SNBTCompoundTag c = new SNBTCompoundTag();
            c.m_128359_("type", condition.getType());
            condition.save(c);
            a.add((Object)c);
        }
        tag.m_128365_("conditions", (Tag)a);
    }
}

