/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.tree;

import biomesoplenty.worldgen.feature.configurations.PineTreeConfiguration;
import biomesoplenty.worldgen.feature.tree.BOPTreeFeature;
import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;

public class PineTreeFeature
extends BOPTreeFeature<PineTreeConfiguration> {
    public PineTreeFeature(Codec<PineTreeConfiguration> codec) {
        super(codec);
    }

    protected boolean m_225257_(WorldGenLevel world, RandomSource random, BlockPos pos, BiConsumer<BlockPos, BlockState> roots, BiConsumer<BlockPos, BlockState> logs, FoliagePlacer.FoliageSetter leaves, TreeConfiguration configBase) {
        PineTreeConfiguration config = (PineTreeConfiguration)configBase;
        int height = random.m_188503_(config.maxHeight - config.minHeight) + config.minHeight;
        boolean hasSpace = true;
        if (pos.m_123342_() >= world.m_141937_() + 1 && pos.m_123342_() + height + 1 <= world.m_151558_()) {
            for (int y = pos.m_123342_(); y <= pos.m_123342_() + 1 + height; ++y) {
                int radius = 1;
                if (y == pos.m_123342_()) {
                    radius = 0;
                }
                if (y >= pos.m_123342_() + 1 + height - 2) {
                    radius = 2;
                }
                for (int x = pos.m_123341_() - radius; x <= pos.m_123341_() + radius && hasSpace; ++x) {
                    for (int z = pos.m_123343_() - radius; z <= pos.m_123343_() + radius && hasSpace; ++z) {
                        if (y >= world.m_141937_() && y < world.m_151558_()) {
                            if (this.canReplace((LevelAccessor)world, new BlockPos(x, y, z))) continue;
                            hasSpace = false;
                            continue;
                        }
                        hasSpace = false;
                    }
                }
            }
            if (!hasSpace) {
                return false;
            }
            BlockPos soilPos = pos.m_7495_();
            Block soil = world.m_8055_(soilPos).m_60734_();
            if (pos.m_123342_() < world.m_151558_() - height - 1) {
                world.m_7731_(soilPos, Blocks.f_50493_.m_49966_(), 3);
                this.generateTrunk(logs, leaves, (LevelAccessor)world, pos, height, config);
                return true;
            }
            return false;
        }
        return false;
    }

    protected void generateTrunk(BiConsumer<BlockPos, BlockState> logs, FoliagePlacer.FoliageSetter leaves, LevelAccessor world, BlockPos start, int height, PineTreeConfiguration config) {
        int endHeight = height;
        for (int layer = 0; layer <= endHeight; ++layer) {
            BlockPos middlePos = start.m_6630_(layer);
            if (!this.canReplace(world, middlePos)) continue;
            this.placeLog(world, middlePos, logs, config);
        }
        BlockPos lowerBranchStartPos = start.m_6630_(endHeight - 9);
        Direction lowerBranchDir = Direction.Plane.HORIZONTAL.m_235690_(world.m_213780_());
        if (world.m_213780_().m_188503_(6) != 0) {
            this.generateBranch(logs, leaves, world, lowerBranchStartPos, lowerBranchDir, 2, config);
            if (world.m_213780_().m_188503_(4) == 0) {
                this.generateBranch(logs, leaves, world, lowerBranchStartPos, lowerBranchDir.m_122424_(), 2, config);
                if (world.m_213780_().m_188503_(6) == 0) {
                    this.generateBranch(logs, leaves, world, lowerBranchStartPos, lowerBranchDir.m_122427_(), 2, config);
                    this.generateBranch(logs, leaves, world, lowerBranchStartPos, lowerBranchDir.m_122428_(), 2, config);
                }
            }
        }
        BlockPos upperBranchStartPos = start.m_6630_(endHeight - 6);
        this.generateBranch(logs, leaves, world, upperBranchStartPos, Direction.NORTH, 1, config);
        this.generateBranch(logs, leaves, world, upperBranchStartPos, Direction.EAST, 1, config);
        this.generateBranch(logs, leaves, world, upperBranchStartPos, Direction.SOUTH, 1, config);
        this.generateBranch(logs, leaves, world, upperBranchStartPos, Direction.WEST, 1, config);
        BlockPos topStartPos = start.m_6630_(endHeight - 3);
        this.placeLeaves(world, topStartPos.m_7918_(0, 0, 1), leaves, config);
        this.placeLeaves(world, topStartPos.m_7918_(0, 0, -1), leaves, config);
        this.placeLeaves(world, topStartPos.m_7918_(1, 0, 0), leaves, config);
        this.placeLeaves(world, topStartPos.m_7918_(-1, 0, 0), leaves, config);
        this.placeLeaves(world, topStartPos.m_7918_(0, 1, 1), leaves, config);
        this.placeLeaves(world, topStartPos.m_7918_(0, 1, -1), leaves, config);
        this.placeLeaves(world, topStartPos.m_7918_(1, 1, 0), leaves, config);
        this.placeLeaves(world, topStartPos.m_7918_(-1, 1, 0), leaves, config);
        this.placeLeaves(world, topStartPos.m_7918_(-1, 1, 1), leaves, config);
        this.placeLeaves(world, topStartPos.m_7918_(1, 1, -1), leaves, config);
        this.placeLeaves(world, topStartPos.m_7918_(1, 1, 1), leaves, config);
        this.placeLeaves(world, topStartPos.m_7918_(-1, 1, -1), leaves, config);
        this.placeLeaves(world, topStartPos.m_7918_(1, 1, 2), leaves, config);
        this.placeLeaves(world, topStartPos.m_7918_(1, 1, -2), leaves, config);
        this.placeLeaves(world, topStartPos.m_7918_(-1, 1, 2), leaves, config);
        this.placeLeaves(world, topStartPos.m_7918_(-1, 1, -2), leaves, config);
        this.placeLeaves(world, topStartPos.m_7918_(2, 1, 1), leaves, config);
        this.placeLeaves(world, topStartPos.m_7918_(2, 1, -1), leaves, config);
        this.placeLeaves(world, topStartPos.m_7918_(-2, 1, 1), leaves, config);
        this.placeLeaves(world, topStartPos.m_7918_(-2, 1, -1), leaves, config);
        this.placeLeaves(world, topStartPos.m_7918_(0, 3, 1), leaves, config);
        this.placeLeaves(world, topStartPos.m_7918_(0, 3, -1), leaves, config);
        this.placeLeaves(world, topStartPos.m_7918_(1, 3, 0), leaves, config);
        this.placeLeaves(world, topStartPos.m_7918_(-1, 3, 0), leaves, config);
        this.placeLeaves(world, topStartPos.m_7918_(-1, 3, 1), leaves, config);
        this.placeLeaves(world, topStartPos.m_7918_(1, 3, -1), leaves, config);
        this.placeLeaves(world, topStartPos.m_7918_(1, 3, 1), leaves, config);
        this.placeLeaves(world, topStartPos.m_7918_(-1, 3, -1), leaves, config);
        this.placeLeaves(world, topStartPos.m_7918_(0, 3, 2), leaves, config);
        this.placeLeaves(world, topStartPos.m_7918_(0, 3, -2), leaves, config);
        this.placeLeaves(world, topStartPos.m_7918_(2, 3, 0), leaves, config);
        this.placeLeaves(world, topStartPos.m_7918_(-2, 3, 0), leaves, config);
        this.placeLeaves(world, topStartPos.m_7918_(0, 4, 0), leaves, config);
        this.placeLeaves(world, topStartPos.m_7918_(0, 4, 1), leaves, config);
        this.placeLeaves(world, topStartPos.m_7918_(0, 4, -1), leaves, config);
        this.placeLeaves(world, topStartPos.m_7918_(1, 4, 0), leaves, config);
        this.placeLeaves(world, topStartPos.m_7918_(-1, 4, 0), leaves, config);
    }

    private void generateBranch(BiConsumer<BlockPos, BlockState> logs, FoliagePlacer.FoliageSetter leaves, LevelAccessor world, BlockPos middle, Direction direction, int length, PineTreeConfiguration config) {
        BlockPos pos = middle;
        for (int i = 0; i <= length - 1; ++i) {
            if (!this.canReplace(world, pos.m_5484_(direction, i + 1))) continue;
            this.placeLog(world, pos.m_5484_(direction, i + 1), direction.m_122434_(), logs, config);
        }
        if (this.canReplace(world, pos.m_5484_(direction, length + 1).m_7494_())) {
            this.placeLog(world, pos.m_5484_(direction, length + 1).m_7494_(), direction.m_122434_(), logs, config);
        }
        pos = pos.m_5484_(direction, length + 1);
        this.placeLeaves(world, pos, leaves, config);
        this.placeLeaves(world, pos.m_7918_(0, 1, 1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(0, 1, -1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(1, 1, 0), leaves, config);
        this.placeLeaves(world, pos.m_7918_(-1, 1, 0), leaves, config);
        this.placeLeaves(world, pos.m_7918_(1, 1, 1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(-1, 1, 1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(1, 1, -1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(-1, 1, -1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(0, 1, 2), leaves, config);
        this.placeLeaves(world, pos.m_7918_(0, 1, -2), leaves, config);
        this.placeLeaves(world, pos.m_7918_(2, 1, 0), leaves, config);
        this.placeLeaves(world, pos.m_7918_(-2, 1, 0), leaves, config);
        this.placeLeaves(world, pos.m_7918_(0, 2, 0), leaves, config);
        this.placeLeaves(world, pos.m_7918_(1, 2, 1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(-1, 2, 1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(1, 2, -1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(-1, 2, -1), leaves, config);
    }
}

