/*
 * Decompiled with CFR 0.152.
 */
package com.lion.villagersplus.tradeoffers;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import org.apache.commons.lang3.ArrayUtils;

public class TradeOfferRegistryLoader {
    private static final HashMap<VillagerProfession, Int2ObjectOpenHashMap<List<VillagerTrades.ItemListing>>> TRADES_REGISTRY = new HashMap();

    public static HashMap<VillagerProfession, Int2ObjectOpenHashMap<VillagerTrades.ItemListing[]>> getRegistryForLoading() {
        HashMap<VillagerProfession, Int2ObjectOpenHashMap<VillagerTrades.ItemListing[]>> villagerTrades = new HashMap<VillagerProfession, Int2ObjectOpenHashMap<VillagerTrades.ItemListing[]>>();
        TRADES_REGISTRY.forEach((villagerProfession, listInt2ObjectOpenHashMap) -> {
            Int2ObjectOpenHashMap factories = villagerTrades.getOrDefault(villagerProfession, new Int2ObjectOpenHashMap());
            listInt2ObjectOpenHashMap.forEach((level, factoryList) -> {
                Object[] oldFactories = (VillagerTrades.ItemListing[])factories.getOrDefault(level.intValue(), (Object)new VillagerTrades.ItemListing[0]);
                factories.put(level.intValue(), (Object)((VillagerTrades.ItemListing[])ArrayUtils.addAll((Object[])oldFactories, (Object[])factoryList.toArray(new VillagerTrades.ItemListing[0]))));
            });
            villagerTrades.put((VillagerProfession)villagerProfession, (Int2ObjectOpenHashMap<VillagerTrades.ItemListing[]>)factories);
        });
        return villagerTrades;
    }

    public static void registerVillagerTrade(VillagerProfession profession, int level, VillagerTrades.ItemListing trade) {
        TradeOfferRegistryLoader.getVillagerTradeList(profession, level).add(trade);
    }

    private static List<VillagerTrades.ItemListing> getVillagerTradeList(VillagerProfession profession, int level) {
        Int2ObjectOpenHashMap villagerMap = TradeOfferRegistryLoader.getOrDefaultAndAdd(TRADES_REGISTRY, profession, new Int2ObjectOpenHashMap());
        return TradeOfferRegistryLoader.getOrDefaultAndAdd(villagerMap, level, new ArrayList());
    }

    public static <K, V> V getOrDefaultAndAdd(Map<K, V> map, K key, V defaultValue) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        map.put(key, defaultValue);
        return defaultValue;
    }
}

