/*
 * Decompiled with CFR 0.152.
 */
package com.lion.villagersplus.tradeoffers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lion.villagersplus.VillagersPlus;
import com.lion.villagersplus.tradeoffers.TradeOfferRegistryLoader;
import com.lion.villagersplus.tradeoffers.trades.JsonBuyItemTradeOffer;
import com.lion.villagersplus.tradeoffers.trades.JsonProcessItemTradeOffer;
import com.lion.villagersplus.tradeoffers.trades.JsonSellEnchantedBookTradeOffer;
import com.lion.villagersplus.tradeoffers.trades.JsonSellEnchantedToolTradeOffer;
import com.lion.villagersplus.tradeoffers.trades.JsonSellItemTradeOffer;
import com.lion.villagersplus.tradeoffers.trades.JsonSellPotionTradeOffer;
import com.lion.villagersplus.tradeoffers.trades.JsonSellStructureMapTradeOffer;
import com.lion.villagersplus.tradeoffers.trades.JsonTradeOffer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.VillagerTrades;
import org.jetbrains.annotations.NotNull;

public class TradeOfferManager {
    public static final Map<String, Integer> professionMapping = new HashMap<String, Integer>();
    public static final Map<ResourceLocation, JsonTradeOffer> tradeOfferRegistry = new HashMap<ResourceLocation, JsonTradeOffer>();

    public static void registerTradeOffers() {
        VillagersPlus.LOGGER.info("Registered JSON trade offer adapter.");
        tradeOfferRegistry.put(new ResourceLocation("villagersplus", "sell_item"), new JsonSellItemTradeOffer());
        tradeOfferRegistry.put(new ResourceLocation("villagersplus", "buy_item"), new JsonBuyItemTradeOffer());
        tradeOfferRegistry.put(new ResourceLocation("villagersplus", "process_item"), new JsonProcessItemTradeOffer());
        tradeOfferRegistry.put(new ResourceLocation("villagersplus", "sell_potion"), new JsonSellPotionTradeOffer());
        tradeOfferRegistry.put(new ResourceLocation("villagersplus", "sell_enchanted_tool"), new JsonSellEnchantedToolTradeOffer());
        tradeOfferRegistry.put(new ResourceLocation("villagersplus", "sell_enchanted_book"), new JsonSellEnchantedBookTradeOffer());
        tradeOfferRegistry.put(new ResourceLocation("villagersplus", "sell_map"), new JsonSellStructureMapTradeOffer());
    }

    public static void deserializeJson(JsonObject jsonRoot) {
        ResourceLocation professionId = ResourceLocation.m_135820_((String)jsonRoot.get("profession").getAsString());
        BuiltInRegistries.f_256735_.m_6612_(professionId).ifPresent(villagerProfession -> TradeOfferManager.deserializeTrades(jsonRoot, (integer, factory) -> TradeOfferRegistryLoader.registerVillagerTrade(villagerProfession, integer, factory)));
    }

    private static void deserializeTrades(@NotNull JsonObject jsonRoot, BiConsumer<Integer, VillagerTrades.ItemListing> tradeConsumer) {
        for (Map.Entry entry : jsonRoot.get("trades").getAsJsonObject().entrySet()) {
            int level = professionMapping.get(entry.getKey());
            JsonArray tradesArray = ((JsonElement)entry.getValue()).getAsJsonArray();
            for (JsonElement tradeElement : tradesArray) {
                JsonObject trade = tradeElement.getAsJsonObject();
                JsonTradeOffer adapter = tradeOfferRegistry.get(ResourceLocation.m_135820_((String)trade.get("type").getAsString()));
                if (adapter == null) {
                    VillagersPlus.LOGGER.error("Trade type: " + trade.get("type").getAsString() + " is broken.");
                    VillagersPlus.LOGGER.error("Error in deserializing trades.Trade element: " + tradeElement + " and Trade: " + trade + " in " + tradesArray + " is broken. \nSending faulty JSON: " + jsonRoot);
                    continue;
                }
                tradeConsumer.accept(level, adapter.deserialize(trade));
            }
        }
    }

    static {
        professionMapping.put("novice", 1);
        professionMapping.put("apprentice", 2);
        professionMapping.put("journeyman", 3);
        professionMapping.put("expert", 4);
        professionMapping.put("master", 5);
    }
}

