/*
 * Decompiled with CFR 0.152.
 */
package com.lion.villagersplus.platform.forge;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lion.villagersplus.VillagersPlus;
import com.lion.villagersplus.tradeoffers.TradeOfferManager;
import com.lion.villagersplus.tradeoffers.TradeOfferRegistryLoader;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;

public class TradeOfferResourceListener
extends SimpleJsonResourceReloadListener
implements PreparableReloadListener {
    public TradeOfferResourceListener() {
        super(new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().setLenient().create(), "villager_trades");
    }

    protected void apply(Map<ResourceLocation, JsonElement> loader, ResourceManager manager, ProfilerFiller profiler) {
        for (PackResources pack : manager.m_7536_().collect(Collectors.toList())) {
            try {
                for (VillagerProfession villager : BuiltInRegistries.f_256735_.m_123024_().collect(Collectors.toList())) {
                    this.loadAndMergeTradeOffers(pack, villager);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void loadAndMergeTradeOffers(PackResources pack, VillagerProfession villager) throws IOException {
        IoSupplier tradeInputStreamSupplier;
        String id = villager.f_35600_();
        if (id.contains(":")) {
            id = id.split(":")[1];
        }
        if ((tradeInputStreamSupplier = pack.m_214146_(PackType.SERVER_DATA, new ResourceLocation("villagersplus", "villager_trades/" + id + ".json"))) == null || tradeInputStreamSupplier.m_247737_() == null) {
            return;
        }
        VillagersPlus.LOGGER.info("Deserializing datapack added trades of profession: villagersplus:" + villager + " from " + pack.m_5542_());
        JsonObject tradeData = (JsonObject)new Gson().fromJson((Reader)new InputStreamReader((InputStream)tradeInputStreamSupplier.m_247737_()), JsonObject.class);
        TradeOfferManager.deserializeJson(tradeData);
        HashMap<VillagerProfession, Int2ObjectOpenHashMap<VillagerTrades.ItemListing[]>> datapackTrades = TradeOfferRegistryLoader.getRegistryForLoading();
        VillagerTrades.f_35627_.forEach((profession, defaultProfessionTrades) -> {
            Int2ObjectOpenHashMap datapackProfessionTrades = datapackTrades.getOrDefault(profession, new Int2ObjectOpenHashMap());
            datapackProfessionTrades.forEach((level, datapackLevelTrades) -> {
                VillagerTrades.ItemListing[] defaultLevelTrades = (VillagerTrades.ItemListing[])defaultProfessionTrades.get(level);
                VillagerTrades.ItemListing[] mergedTrades = (VillagerTrades.ItemListing[])Stream.concat(defaultLevelTrades != null ? Arrays.stream(defaultLevelTrades) : Stream.empty(), Arrays.stream(datapackLevelTrades)).distinct().toArray(VillagerTrades.ItemListing[]::new);
                defaultProfessionTrades.put(level, (Object)mergedTrades);
            });
        });
    }
}

