/*
 * Decompiled with CFR 0.152.
 */
package com.lion.villagersplus.platform.forge;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.lion.villagersplus.VillagersPlus;
import com.lion.villagersplus.tradeoffers.TradeOfferManager;
import com.lion.villagersplus.tradeoffers.TradeOfferRegistryLoader;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.npc.VillagerTrades;

public class DefaultTradeOfferResourceListener
extends SimpleJsonResourceReloadListener
implements PreparableReloadListener {
    public DefaultTradeOfferResourceListener() {
        super(new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().setLenient().create(), "default_villager_trades");
    }

    protected void apply(Map<ResourceLocation, JsonElement> loader, ResourceManager manager, ProfilerFiller profiler) {
        loader.forEach((identifier, jsonElement) -> {
            if (!jsonElement.isJsonObject()) {
                return;
            }
            VillagersPlus.LOGGER.info("Deserializing default trades of profession: " + jsonElement.getAsJsonObject().get("profession").getAsString());
            TradeOfferManager.deserializeJson(jsonElement.getAsJsonObject());
        });
        VillagerTrades.f_35627_.putAll(TradeOfferRegistryLoader.getRegistryForLoading());
    }
}

