/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4fc;

public class TextureBatchedRenderer {
    private final Map<ResourceLocation, List<TextureEmit>> batch = new HashMap<ResourceLocation, List<TextureEmit>>();

    public void emitTexture(GuiGraphics context, ResourceLocation texture, int x, int y, int width, int height, Vector4fc color) {
        this.emitTextureBatched(context, texture, x, y, x + width, y + height, 0.0f, 0.0f, 1.0f, 1.0f, color);
    }

    public void emitTexture(GuiGraphics context, ResourceLocation texture, int x, int y, int width, int height, float minU, float minV, float maxU, float maxV, Vector4fc color) {
        this.emitTextureBatched(context, texture, x, y, x + width, y + height, minU, minV, maxU, maxV, color);
    }

    public void emitSpriteStretch(GuiGraphics context, TextureAtlasSprite sprite, int x, int y, int width, int height, Vector4fc color) {
        this.emitTextureBatched(context, sprite.m_247685_(), x, y, x + width, y + height, sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118412_(), color);
    }

    private void emitTextureBatched(GuiGraphics context, ResourceLocation texture, float minX, float minY, float maxX, float maxY, float minU, float minV, float maxU, float maxV, Vector4fc color) {
        List emits = this.batch.computeIfAbsent(texture, key -> new ArrayList());
        Matrix4f matrix = context.m_280168_().m_85850_().m_252922_();
        Vector3f v1 = matrix.transformPosition(new Vector3f(minX, minY, 0.0f));
        Vector3f v2 = matrix.transformPosition(new Vector3f(minX, maxY, 0.0f));
        Vector3f v3 = matrix.transformPosition(new Vector3f(maxX, maxY, 0.0f));
        Vector3f v4 = matrix.transformPosition(new Vector3f(maxX, minY, 0.0f));
        emits.add(new TextureEmit(v1.x, v1.y, v1.z, v2.x, v2.y, v2.z, v3.x, v3.y, v3.z, v4.x, v4.y, v4.z, minU, minV, maxU, maxV, color));
    }

    public void draw() {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::m_172814_);
        for (Map.Entry<ResourceLocation, List<TextureEmit>> entry : this.batch.entrySet()) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)entry.getKey());
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
            for (TextureEmit emit : entry.getValue()) {
                bufferBuilder.m_5483_((double)emit.x1, (double)emit.y1, (double)emit.z1).m_85950_(emit.color.x(), emit.color.y(), emit.color.z(), emit.color.w()).m_7421_(emit.minU, emit.minV).m_5752_();
                bufferBuilder.m_5483_((double)emit.x2, (double)emit.y2, (double)emit.z2).m_85950_(emit.color.x(), emit.color.y(), emit.color.z(), emit.color.w()).m_7421_(emit.minU, emit.maxV).m_5752_();
                bufferBuilder.m_5483_((double)emit.x3, (double)emit.y3, (double)emit.z3).m_85950_(emit.color.x(), emit.color.y(), emit.color.z(), emit.color.w()).m_7421_(emit.maxU, emit.maxV).m_5752_();
                bufferBuilder.m_5483_((double)emit.x4, (double)emit.y4, (double)emit.z4).m_85950_(emit.color.x(), emit.color.y(), emit.color.z(), emit.color.w()).m_7421_(emit.maxU, emit.minV).m_5752_();
            }
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        }
        this.batch.clear();
    }

    private record TextureEmit(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, float minU, float minV, float maxU, float maxV, Vector4fc color) {
    }
}

