/*
 * Decompiled with CFR 0.152.
 */
package com.temporal.api.core.event.data.model.block;

import com.temporal.api.common.block.LogBlock;
import com.temporal.api.core.engine.IOLayer;
import com.temporal.api.core.engine.io.resource.InjectedResourceLocation;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.StringUtils;

public abstract class ApiBlockStateProvider
extends BlockStateProvider {
    public ApiBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, IOLayer.FORGE_MOD.getModId(), exFileHelper);
    }

    protected void registerCubedBlock(RegistryObject<Block> blockRegistryObject) {
        Block block = (Block)blockRegistryObject.get();
        this.simpleBlockWithItem(block, this.cubeAll(block));
    }

    protected void registerButtonBlock(RegistryObject<ButtonBlock> blockRegistryObject) {
        ButtonBlock block = (ButtonBlock)blockRegistryObject.get();
        this.buttonBlock(block, this.getLocation(blockRegistryObject));
    }

    protected void registerDoorBlock(RegistryObject<DoorBlock> blockRegistryObject) {
        DoorBlock block = (DoorBlock)blockRegistryObject.get();
        String path = "block/" + blockRegistryObject.getId().m_135815_();
        this.doorBlock(block, new InjectedResourceLocation(path + "_top"), new InjectedResourceLocation(path + "_bottom"));
    }

    protected void registerFenceBlock(RegistryObject<FenceBlock> blockRegistryObject) {
        FenceBlock block = (FenceBlock)blockRegistryObject.get();
        this.fenceBlock(block, this.getLocation(blockRegistryObject));
    }

    protected void registerFenceGateBlock(RegistryObject<FenceGateBlock> blockRegistryObject) {
        FenceGateBlock block = (FenceGateBlock)blockRegistryObject.get();
        this.fenceGateBlock(block, this.getLocation(blockRegistryObject));
    }

    protected void registerPressurePlateBlock(RegistryObject<PressurePlateBlock> blockRegistryObject) {
        PressurePlateBlock block = (PressurePlateBlock)blockRegistryObject.get();
        this.pressurePlateBlock(block, this.getLocation(blockRegistryObject));
    }

    protected void registerSignBlock(RegistryObject<StandingSignBlock> standingSignBlockRegistryObject, RegistryObject<WallSignBlock> wallSignBlockRegistryObject) {
        StandingSignBlock standingSignBlock = (StandingSignBlock)standingSignBlockRegistryObject.get();
        WallSignBlock wallSignBlock = (WallSignBlock)wallSignBlockRegistryObject.get();
        this.signBlock(standingSignBlock, wallSignBlock, this.getLocation(wallSignBlockRegistryObject));
    }

    protected void registerSlabBlock(RegistryObject<SlabBlock> blockRegistryObject) {
        SlabBlock block = (SlabBlock)blockRegistryObject.get();
        String path = blockRegistryObject.getId().m_135815_();
        InjectedResourceLocation texture = new InjectedResourceLocation("block/" + StringUtils.substringBefore((String)path, (String)"_slab"));
        this.slabBlock(block, texture, texture);
        this.simpleBlockItem((Block)block, (ModelFile)this.models().slab(path, (ResourceLocation)texture, (ResourceLocation)texture, (ResourceLocation)texture));
    }

    protected void registerSlabBlock(RegistryObject<SlabBlock> slabBlockRegistryObject, RegistryObject<Block> blockRegistryObject) {
        SlabBlock block = (SlabBlock)slabBlockRegistryObject.get();
        this.slabBlock(block, this.getLocation(blockRegistryObject), this.getLocation(blockRegistryObject));
    }

    protected void registerStairsBlock(RegistryObject<StairBlock> blockRegistryObject) {
        StairBlock block = (StairBlock)blockRegistryObject.get();
        this.stairsBlock(block, this.getLocation(blockRegistryObject));
    }

    protected void registerTrapdoorBlock(RegistryObject<TrapDoorBlock> blockRegistryObject) {
        this.registerTrapdoorBlock(blockRegistryObject, true);
    }

    protected void registerTrapdoorBlock(RegistryObject<TrapDoorBlock> blockRegistryObject, boolean orientable) {
        TrapDoorBlock block = (TrapDoorBlock)blockRegistryObject.get();
        this.trapdoorBlock(block, this.getLocation(blockRegistryObject), orientable);
    }

    protected void registerWallBlock(RegistryObject<WallBlock> blockRegistryObject) {
        WallBlock block = (WallBlock)blockRegistryObject.get();
        this.wallBlock(block, this.getLocation(blockRegistryObject));
    }

    protected void registerLogBlock(RegistryObject<LogBlock> blockRegistryObject) {
        LogBlock block = (LogBlock)((Object)blockRegistryObject.get());
        this.logBlock(block);
    }

    protected void registerRotatedPillarBlock(RegistryObject<RotatedPillarBlock> blockRegistryObject) {
        RotatedPillarBlock block = (RotatedPillarBlock)blockRegistryObject.get();
        this.axisBlock(block);
    }

    protected ResourceLocation getLocation(RegistryObject<?> registryObject) {
        return new InjectedResourceLocation("block/" + registryObject.getId().m_135815_());
    }
}

