/*
 * Decompiled with CFR 0.152.
 */
package com.temporal.api.core.event.data;

import com.temporal.api.core.event.data.DataGatherer;
import com.temporal.api.core.event.data.loot.LootTableProviderFactory;
import com.temporal.api.core.event.data.model.block.BlockStateProvider;
import com.temporal.api.core.event.data.model.item.ItemModelProvider;
import com.temporal.api.core.event.data.recipe.ApiRecipeProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.NotNull;

public class ApiDataGenerator
implements DataGatherer {
    @Override
    public void gatherData(GatherDataEvent event) {
        this.addLootTableProvider(event);
        this.addModelProvider(event);
        this.addRecipeProvider(event);
    }

    @Override
    public void addLootTableProvider(GatherDataEvent event) {
        DataGenerator generator = this.getDataGenerator(event);
        PackOutput packOutput = this.getPackOutput(event);
        generator.addProvider(event.includeServer(), (DataProvider)LootTableProviderFactory.createWithSelfDrop(packOutput));
    }

    @Override
    public void addModelProvider(GatherDataEvent event) {
        DataGenerator generator = this.getDataGenerator(event);
        PackOutput packOutput = this.getPackOutput(event);
        ExistingFileHelper existingFileHelper = this.getExistingFileHelper(event);
        generator.addProvider(event.includeClient(), (DataProvider)new BlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModelProvider(packOutput, existingFileHelper));
    }

    @Override
    public void addRecipeProvider(GatherDataEvent event) {
        DataGenerator generator = this.getDataGenerator(event);
        PackOutput packOutput = this.getPackOutput(event);
        generator.addProvider(event.includeServer(), (DataProvider)new ApiRecipeProvider(packOutput));
    }

    @Override
    public ExistingFileHelper getExistingFileHelper(GatherDataEvent event) {
        return event.getExistingFileHelper();
    }

    @Override
    @NotNull
    public PackOutput getPackOutput(GatherDataEvent event) {
        return this.getDataGenerator(event).getPackOutput();
    }

    @Override
    public DataGenerator getDataGenerator(GatherDataEvent event) {
        return event.getGenerator();
    }
}

