/*
 * Decompiled with CFR 0.152.
 */
package com.temporal.api.core.engine.io.metadata;

import com.temporal.api.ApiMod;
import com.temporal.api.core.engine.io.context.InjectionContext;
import com.temporal.api.core.engine.io.metadata.AnnotationStrategyExecutor;
import com.temporal.api.core.engine.io.metadata.strategy.ObjectStrategy;
import com.temporal.api.core.engine.io.metadata.strategy.field.FieldAnnotationStrategy;
import com.temporal.api.core.engine.io.metadata.strategy.method.MethodAnnotationStrategy;
import com.temporal.api.core.engine.io.metadata.strategy.type.ClassAnnotationStrategy;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class DefaultAnnotationStrategyExecutor
implements AnnotationStrategyExecutor {
    private static volatile DefaultAnnotationStrategyExecutor instance;

    private DefaultAnnotationStrategyExecutor() {
    }

    @Override
    public void executeClass(ClassAnnotationStrategy strategy, Class<?> clazz) {
        try {
            strategy.execute(clazz, (Object)null);
            this.logScanning(strategy, clazz);
        }
        catch (Exception e) {
            this.logException(e, strategy, clazz);
        }
    }

    @Override
    public void executeStaticField(FieldAnnotationStrategy strategy, Class<?> clazz) {
        try {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                strategy.execute(field, (Object)null);
                this.logScanning(strategy, clazz);
            }
        }
        catch (Exception e) {
            this.logException(e, strategy, clazz);
        }
    }

    @Override
    public void executeField(FieldAnnotationStrategy strategy, Class<?> clazz) {
        try {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                strategy.execute(field, InjectionContext.getFromInstance(clazz));
                this.logScanning(strategy, clazz);
            }
        }
        catch (Exception e) {
            this.logException(e, strategy, clazz);
        }
    }

    @Override
    public void executeMethod(MethodAnnotationStrategy strategy, Class<?> clazz) {
        try {
            Method[] methods;
            for (Method method : methods = clazz.getDeclaredMethods()) {
                strategy.execute(method, InjectionContext.getFromInstance(clazz));
                this.logScanning(strategy, clazz);
            }
        }
        catch (Exception e) {
            this.logException(e, strategy, clazz);
        }
    }

    private void logScanning(ObjectStrategy<?> strategy, Class<?> clazz) {
        ApiMod.LOGGER.info("Scanned: strategy - {}, class - {}", (Object)strategy.getClass().getSimpleName(), (Object)clazz.getSimpleName());
    }

    private void logException(Exception e, ObjectStrategy<?> strategy, Class<?> clazz) {
        ApiMod.LOGGER.warn("{} in {} went wrong! - {}", new Object[]{strategy.getClass().getSimpleName(), clazz.getSimpleName(), e.getMessage()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AnnotationStrategyExecutor getInstance() {
        if (instance != null) return instance;
        Class<DefaultAnnotationStrategyExecutor> clazz = DefaultAnnotationStrategyExecutor.class;
        synchronized (DefaultAnnotationStrategyExecutor.class) {
            if (instance != null) return instance;
            instance = new DefaultAnnotationStrategyExecutor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }
}

