/*
 * Decompiled with CFR 0.152.
 */
package com.temporal.api.core.engine.io.metadata;

import com.temporal.api.core.engine.io.IOHelper;
import com.temporal.api.core.engine.io.metadata.AnnotationExecutor;
import com.temporal.api.core.engine.io.metadata.AnnotationStrategyExecutor;
import com.temporal.api.core.engine.io.metadata.DefaultAnnotationStrategyExecutor;
import com.temporal.api.core.engine.io.metadata.annotation.Injected;
import com.temporal.api.core.engine.io.metadata.strategy.field.BlockLootTableStrategy;
import com.temporal.api.core.engine.io.metadata.strategy.field.BlockModelStrategy;
import com.temporal.api.core.engine.io.metadata.strategy.field.DependencyStrategy;
import com.temporal.api.core.engine.io.metadata.strategy.field.InjectionStrategy;
import com.temporal.api.core.engine.io.metadata.strategy.field.ItemModelStrategy;
import com.temporal.api.core.engine.io.metadata.strategy.field.RecipeStrategy;
import com.temporal.api.core.engine.io.metadata.strategy.field.RegistryFieldStrategy;
import com.temporal.api.core.engine.io.metadata.strategy.method.ExecutionStrategy;
import com.temporal.api.core.engine.io.metadata.strategy.type.InjectedStrategy;
import com.temporal.api.core.engine.io.metadata.strategy.type.RegistryClassStrategy;
import java.util.Set;

public class DefaultAnnotationExecutor
implements AnnotationExecutor {
    private volatile Set<Class<?>> classes;
    private volatile AnnotationStrategyExecutor strategyExecutor;

    @Override
    public void prepareBeforeExecution(Class<?> dependencyClass) {
        this.classes = IOHelper.getAllClasses(dependencyClass, Injected.class);
        this.strategyExecutor = DefaultAnnotationStrategyExecutor.getInstance();
    }

    @Override
    public void executeClassAnnotations() {
        InjectedStrategy injectedStrategy = new InjectedStrategy();
        RegistryClassStrategy registryClassStrategy = new RegistryClassStrategy();
        this.classes.forEach(clazz -> {
            this.strategyExecutor.executeClass(injectedStrategy, (Class<?>)clazz);
            this.strategyExecutor.executeClass(registryClassStrategy, (Class<?>)clazz);
        });
    }

    @Override
    public void executeFieldAnnotations() {
        InjectionStrategy injectionStrategy = new InjectionStrategy();
        DependencyStrategy dependencyStrategy = new DependencyStrategy();
        RegistryFieldStrategy registryFieldStrategy = new RegistryFieldStrategy();
        this.classes.forEach(clazz -> {
            this.strategyExecutor.executeField(injectionStrategy, (Class<?>)clazz);
            this.strategyExecutor.executeField(dependencyStrategy, (Class<?>)clazz);
            this.strategyExecutor.executeField(registryFieldStrategy, (Class<?>)clazz);
        });
    }

    @Override
    public void executeMethodAnnotations() {
        ExecutionStrategy executionStrategy = new ExecutionStrategy();
        this.classes.forEach(clazz -> this.strategyExecutor.executeMethod(executionStrategy, (Class<?>)clazz));
    }

    @Override
    public void executeDataGenerationAnnotations() {
        BlockModelStrategy blockModelStrategy = new BlockModelStrategy();
        ItemModelStrategy itemModelStrategy = new ItemModelStrategy();
        BlockLootTableStrategy blockLootTableStrategy = new BlockLootTableStrategy();
        RecipeStrategy recipeStrategy = new RecipeStrategy();
        this.classes.forEach(clazz -> {
            this.strategyExecutor.executeStaticField(blockModelStrategy, (Class<?>)clazz);
            this.strategyExecutor.executeStaticField(itemModelStrategy, (Class<?>)clazz);
            this.strategyExecutor.executeStaticField(blockLootTableStrategy, (Class<?>)clazz);
            this.strategyExecutor.executeStaticField(recipeStrategy, (Class<?>)clazz);
        });
    }
}

