/*
 * Decompiled with CFR 0.152.
 */
package com.temporal.api.core.engine;

import com.temporal.api.core.engine.EngineLayer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LayerContainer {
    private static volatile LayerContainer instance;
    private final List<EngineLayer> layers = new ArrayList<EngineLayer>();

    private LayerContainer() {
    }

    protected void addAll(Collection<EngineLayer> engineLayers) {
        this.layers.addAll(engineLayers);
    }

    protected void add(EngineLayer engineLayer) {
        this.layers.add(engineLayer);
    }

    public List<EngineLayer> getLayers() {
        return this.layers;
    }

    public EngineLayer getLayer(Integer id) {
        return this.layers.get(id);
    }

    public <T extends EngineLayer> T getLayer(Class<? extends EngineLayer> layer) {
        return (T)this.layers.stream().filter(iterationLayer -> iterationLayer.getClass().equals(layer)).findAny().orElseThrow();
    }

    protected void delete(Class<? extends EngineLayer> layer) {
        this.layers.removeIf(engineLayer -> engineLayer.getClass().equals(layer));
    }

    protected void deleteAll(Collection<Class<? extends EngineLayer>> layers) {
        layers.forEach(this::delete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LayerContainer getInstance() {
        if (instance != null) return instance;
        Class<LayerContainer> clazz = LayerContainer.class;
        synchronized (LayerContainer.class) {
            if (instance != null) return instance;
            instance = new LayerContainer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }
}

