/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.serialization;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Objects;
import org.sinytra.adapter.patch.api.MethodTransform;
import org.sinytra.adapter.patch.transformer.ChangeModifiedVariableIndex;
import org.sinytra.adapter.patch.transformer.DisableMixin;
import org.sinytra.adapter.patch.transformer.ModifyInjectionPoint;
import org.sinytra.adapter.patch.transformer.ModifyInjectionTarget;
import org.sinytra.adapter.patch.transformer.ModifyMethodAccess;
import org.sinytra.adapter.patch.transformer.ModifyMethodParams;
import org.sinytra.adapter.patch.transformer.SoftMethodParamsPatch;
import org.sinytra.adapter.patch.transformer.filter.InjectionPointTransformerFilter;
import org.sinytra.adapter.patch.transformer.param.TransformParameters;

public class MethodTransformSerialization {
    public static final Codec<MethodTransform> METHOD_TRANSFORM_CODEC = Codec.STRING.partialDispatch("type", transform -> DataResult.success((Object)MethodTransformSerialization.getTransformName(transform)), name -> {
        Codec entryCodec = (Codec)TRANSFORMER_CODECS.get(name);
        if (entryCodec != null) {
            return DataResult.success((Object)entryCodec);
        }
        return DataResult.error(() -> "Missing codec for transformer " + name);
    });
    private static final BiMap<String, Codec<? extends MethodTransform>> TRANSFORMER_CODECS = ImmutableBiMap.builder().put((Object)"disable_mixin", DisableMixin.CODEC).put((Object)"change_modified_variable", ChangeModifiedVariableIndex.CODEC).put((Object)"modify_injection_point", ModifyInjectionPoint.CODEC).put((Object)"modify_injection_target", ModifyInjectionTarget.CODEC).put((Object)"modfiy_access", ModifyMethodAccess.CODEC).put((Object)"modify_method", ModifyMethodParams.CODEC).put((Object)"transform_parameters", TransformParameters.CODEC).put((Object)"soft_modify_method", SoftMethodParamsPatch.CODEC).put((Object)"injection_point_filter", InjectionPointTransformerFilter.CODEC).build();

    private static String getTransformName(MethodTransform transform) {
        return Objects.requireNonNull((String)TRANSFORMER_CODECS.inverse().get(transform.codec()), "Missing name for transformer " + transform);
    }
}

