/*
 * Decompiled with CFR 0.152.
 */
package me.fzzyhmstrs.fzzy_config.util;

import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.Watchable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import me.fzzyhmstrs.fzzy_config.config.Config;
import me.fzzyhmstrs.fzzy_config.config.ConfigEntry;
import me.fzzyhmstrs.fzzy_config.impl.ConfigApiImpl;
import me.fzzyhmstrs.fzzy_config.util.FcText;
import me.fzzyhmstrs.fzzy_config.util.ValidationResult;
import net.peanuuutz.tomlkt.TomlTable;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u000256B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JW\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\"\u0010\r\u001a\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020\f0\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000e2\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\r\u0010\u0014\u001a\u00020\f\u00a2\u0006\u0004\b\u0014\u0010\u0003J\u001d\u0010\u0017\u001a\u00020\f2\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\t\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001b\u0010\u001cR\"\u0010\u001f\u001a\n \u001e*\u0004\u0018\u00010\u001d0\u001d8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"R\u001c\u0010$\u001a\n \u001e*\u0004\u0018\u00010#0#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u0014\u0010'\u001a\u00020&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010(R\u001c\u0010+\u001a\n \u001e*\u0004\u0018\u00010*0*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,R@\u00100\u001a.\u0012\u0004\u0012\u00020.\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00150\t0-j\u0016\u0012\u0004\u0012\u00020.\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00150\t`/8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u00101R\u001a\u00103\u001a\b\u0012\u0004\u0012\u00020.028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00104\u00a8\u00067"}, d2={"Lme/fzzyhmstrs/fzzy_config/util/ThreadingUtils;", "", "<init>", "()V", "", "flags", "Ljava/util/concurrent/Executor;", "executor", "Lkotlin/Function2;", "Lme/fzzyhmstrs/fzzy_config/config/ConfigEntry;", "Lme/fzzyhmstrs/fzzy_config/util/ValidationResult;", "Lnet/peanuuutz/tomlkt/TomlTable;", "", "applier", "Lkotlin/Function0;", "updater", "Lme/fzzyhmstrs/fzzy_config/impl/ConfigApiImpl$PermissionChecker;", "permissionCheck", "start", "(BLjava/util/concurrent/Executor;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function0;Lme/fzzyhmstrs/fzzy_config/impl/ConfigApiImpl$PermissionChecker;)V", "stop", "Lme/fzzyhmstrs/fzzy_config/config/Config;", "entry", "register", "(Lme/fzzyhmstrs/fzzy_config/config/ConfigEntry;)V", "Ljava/io/File;", "file", "update", "(Ljava/io/File;)V", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "EXECUTOR", "Ljava/util/concurrent/ExecutorService;", "getEXECUTOR$fzzy_config", "()Ljava/util/concurrent/ExecutorService;", "Ljava/util/concurrent/ScheduledExecutorService;", "FILE_WATCHER", "Ljava/util/concurrent/ScheduledExecutorService;", "Ljava/util/concurrent/locks/ReentrantLock;", "watcherLock", "Ljava/util/concurrent/locks/ReentrantLock;", "updatesLock", "Ljava/nio/file/WatchService;", "watchService", "Ljava/nio/file/WatchService;", "Ljava/util/HashMap;", "Ljava/nio/file/Path;", "Lkotlin/collections/HashMap;", "configWatchers", "Ljava/util/HashMap;", "", "internalUpdates", "Ljava/util/Set;", "Factory", "FileFactory", "fzzy_config"})
public final class ThreadingUtils {
    @NotNull
    public static final ThreadingUtils INSTANCE = new ThreadingUtils();
    private static final ExecutorService EXECUTOR = Executors.newFixedThreadPool(6, Factory.INSTANCE);
    private static final ScheduledExecutorService FILE_WATCHER = Executors.newSingleThreadScheduledExecutor(FileFactory.INSTANCE);
    @NotNull
    private static final ReentrantLock watcherLock = new ReentrantLock();
    @NotNull
    private static final ReentrantLock updatesLock = new ReentrantLock();
    private static final WatchService watchService = FileSystems.getDefault().newWatchService();
    @NotNull
    private static final HashMap<Path, ConfigEntry<? extends Config>> configWatchers = new HashMap();
    @NotNull
    private static final Set<Path> internalUpdates = new LinkedHashSet();

    private ThreadingUtils() {
    }

    public final ExecutorService getEXECUTOR$fzzy_config() {
        return EXECUTOR;
    }

    public final void start(byte flags, @NotNull Executor executor, @NotNull Function2<? super ConfigEntry<?>, ? super ValidationResult<TomlTable>, Unit> applier, @NotNull Function0<Unit> updater, @NotNull ConfigApiImpl.PermissionChecker permissionCheck) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(applier, (String)"applier");
        Intrinsics.checkNotNullParameter(updater, (String)"updater");
        Intrinsics.checkNotNullParameter((Object)permissionCheck, (String)"permissionCheck");
        FILE_WATCHER.scheduleAtFixedRate(() -> ThreadingUtils.start$lambda$4(executor, flags, permissionCheck, applier, updater), 0L, 503L, TimeUnit.MILLISECONDS);
    }

    public final void stop() {
        watchService.close();
        FILE_WATCHER.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void register(@NotNull ConfigEntry<? extends Config> entry) {
        Intrinsics.checkNotNullParameter(entry, (String)"entry");
        try {
            watcherLock.lock();
            File file = entry.getConfig().getDir();
            Path dirPath = file.toPath();
            WatchEvent.Kind[] kindArray = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY};
            dirPath.register(watchService, kindArray);
            Path path = new File(file, FcText.INSTANCE.concat(entry.getConfig().getName(), entry.getConfig().fileType().suffix())).toPath();
            configWatchers.compute(path, (arg_0, arg_1) -> ThreadingUtils.register$lambda$6((arg_0, arg_1) -> ThreadingUtils.register$lambda$5(entry, arg_0, arg_1), arg_0, arg_1));
        }
        finally {
            watcherLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void update(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            updatesLock.lock();
            Path path = file.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            internalUpdates.add(path);
        }
        finally {
            updatesLock.unlock();
        }
    }

    private static final List start$lambda$4$lambda$0(List $entries, byte $flags, ConfigApiImpl.PermissionChecker $permissionCheck) {
        List results = new ArrayList();
        for (Pair pair : $entries) {
            Path path = (Path)pair.component1();
            ConfigEntry entry = (ConfigEntry)pair.component2();
            ValidationResult<ConfigApiImpl.FileUpdateResult> result = ConfigApiImpl.INSTANCE.deserializeFileUpdate$fzzy_config(entry, path, "Error(s) encountered while reading a changed config file", $flags, $permissionCheck).log(ValidationResult.ErrorEntry.Companion.getENTRY_ERROR_LOGGER());
            results.add(TuplesKt.to((Object)entry, result));
        }
        return results;
    }

    private static final TomlTable start$lambda$4$lambda$2$lambda$1(ConfigApiImpl.FileUpdateResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getToml();
    }

    private static final Unit start$lambda$4$lambda$2(Function2 $applier, Function0 $updater, List results) {
        Intrinsics.checkNotNull((Object)results);
        if (!((Collection)results).isEmpty()) {
            for (Pair pair : results) {
                ConfigEntry entry = (ConfigEntry)pair.component1();
                ValidationResult result = (ValidationResult)pair.component2();
                if (!result.isValid()) continue;
                ConfigApiImpl.INSTANCE.applyFileUpdate$fzzy_config((Config)entry.getConfig(), ((ConfigApiImpl.FileUpdateResult)result.get()).getWriteConfig(), "Error(s) encountered while updating a config from a changed config file");
                $applier.invoke((Object)entry, ValidationResult.Companion.map(result, ThreadingUtils::start$lambda$4$lambda$2$lambda$1));
            }
            $updater.invoke();
        }
        return Unit.INSTANCE;
    }

    private static final void start$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void start$lambda$4(Executor $executor, byte $flags, ConfigApiImpl.PermissionChecker $permissionCheck, Function2 $applier, Function0 $updater) {
        List entries = new ArrayList();
        try {
            watcherLock.lock();
            updatesLock.lock();
            WatchKey watchKey = watchService.poll();
            while (watchKey != null) {
                for (WatchEvent<?> event : watchKey.pollEvents()) {
                    ConfigEntry<? extends Config> entry;
                    if (Intrinsics.areEqual(event.kind(), StandardWatchEventKinds.OVERFLOW)) continue;
                    Object obj = event.context();
                    Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type java.nio.file.Path");
                    Path filePath = (Path)obj;
                    Watchable watchable = watchKey.watchable();
                    Intrinsics.checkNotNull((Object)watchable, (String)"null cannot be cast to non-null type java.nio.file.Path");
                    Path dir = (Path)watchable;
                    Path path = dir.resolve(filePath);
                    if (configWatchers.get(path) == null || internalUpdates.remove(path)) continue;
                    entries.add(TuplesKt.to((Object)path, entry));
                }
                watchKey.reset();
                watchKey = watchService.poll();
            }
        }
        finally {
            watcherLock.unlock();
            updatesLock.unlock();
        }
        if (entries.isEmpty()) {
            return;
        }
        CompletableFuture.supplyAsync(() -> ThreadingUtils.start$lambda$4$lambda$0(entries, $flags, $permissionCheck), EXECUTOR).thenAcceptAsync(arg_0 -> ThreadingUtils.start$lambda$4$lambda$3(arg_0 -> ThreadingUtils.start$lambda$4$lambda$2($applier, $updater, arg_0), arg_0), $executor);
    }

    private static final ConfigEntry register$lambda$5(ConfigEntry $entry, Path p, ConfigEntry e) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return e != null ? (e.getClient() && !$entry.getClient() ? e : $entry) : $entry;
    }

    private static final ConfigEntry register$lambda$6(Function2 $tmp0, Object p0, Object p1) {
        return (ConfigEntry)$tmp0.invoke(p0, p1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lme/fzzyhmstrs/fzzy_config/util/ThreadingUtils$Factory;", "Ljava/util/concurrent/ThreadFactory;", "<init>", "()V", "Ljava/lang/Runnable;", "r", "Ljava/lang/Thread;", "newThread", "(Ljava/lang/Runnable;)Ljava/lang/Thread;", "Ljava/util/concurrent/atomic/AtomicLong;", "counter", "Ljava/util/concurrent/atomic/AtomicLong;", "getCounter", "()Ljava/util/concurrent/atomic/AtomicLong;", "fzzy_config"})
    private static final class Factory
    implements ThreadFactory {
        @NotNull
        public static final Factory INSTANCE = new Factory();
        @NotNull
        private static final AtomicLong counter = new AtomicLong(0L);

        private Factory() {
        }

        @NotNull
        public final AtomicLong getCounter() {
            return counter;
        }

        @Override
        @NotNull
        public Thread newThread(@NotNull Runnable r) {
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            return new Thread(null, r, "Fzzy Config Worker-" + counter.incrementAndGet());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lme/fzzyhmstrs/fzzy_config/util/ThreadingUtils$FileFactory;", "Ljava/util/concurrent/ThreadFactory;", "<init>", "()V", "Ljava/lang/Runnable;", "r", "Ljava/lang/Thread;", "newThread", "(Ljava/lang/Runnable;)Ljava/lang/Thread;", "fzzy_config"})
    private static final class FileFactory
    implements ThreadFactory {
        @NotNull
        public static final FileFactory INSTANCE = new FileFactory();

        private FileFactory() {
        }

        @Override
        @NotNull
        public Thread newThread(@NotNull Runnable r) {
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            return new Thread(null, r, "Fzzy Config File Watcher");
        }
    }
}

