/*
 * Decompiled with CFR 0.152.
 */
package me.fzzyhmstrs.fzzy_config.networking;

import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import me.fzzyhmstrs.fzzy_config.api.ConfigApi;
import me.fzzyhmstrs.fzzy_config.impl.ConfigApiImpl;
import me.fzzyhmstrs.fzzy_config.networking.ConfigPermissionsS2CCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.ConfigSyncS2CCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.ConfigUpdateC2SCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.ConfigUpdateS2CCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.DynamicIdsS2CCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.FzzyPayload;
import me.fzzyhmstrs.fzzy_config.networking.NetworkEventsClient;
import me.fzzyhmstrs.fzzy_config.networking.SettingForwardCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.api.C2SPayloadHandler;
import me.fzzyhmstrs.fzzy_config.networking.api.ClientPlayNetworkContext;
import me.fzzyhmstrs.fzzy_config.networking.api.S2CPayloadHandler;
import me.fzzyhmstrs.fzzy_config.networking.api.ServerPlayNetworkContext;
import me.fzzyhmstrs.fzzy_config.registry.SyncedConfigRegistry;
import me.fzzyhmstrs.fzzy_config.util.ThreadingUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.GameShuttingDownEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ!\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ%\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J%\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00172\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J%\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00172\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0019J\u001f\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001f\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0015\u0010\"\u001a\u00020\r2\u0006\u0010!\u001a\u00020 \u00a2\u0006\u0004\b\"\u0010#J\u0015\u0010%\u001a\u00020\r2\u0006\u0010!\u001a\u00020$\u00a2\u0006\u0004\b%\u0010&J\r\u0010'\u001a\u00020\r\u00a2\u0006\u0004\b'\u0010\u0003J\u0015\u0010)\u001a\u00020\r2\u0006\u0010!\u001a\u00020(\u00a2\u0006\u0004\b)\u0010*J\u0015\u0010,\u001a\u00020\r2\u0006\u0010!\u001a\u00020+\u00a2\u0006\u0004\b,\u0010-\u00a8\u0006."}, d2={"Lme/fzzyhmstrs/fzzy_config/networking/NetworkEvents;", "", "<init>", "()V", "Lnet/minecraft/server/level/ServerPlayer;", "playerEntity", "Lnet/minecraft/resources/ResourceLocation;", "id", "", "canSend", "(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/resources/ResourceLocation;)Z", "Lnet/minecraft/network/protocol/Packet;", "packet", "", "send", "(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/network/protocol/Packet;)V", "Lme/fzzyhmstrs/fzzy_config/networking/ConfigUpdateC2SCustomPayload;", "payload", "Ljava/util/function/Supplier;", "Lnet/minecraftforge/network/NetworkEvent$Context;", "context", "handleUpdate", "(Lme/fzzyhmstrs/fzzy_config/networking/ConfigUpdateC2SCustomPayload;Ljava/util/function/Supplier;)V", "Lme/fzzyhmstrs/fzzy_config/networking/SettingForwardCustomPayload;", "handleSettingForwardBidirectional", "(Lme/fzzyhmstrs/fzzy_config/networking/SettingForwardCustomPayload;Ljava/util/function/Supplier;)V", "handleSettingForward", "Lme/fzzyhmstrs/fzzy_config/networking/api/ServerPlayNetworkContext;", "receiveUpdate", "(Lme/fzzyhmstrs/fzzy_config/networking/ConfigUpdateC2SCustomPayload;Lme/fzzyhmstrs/fzzy_config/networking/api/ServerPlayNetworkContext;)V", "receiveForward", "(Lme/fzzyhmstrs/fzzy_config/networking/SettingForwardCustomPayload;Lme/fzzyhmstrs/fzzy_config/networking/api/ServerPlayNetworkContext;)V", "Lnet/minecraftforge/event/OnDatapackSyncEvent;", "event", "registerDataSync", "(Lnet/minecraftforge/event/OnDatapackSyncEvent;)V", "Lnet/minecraftforge/network/NetworkEvent$GatherLoginPayloadsEvent;", "registerConfigurations", "(Lnet/minecraftforge/network/NetworkEvent$GatherLoginPayloadsEvent;)V", "registerPayloads", "Lnet/minecraftforge/event/server/ServerStartedEvent;", "serverStarted", "(Lnet/minecraftforge/event/server/ServerStartedEvent;)V", "Lnet/minecraftforge/event/GameShuttingDownEvent;", "gameStopping", "(Lnet/minecraftforge/event/GameShuttingDownEvent;)V", "fzzy_config"})
public final class NetworkEvents {
    @NotNull
    public static final NetworkEvents INSTANCE = new NetworkEvents();

    private NetworkEvents() {
    }

    public final boolean canSend(@NotNull ServerPlayer playerEntity, @NotNull ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)playerEntity, (String)"playerEntity");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return playerEntity.f_8906_.m_6198_();
    }

    public final void send(@NotNull ServerPlayer playerEntity, @NotNull Packet<?> packet) {
        Intrinsics.checkNotNullParameter((Object)playerEntity, (String)"playerEntity");
        Intrinsics.checkNotNullParameter(packet, (String)"packet");
        PacketDistributor.PLAYER.with(() -> NetworkEvents.send$lambda$0(playerEntity)).send(packet);
    }

    private final void handleUpdate(ConfigUpdateC2SCustomPayload payload, Supplier<NetworkEvent.Context> context) {
        ServerPlayer serverPlayer = context.get().getSender();
        if (serverPlayer == null) {
            context.get().setPacketHandled(true);
            return;
        }
        Map<String, String> map = payload.getUpdates();
        MinecraftServer minecraftServer = serverPlayer.f_8924_;
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"server");
        SyncedConfigRegistry.INSTANCE.receiveConfigUpdate$fzzy_config(map, minecraftServer, serverPlayer, payload.getPlayerPerm(), payload.getChangeHistory(), NetworkEvents::handleUpdate$lambda$1, NetworkEvents::handleUpdate$lambda$2);
        context.get().setPacketHandled(true);
    }

    private final void handleSettingForwardBidirectional(SettingForwardCustomPayload payload, Supplier<NetworkEvent.Context> context) {
        if (context.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            NetworkEventsClient.INSTANCE.handleSettingForward(payload, context);
        } else {
            this.handleSettingForward(payload, context);
        }
        context.get().setPacketHandled(true);
    }

    private final void handleSettingForward(SettingForwardCustomPayload payload, Supplier<NetworkEvent.Context> context) {
        ServerPlayer serverPlayer = context.get().getSender();
        if (serverPlayer == null) {
            context.get().setPacketHandled(true);
            return;
        }
        SyncedConfigRegistry.INSTANCE.receiveSettingForward$fzzy_config(payload.getPlayer(), serverPlayer, payload.getScope(), payload.getUpdate(), payload.getSummary(), NetworkEvents::handleSettingForward$lambda$3, NetworkEvents::handleSettingForward$lambda$4);
        context.get().setPacketHandled(true);
    }

    private final void receiveUpdate(ConfigUpdateC2SCustomPayload payload, ServerPlayNetworkContext context) {
        Map<String, String> map = payload.getUpdates();
        MinecraftServer minecraftServer = context.player().f_8924_;
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"server");
        SyncedConfigRegistry.INSTANCE.receiveConfigUpdate$fzzy_config(map, minecraftServer, context.player(), payload.getPlayerPerm(), payload.getChangeHistory(), (arg_0, arg_1) -> NetworkEvents.receiveUpdate$lambda$5(context, arg_0, arg_1), (arg_0, arg_1) -> NetworkEvents.receiveUpdate$lambda$6(context, arg_0, arg_1));
    }

    private final void receiveForward(SettingForwardCustomPayload payload, ServerPlayNetworkContext context) {
        SyncedConfigRegistry.INSTANCE.receiveSettingForward$fzzy_config(payload.getPlayer(), context.player(), payload.getScope(), payload.getUpdate(), payload.getSummary(), (arg_0, arg_1) -> NetworkEvents.receiveForward$lambda$7(context, arg_0, arg_1), (arg_0, arg_1) -> NetworkEvents.receiveForward$lambda$8(context, arg_0, arg_1));
    }

    public final void registerDataSync(@NotNull OnDatapackSyncEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ServerPlayer serverPlayer = event.getPlayer();
        if (serverPlayer == null) {
            List list = event.getPlayerList().m_11314_();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayerList(...)");
            SyncedConfigRegistry.INSTANCE.onEndDataReload$fzzy_config(list, NetworkEvents::registerDataSync$lambda$9, NetworkEvents::registerDataSync$lambda$10);
            ConfigApiImpl.INSTANCE.invalidateLookup$fzzy_config();
        } else {
            MinecraftServer minecraftServer = serverPlayer.f_8924_;
            Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"server");
            SyncedConfigRegistry.INSTANCE.onJoin$fzzy_config(serverPlayer, minecraftServer, NetworkEvents::registerDataSync$lambda$11, NetworkEvents::registerDataSync$lambda$12);
        }
    }

    public final void registerConfigurations(@NotNull NetworkEvent.GatherLoginPayloadsEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        SyncedConfigRegistry.INSTANCE.onConfigure$fzzy_config(NetworkEvents::registerConfigurations$lambda$13, arg_0 -> NetworkEvents.registerConfigurations$lambda$14(event, arg_0));
    }

    public final void registerPayloads() {
        NetworkEventsClient networkEventsClient = NetworkEventsClient.INSTANCE;
        ConfigApi.INSTANCE.network().registerLenientS2C(ConfigPermissionsS2CCustomPayload.Companion.getId(), ConfigPermissionsS2CCustomPayload.class, ConfigPermissionsS2CCustomPayload::new, new S2CPayloadHandler(networkEventsClient){
            final /* synthetic */ NetworkEventsClient $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void handle(ConfigPermissionsS2CCustomPayload p0, ClientPlayNetworkContext p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                this.$tmp0.receivePerms(p0, p1);
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(2, (Object)this.$tmp0, NetworkEventsClient.class, "receivePerms", "receivePerms(Lme/fzzyhmstrs/fzzy_config/networking/ConfigPermissionsS2CCustomPayload;Lme/fzzyhmstrs/fzzy_config/networking/api/ClientPlayNetworkContext;)V", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof S2CPayloadHandler ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        });
        networkEventsClient = NetworkEventsClient.INSTANCE;
        ConfigApi.INSTANCE.network().registerLenientS2C(ConfigSyncS2CCustomPayload.Companion.getId(), ConfigSyncS2CCustomPayload.class, ConfigSyncS2CCustomPayload::new, new S2CPayloadHandler(networkEventsClient){
            final /* synthetic */ NetworkEventsClient $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void handle(ConfigSyncS2CCustomPayload p0, ClientPlayNetworkContext p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                this.$tmp0.receiveSync(p0, p1);
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(2, (Object)this.$tmp0, NetworkEventsClient.class, "receiveSync", "receiveSync(Lme/fzzyhmstrs/fzzy_config/networking/ConfigSyncS2CCustomPayload;Lme/fzzyhmstrs/fzzy_config/networking/api/ClientPlayNetworkContext;)V", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof S2CPayloadHandler ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        });
        networkEventsClient = NetworkEventsClient.INSTANCE;
        ConfigApi.INSTANCE.network().registerLenientS2C(ConfigUpdateS2CCustomPayload.Companion.getId(), ConfigUpdateS2CCustomPayload.class, ConfigUpdateS2CCustomPayload::new, new S2CPayloadHandler(networkEventsClient){
            final /* synthetic */ NetworkEventsClient $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void handle(ConfigUpdateS2CCustomPayload p0, ClientPlayNetworkContext p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                this.$tmp0.receiveUpdate(p0, p1);
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(2, (Object)this.$tmp0, NetworkEventsClient.class, "receiveUpdate", "receiveUpdate(Lme/fzzyhmstrs/fzzy_config/networking/ConfigUpdateS2CCustomPayload;Lme/fzzyhmstrs/fzzy_config/networking/api/ClientPlayNetworkContext;)V", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof S2CPayloadHandler ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        });
        ConfigApi.INSTANCE.network().registerLenientC2S(ConfigUpdateC2SCustomPayload.Companion.getId(), ConfigUpdateC2SCustomPayload.class, ConfigUpdateC2SCustomPayload::new, new C2SPayloadHandler(this){
            final /* synthetic */ NetworkEvents $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void handle(ConfigUpdateC2SCustomPayload p0, ServerPlayNetworkContext p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                NetworkEvents.access$receiveUpdate(this.$tmp0, p0, p1);
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(2, (Object)this.$tmp0, NetworkEvents.class, "receiveUpdate", "receiveUpdate(Lme/fzzyhmstrs/fzzy_config/networking/ConfigUpdateC2SCustomPayload;Lme/fzzyhmstrs/fzzy_config/networking/api/ServerPlayNetworkContext;)V", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof C2SPayloadHandler ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        });
        ConfigApi.INSTANCE.network().registerLenientC2S(SettingForwardCustomPayload.Companion.getId(), SettingForwardCustomPayload.class, SettingForwardCustomPayload::new, new C2SPayloadHandler(this){
            final /* synthetic */ NetworkEvents $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void handle(SettingForwardCustomPayload p0, ServerPlayNetworkContext p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                NetworkEvents.access$receiveForward(this.$tmp0, p0, p1);
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(2, (Object)this.$tmp0, NetworkEvents.class, "receiveForward", "receiveForward(Lme/fzzyhmstrs/fzzy_config/networking/SettingForwardCustomPayload;Lme/fzzyhmstrs/fzzy_config/networking/api/ServerPlayNetworkContext;)V", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof C2SPayloadHandler ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        });
        networkEventsClient = NetworkEventsClient.INSTANCE;
        ConfigApi.INSTANCE.network().registerLenientS2C(SettingForwardCustomPayload.Companion.getId(), SettingForwardCustomPayload.class, SettingForwardCustomPayload::new, new S2CPayloadHandler(networkEventsClient){
            final /* synthetic */ NetworkEventsClient $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void handle(SettingForwardCustomPayload p0, ClientPlayNetworkContext p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                this.$tmp0.receiveForward(p0, p1);
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(2, (Object)this.$tmp0, NetworkEventsClient.class, "receiveForward", "receiveForward(Lme/fzzyhmstrs/fzzy_config/networking/SettingForwardCustomPayload;Lme/fzzyhmstrs/fzzy_config/networking/api/ClientPlayNetworkContext;)V", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof S2CPayloadHandler ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        });
        networkEventsClient = NetworkEventsClient.INSTANCE;
        ConfigApi.INSTANCE.network().registerLenientS2C(DynamicIdsS2CCustomPayload.Companion.getType(), DynamicIdsS2CCustomPayload.class, DynamicIdsS2CCustomPayload::new, new S2CPayloadHandler(networkEventsClient){
            final /* synthetic */ NetworkEventsClient $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void handle(DynamicIdsS2CCustomPayload p0, ClientPlayNetworkContext p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                this.$tmp0.receiveDynamicIds(p0, p1);
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(2, (Object)this.$tmp0, NetworkEventsClient.class, "receiveDynamicIds", "receiveDynamicIds(Lme/fzzyhmstrs/fzzy_config/networking/DynamicIdsS2CCustomPayload;Lme/fzzyhmstrs/fzzy_config/networking/api/ClientPlayNetworkContext;)V", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof S2CPayloadHandler ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        });
    }

    public final void serverStarted(@NotNull ServerStartedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getServer().m_6982_()) {
            MinecraftServer minecraftServer = event.getServer();
            Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
            SyncedConfigRegistry.INSTANCE.start$fzzy_config(minecraftServer);
        }
    }

    public final void gameStopping(@NotNull GameShuttingDownEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ThreadingUtils.INSTANCE.stop();
    }

    private static final ServerPlayer send$lambda$0(ServerPlayer $playerEntity) {
        return $playerEntity;
    }

    private static final boolean handleUpdate$lambda$1(ServerPlayer player, ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return INSTANCE.canSend(player, id);
    }

    private static final void handleUpdate$lambda$2(ServerPlayer player, FzzyPayload pl) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)pl, (String)"pl");
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        pl.write(buf);
        INSTANCE.send(player, (Packet)new ClientboundCustomPayloadPacket(pl.getId(), buf));
    }

    private static final boolean handleSettingForward$lambda$3(ServerPlayer player, ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return INSTANCE.canSend(player, id);
    }

    private static final void handleSettingForward$lambda$4(ServerPlayer player, FzzyPayload pl) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)pl, (String)"pl");
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        pl.write(buf);
        INSTANCE.send(player, (Packet)new ClientboundCustomPayloadPacket(pl.getId(), buf));
    }

    private static final boolean receiveUpdate$lambda$5(ServerPlayNetworkContext $context, ServerPlayer serverPlayer, ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)serverPlayer, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return $context.canReply(id);
    }

    private static final void receiveUpdate$lambda$6(ServerPlayNetworkContext $context, ServerPlayer serverPlayer, FzzyPayload pl) {
        Intrinsics.checkNotNullParameter((Object)serverPlayer, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)pl, (String)"pl");
        $context.reply(pl);
    }

    private static final boolean receiveForward$lambda$7(ServerPlayNetworkContext $context, ServerPlayer serverPlayer, ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)serverPlayer, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return $context.canReply(id);
    }

    private static final void receiveForward$lambda$8(ServerPlayNetworkContext $context, ServerPlayer serverPlayer, FzzyPayload pl) {
        Intrinsics.checkNotNullParameter((Object)serverPlayer, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)pl, (String)"pl");
        $context.reply(pl);
    }

    private static final boolean registerDataSync$lambda$9(ServerPlayer player, ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return ConfigApi.INSTANCE.network().canSend(id, (Player)player);
    }

    private static final void registerDataSync$lambda$10(ServerPlayer player, FzzyPayload payload) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        ConfigApi.INSTANCE.network().send(payload, (Player)player);
    }

    private static final boolean registerDataSync$lambda$11(ServerPlayer player, ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return ConfigApi.INSTANCE.network().canSend(id, (Player)player);
    }

    private static final void registerDataSync$lambda$12(ServerPlayer player, FzzyPayload payload) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        ConfigApi.INSTANCE.network().send(payload, (Player)player);
    }

    private static final boolean registerConfigurations$lambda$13(ResourceLocation resourceLocation) {
        Intrinsics.checkNotNullParameter((Object)resourceLocation, (String)"<unused var>");
        return true;
    }

    private static final void registerConfigurations$lambda$14(NetworkEvent.GatherLoginPayloadsEvent $event, FzzyPayload payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        payload.write(buf);
        $event.add(buf, ConfigSyncS2CCustomPayload.Companion.getId(), "Fzzy Config login config sync", false);
    }

    public static final /* synthetic */ void access$receiveUpdate(NetworkEvents $this, ConfigUpdateC2SCustomPayload payload, ServerPlayNetworkContext context) {
        $this.receiveUpdate(payload, context);
    }

    public static final /* synthetic */ void access$receiveForward(NetworkEvents $this, SettingForwardCustomPayload payload, ServerPlayNetworkContext context) {
        $this.receiveForward(payload, context);
    }
}

