/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1531;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1743;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_270;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4081;
import net.minecraft.class_5134;
import net.minecraft.class_6025;
import net.puffish.attributesmod.AttributesMod;
import net.puffish.attributesmod.util.Sign;
import net.puffish.attributesmod.util.Signed;
import net.puffish.skillsmod.api.Category;
import net.puffish.skillsmod.api.Experience;
import net.puffish.skillsmod.api.Skill;
import net.puffish.skillsmod.api.SkillsAPI;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;
import net.sweenus.simplyskills.SimplySkills;
import net.sweenus.simplyskills.abilities.NecromancerAbilities;
import net.sweenus.simplyskills.network.ModPacketHandler;
import net.sweenus.simplyskills.util.compat.opac.OpacCompat;

public class HelperMethods {
    public static boolean checkFriendlyFire(class_1309 livingEntity, class_1657 player) {
        if (livingEntity == null || player == null) {
            return false;
        }
        if (!HelperMethods.checkEntityBlacklist(livingEntity, player)) {
            return false;
        }
        if (livingEntity == player) {
            return false;
        }
        class_270 playerTeam = player.method_5781();
        class_270 entityTeam = livingEntity.method_5781();
        if (HelperMethods.isOpacLoaded() && livingEntity instanceof class_1657) {
            return OpacCompat.checkOpacFriendlyFire(livingEntity, player);
        }
        if (playerTeam != null && entityTeam != null && livingEntity.method_5722((class_1297)player)) {
            return false;
        }
        if (livingEntity instanceof class_1657) {
            class_1657 playerEntity = (class_1657)livingEntity;
            if (playerEntity == player) {
                return false;
            }
            return playerEntity.method_7256(player);
        }
        if (livingEntity instanceof class_6025) {
            class_6025 tameable = (class_6025)livingEntity;
            if (tameable.method_35057() != null) {
                class_1309 class_13092;
                if (tameable.method_35057() != player && (class_13092 = tameable.method_35057()) instanceof class_1657) {
                    class_1657 ownerPlayer = (class_1657)class_13092;
                    if (HelperMethods.isOpacLoaded()) {
                        return OpacCompat.checkOpacFriendlyFire((class_1309)ownerPlayer, player);
                    }
                    return player.method_7256(ownerPlayer);
                }
                return tameable.method_35057() != player;
            }
            return true;
        }
        return true;
    }

    public static boolean isBehindTarget(class_1309 attacker, class_1309 target) {
        return target.method_43078() < attacker.method_43078() + 32.0f && target.method_43078() > attacker.method_43078() - 32.0f;
    }

    public static boolean isUnlocked(String skillTreeId, String skillId, class_1309 livingEntity) {
        if (livingEntity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)livingEntity;
            if (skillId == null) {
                return SkillsAPI.getCategory((class_2960)new class_2960(skillTreeId)).map(category -> category.isUnlocked(serverPlayer)).orElse(false);
            }
            return SkillsAPI.getCategory((class_2960)new class_2960(skillTreeId)).flatMap(category -> category.getSkill(skillId)).map(skill -> skill.getState(serverPlayer) == Skill.State.UNLOCKED).orElse(false);
        }
        return false;
    }

    public static boolean hasUnlockedSkill(Category category, String skillId, class_1309 livingEntity) {
        if (livingEntity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)livingEntity;
            return category.getSkill(skillId).map(skill -> skill.getState(serverPlayer) == Skill.State.UNLOCKED).orElse(false);
        }
        return false;
    }

    public static int countUnlockedSkills(String skillTreeId, class_3222 serverPlayer) {
        return SkillsAPI.getCategory((class_2960)new class_2960("simplyskills", skillTreeId)).map(category -> (int)category.streamUnlockedSkills(serverPlayer).count()).orElse(0);
    }

    public static boolean checkEntityBlacklist(class_1309 livingEntity, class_1657 player) {
        if (livingEntity == null || player == null) {
            return false;
        }
        return !(livingEntity instanceof class_1531) && !(livingEntity instanceof class_1646);
    }

    public static double getAttackDamage(class_1799 stack) {
        return stack.method_7909().method_7844(class_1304.field_6173).get((Object)class_5134.field_23721).stream().mapToDouble(class_1322::method_6186).sum();
    }

    public static class_238 createBox(class_1297 entity, int radius) {
        class_238 box = new class_238(entity.method_23317() + (double)radius, entity.method_23318() + (double)((float)radius / 3.0f), entity.method_23321() + (double)radius, entity.method_23317() - (double)radius, entity.method_23318() - (double)((float)radius / 3.0f), entity.method_23321() - (double)radius);
        return box;
    }

    public static class_238 createBoxHeight(class_1297 entity, int radius) {
        class_238 box = new class_238(entity.method_23317() + (double)radius, entity.method_23318() + (double)radius, entity.method_23321() + (double)radius, entity.method_23317() - (double)radius, entity.method_23318() - (double)radius, entity.method_23321() - (double)radius);
        return box;
    }

    public static class_238 createBoxAtBlock(class_2338 blockpos, int radius) {
        class_238 box = new class_238((double)(blockpos.method_10263() + radius), (double)(blockpos.method_10264() + radius), (double)(blockpos.method_10260() + radius), (double)(blockpos.method_10263() - radius), (double)(blockpos.method_10264() - radius), (double)(blockpos.method_10260() - radius));
        return box;
    }

    public static class_238 createBoxBetween(class_2338 blockpos, class_2338 blockpos2, int radius) {
        class_238 box = new class_238((double)(blockpos.method_10263() + radius), (double)(blockpos.method_10264() + radius), (double)(blockpos.method_10260() + radius), (double)(blockpos2.method_10263() - radius), (double)(blockpos2.method_10264() - radius), (double)(blockpos2.method_10260() - radius));
        return box;
    }

    public static class_1297 getTargetedEntity(class_1297 user, int range) {
        class_238 searchBox;
        class_243 userView;
        class_243 rayCastEnd;
        class_243 rayCastOrigin = user.method_33571();
        class_3966 hitResult = class_1675.method_18075((class_1297)user, (class_243)rayCastOrigin, (class_243)(rayCastEnd = rayCastOrigin.method_1019(userView = user.method_5828(1.0f).method_1029().method_1021((double)range))), (class_238)(searchBox = user.method_5829().method_1009((double)range, (double)range, (double)range)), target -> !target.method_7325() && target.method_5863() && target instanceof class_1309, (double)(range * range));
        if (hitResult != null) {
            return hitResult.method_17782();
        }
        return null;
    }

    public static class_243 getPositionLookingAt(class_1657 player, int range) {
        class_239 result = player.method_5745((double)range, 0.0f, false);
        if (result.method_17783() != class_239.class_240.field_1332) {
            return null;
        }
        class_3965 blockResult = (class_3965)result;
        return blockResult.method_17784();
    }

    public static class_2338 getBlockLookingAt(class_1657 player, int range) {
        class_239 result = player.method_5745((double)range, 0.0f, false);
        if (result.method_17783() == class_239.class_240.field_1332) {
            class_3965 blockResult = (class_3965)result;
            return blockResult.method_17777();
        }
        return HelperMethods.getFirstAirBlockLookingAt(player, range);
    }

    public static class_2338 getFirstAirBlockLookingAt(class_1657 player, int range) {
        class_243 start = player.method_33571();
        class_243 look = player.method_5828(1.0f);
        for (int i = range - 4; i < range; ++i) {
            class_243 step = start.method_1031(look.field_1352 * (double)i, look.field_1351 * (double)i, look.field_1350 * (double)i);
            class_2338 pos = new class_2338((int)step.field_1352, (int)step.field_1351, (int)step.field_1350);
            if (!player.method_37908().method_22347(pos)) continue;
            return pos;
        }
        return null;
    }

    public static void incrementStatusEffect(class_1309 livingEntity, class_1291 statusEffect, int duration, int amplifier, int amplifierMax) {
        if (livingEntity.method_6059(statusEffect)) {
            int currentAmplifier = livingEntity.method_6112(statusEffect).method_5578();
            if (currentAmplifier >= amplifierMax) {
                livingEntity.method_6092(new class_1293(statusEffect, duration, currentAmplifier, false, false, true));
                return;
            }
            livingEntity.method_6092(new class_1293(statusEffect, duration, currentAmplifier + amplifier, false, false, true));
        }
        livingEntity.method_6092(new class_1293(statusEffect, duration, amplifier, false, false, true));
    }

    public static void capStatusEffect(class_1309 livingEntity) {
        int spellforgedCap = 5;
        int mightCap = 30;
        int marksmanshipCap = 30;
        List list = livingEntity.method_6026().stream().toList();
        if (!list.isEmpty()) {
            for (class_1293 statusEffectInstance : list) {
                class_1291 statusEffect = statusEffectInstance.method_5579();
                switch (statusEffect.method_5560().getString()) {
                    case "Spellforged": {
                        if (statusEffectInstance.method_5578() > spellforgedCap) {
                            HelperMethods.decrementStatusEffects(livingEntity, statusEffect, statusEffectInstance.method_5578() - spellforgedCap);
                        }
                    }
                    case "Might": {
                        if (statusEffectInstance.method_5578() > mightCap) {
                            HelperMethods.decrementStatusEffects(livingEntity, statusEffect, statusEffectInstance.method_5578() - mightCap);
                        }
                    }
                    case "Marksmanship": {
                        if (statusEffectInstance.method_5578() <= marksmanshipCap) break;
                        HelperMethods.decrementStatusEffects(livingEntity, statusEffect, statusEffectInstance.method_5578() - marksmanshipCap);
                    }
                }
            }
        }
    }

    public static boolean stringContainsAny(String string, String[] stringList) {
        for (String s : stringList) {
            if (!string.contains(s)) continue;
            return true;
        }
        return false;
    }

    public static void decrementStatusEffect(class_1309 livingEntity, class_1291 statusEffect) {
        if (livingEntity.method_6059(statusEffect)) {
            int currentAmplifier = livingEntity.method_6112(statusEffect).method_5578();
            int currentDuration = livingEntity.method_6112(statusEffect).method_5584();
            if (currentAmplifier < 1) {
                livingEntity.method_6016(statusEffect);
                return;
            }
            livingEntity.method_6016(statusEffect);
            livingEntity.method_6092(new class_1293(statusEffect, currentDuration, currentAmplifier - 1, false, false, true));
        }
    }

    public static void decrementStatusEffects(class_1309 livingEntity, class_1291 statusEffect, int stacksRemoved) {
        if (livingEntity.method_6059(statusEffect)) {
            int currentAmplifier = livingEntity.method_6112(statusEffect).method_5578();
            int currentDuration = livingEntity.method_6112(statusEffect).method_5584();
            if (currentAmplifier < 1) {
                livingEntity.method_6016(statusEffect);
                return;
            }
            livingEntity.method_6016(statusEffect);
            livingEntity.method_6092(new class_1293(statusEffect, currentDuration, currentAmplifier - stacksRemoved, false, false, true));
        }
    }

    public static boolean buffSteal(class_1309 user, class_1309 target, boolean strip, boolean singular, boolean debuff, boolean cleanse) {
        List list = target.method_6026().stream().toList();
        if (list.isEmpty()) {
            return false;
        }
        for (class_1293 statusEffectInstance : list) {
            class_1291 statusEffect = statusEffectInstance.method_5579();
            int duration = statusEffectInstance.method_5584();
            int amplifier = statusEffectInstance.method_5578();
            if (statusEffect.method_5573() && !debuff) {
                if (user != null && !cleanse) {
                    HelperMethods.incrementStatusEffect(user, statusEffect, duration, 1, amplifier);
                }
                if (strip) {
                    HelperMethods.decrementStatusEffect(target, statusEffectInstance.method_5579());
                }
                if (!singular) continue;
                return true;
            }
            if (statusEffect.method_5573() || !debuff) continue;
            if (user != null && !cleanse) {
                HelperMethods.incrementStatusEffect(user, statusEffect, duration, 1, amplifier);
            }
            if (strip) {
                HelperMethods.decrementStatusEffect(target, statusEffectInstance.method_5579());
            }
            if (!singular) continue;
            return true;
        }
        return true;
    }

    public static void spawnParticle(class_1937 world, class_2394 particle, double xpos, double ypos, double zpos, double xvelocity, double yvelocity, double zvelocity) {
        if (world.field_9236) {
            world.method_8406(particle, xpos, ypos, zpos, xvelocity, yvelocity, zvelocity);
        } else if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            serverWorld.method_14199(particle, xpos, ypos, zpos, 1, xvelocity, yvelocity, zvelocity, 0.0);
        }
    }

    public static void spawnParticlesPlane(class_1937 world, class_2394 particle, class_2338 blockpos, int radius, double xvelocity, double yvelocity, double zvelocity) {
        double xpos = blockpos.method_10263() - (radius + 1);
        double ypos = blockpos.method_10264();
        double zpos = blockpos.method_10260() - (radius + 1);
        for (int i = radius * 2; i > 0; --i) {
            for (int j = radius * 2; j > 0; --j) {
                float choose = (float)(Math.random() * 1.0);
                HelperMethods.spawnParticle(world, particle, xpos + (double)i + (double)choose, ypos, zpos + (double)j + (double)choose, xvelocity, yvelocity, zvelocity);
            }
        }
    }

    public static void spawnParticlesInFrontOfPlayer(class_3218 world, class_1309 livingEntity, class_2394 particle, int distance, double speed, int count) {
        class_243 lookVec = livingEntity.method_5828(1.0f).method_1029();
        class_243 startPosition = livingEntity.method_33571().method_1019(lookVec.method_1021((double)distance));
        for (int i = 0; i < count; ++i) {
            double offsetX = (world.field_9229.method_43058() - 0.5) * 2.0;
            double offsetY = (world.field_9229.method_43058() - 0.5) * 2.0;
            double offsetZ = (world.field_9229.method_43058() - 0.5) * 2.0;
            double xPos = startPosition.field_1352 + offsetX;
            double yPos = startPosition.field_1351 + offsetY;
            double zPos = startPosition.field_1350 + offsetZ;
            double xVelocity = lookVec.field_1352 * speed;
            double yVelocity = lookVec.field_1351 * speed;
            double zVelocity = lookVec.field_1350 * speed;
            world.method_14199(particle, xPos, yPos, zPos, 0, xVelocity, yVelocity, zVelocity, 1.0);
        }
    }

    public static boolean respecialise(class_3222 user) {
        class_2960 prom;
        List<String> specialisations = SimplySkills.getSpecialisationsAsArray();
        for (String specialisation : specialisations) {
            ((Category)SkillsAPI.getCategory((class_2960)new class_2960(specialisation)).get()).erase(user);
        }
        ((Category)SkillsAPI.getCategory((class_2960)new class_2960("simplyskills:tree")).get()).resetSkills(user);
        class_2960 ascendancyTree = new class_2960("simplyskills:ascendancy");
        if (SkillsAPI.getCategory((class_2960)ascendancyTree).isPresent()) {
            ((Category)SkillsAPI.getCategory((class_2960)ascendancyTree).get()).resetSkills(user);
        }
        if (FabricLoader.getInstance().isModLoaded("prominent") && SkillsAPI.getCategory((class_2960)(prom = new class_2960("puffish_skills:prom"))).isPresent()) {
            ((Category)SkillsAPI.getCategory((class_2960)prom).get()).resetSkills(user);
        }
        return true;
    }

    public static boolean levelAll(class_3222 user) {
        List<String> specialisations = SimplySkills.getSpecialisationsAsArray();
        if (!FabricLoader.getInstance().isModLoaded("prominent")) {
            for (String specialisation : specialisations) {
                ((Category)SkillsAPI.getCategory((class_2960)new class_2960(specialisation)).get()).unlock(user);
                ((Category)SkillsAPI.getCategory((class_2960)new class_2960(specialisation)).get()).addExtraPoints(user, 99);
            }
        }
        ((Category)SkillsAPI.getCategory((class_2960)new class_2960("simplyskills:tree")).get()).addExtraPoints(user, 99);
        if (!FabricLoader.getInstance().isModLoaded("prominent")) {
            ((Category)SkillsAPI.getCategory((class_2960)new class_2960("simplyskills:ascendancy")).get()).unlock(user);
            ((Category)SkillsAPI.getCategory((class_2960)new class_2960("simplyskills:ascendancy")).get()).addExtraPoints(user, 99);
        }
        if (FabricLoader.getInstance().isModLoaded("prominent")) {
            ((Category)SkillsAPI.getCategory((class_2960)new class_2960("puffish_skills:prom")).get()).addExtraPoints(user, 99);
        }
        return true;
    }

    public static void treeResetOnDeath(class_3222 user) {
        int expLoss = SimplySkills.generalConfig.treeExpLossOnDeath;
        if (expLoss > 0) {
            HelperMethods.loseExpOnDeath(user, expLoss);
        } else if (SimplySkills.generalConfig.treeResetOnDeath) {
            HelperMethods.resetAllTrees(user);
        }
    }

    public static void resetAllTrees(class_3222 user) {
        List<String> specialisations = SimplySkills.getSpecialisationsAsArray();
        for (String specialisation : specialisations) {
            ((Category)SkillsAPI.getCategory((class_2960)new class_2960(specialisation)).get()).erase(user);
            ((Category)SkillsAPI.getCategory((class_2960)new class_2960("simplyskills:ascendancy")).get()).erase(user);
            if (FabricLoader.getInstance().isModLoaded("prominent")) {
                ((Category)SkillsAPI.getCategory((class_2960)new class_2960("puffish_skills:prom")).get()).erase(user);
                continue;
            }
            ((Category)SkillsAPI.getCategory((class_2960)new class_2960("simplyskills:tree")).get()).erase(user);
        }
    }

    public static void loseExpOnDeath(class_3222 player, int percent) {
        List<String> specialisations = SimplySkills.getSpecialisationsAsArray();
        specialisations.add("simplyskills:ascendancy");
        specialisations.add("simplyskills:tree");
        for (String specialisation : specialisations) {
            Optional categoryOpt = SkillsAPI.getCategory((class_2960)new class_2960(specialisation));
            if (categoryOpt.isPresent() && ((Category)categoryOpt.get()).isUnlocked(player)) {
                Category category = (Category)categoryOpt.get();
                Optional experienceOpt = category.getExperience();
                if (experienceOpt.isPresent()) {
                    Experience experience = (Experience)experienceOpt.get();
                    int currentExp = experience.getCurrent(player);
                    int currentLevel = experience.getLevel(player);
                    int requiredExpForCurrentLevel = experience.getRequired(player, currentLevel - 1);
                    int requiredExpForNextLevel = experience.getRequired(player, currentLevel);
                    float experienceProgress = (float)currentExp / (float)requiredExpForNextLevel * 100.0f;
                    double expToLose = (double)percent / 100.0 * (double)currentExp;
                    int newExp = currentExp - (int)expToLose;
                    if (newExp < 0) {
                        newExp = 0;
                    }
                    if (!((double)experience.getTotal(player) - expToLose > 0.0)) continue;
                    experience.addTotal(player, (int)(-expToLose));
                    player.method_43496((class_2561)class_2561.method_43470((String)("You have lost " + percent + "% of your skill level progress")));
                    continue;
                }
                System.out.println("Experience object not present for category: " + specialisation);
                continue;
            }
            System.out.println("Category not present: " + specialisation);
        }
    }

    public static int getSlotWithStack(class_1657 player, class_1799 stack) {
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            if (!class_1799.method_7973((class_1799)player.method_31548().method_5438(i), (class_1799)stack)) continue;
            return i;
        }
        return -1;
    }

    public static boolean storeBuildTemplate(class_3222 user, class_1799 stack) {
        int categoryCount = 0;
        int skillCount = 0;
        String userUUID = user.method_5845();
        stack.method_7948().method_10582("player_name", user.method_5477().getString());
        if (!stack.method_7948().method_10558("player_uuid").isEmpty()) {
            return false;
        }
        class_2487 nbt = stack.method_7948();
        for (Category category : SkillsAPI.streamUnlockedCategories((class_3222)user)::iterator) {
            String categoryKey = "category" + categoryCount;
            nbt.method_10582(categoryKey, category.getId().toString());
            String expKey = "exp" + categoryCount;
            category.getExperience().ifPresent(experience -> nbt.method_10569(expKey, experience.getTotal(user)));
            for (Skill skill : category.streamUnlockedSkills(user)::iterator) {
                String skillKey = "skill" + skillCount;
                nbt.method_10582(skillKey, skill.getId());
                ++skillCount;
            }
            ++categoryCount;
        }
        HelperMethods.resetAllTrees(user);
        nbt.method_10582("player_uuid", userUUID);
        int slot = HelperMethods.getSlotWithStack((class_1657)user, stack);
        if (slot != -1) {
            ModPacketHandler.syncItemStackNbt(user, slot, stack);
        }
        return true;
    }

    public static boolean applyBuildTemplate(class_3222 user, class_1799 stack) {
        int slot;
        class_2487 nbt = stack.method_7948();
        String uuid = user.method_5845();
        if (!nbt.method_10558("player_uuid").equals(uuid) && !SimplySkills.generalConfig.enableBuildSharing) {
            return false;
        }
        HelperMethods.resetAllTrees(user);
        int size = stack.method_7969() != null ? stack.method_7969().method_10546() : 0;
        for (int i = 0; i < size; ++i) {
            String categoryKey = "category" + i;
            String category = nbt.method_10558(categoryKey);
            if (category.isEmpty()) continue;
            int finalI = i;
            SkillsAPI.getCategory((class_2960)new class_2960(category)).ifPresent(categoryObj -> {
                categoryObj.unlock(user);
                String expKey = "exp" + finalI;
                if (nbt.method_10545(expKey)) {
                    categoryObj.getExperience().ifPresent(experience -> experience.setTotal(user, nbt.method_10550(expKey)));
                }
                for (int s = 0; s < size; ++s) {
                    String skillKey = "skill" + s;
                    String skill = nbt.method_10558(skillKey);
                    if (skill.isEmpty()) continue;
                    categoryObj.getSkill(skill).ifPresent(skillObj -> skillObj.unlock(user));
                }
            });
        }
        if (!stack.method_7969().method_33133()) {
            int tempSize = stack.method_7969().method_10546();
            for (int i = 0; i < tempSize; ++i) {
                String expKey;
                String categoryKey = "category" + i;
                if (!nbt.method_10558(categoryKey).isEmpty()) {
                    nbt.method_10551(categoryKey);
                    for (int s = 0; s < tempSize; ++s) {
                        String skillKey = "skill" + s;
                        if (nbt.method_10558(skillKey).isEmpty()) continue;
                        nbt.method_10551(skillKey);
                    }
                }
                if (!nbt.method_10573(expKey = "exp" + i, 3)) continue;
                nbt.method_10551(expKey);
            }
            nbt.method_10551("player_uuid");
            nbt.method_10551("player_name");
        }
        if ((slot = HelperMethods.getSlotWithStack((class_1657)user, stack)) != -1) {
            ModPacketHandler.syncItemStackNbt(user, slot, stack);
        }
        return true;
    }

    public static void printNBT(class_1799 stack, List<class_2561> tooltip, String type) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null) {
            return;
        }
        if (!nbt.method_33133()) {
            int tempSize = nbt.method_10546();
            int skillPrintCount = 0;
            for (int i = 0; i < tempSize; ++i) {
                if (!nbt.method_10558("category" + i).isEmpty() && type.equals("category") && !nbt.method_10558("category" + i).contains("tree")) {
                    tooltip.add((class_2561)class_2561.method_43470((String)("  \u00a76\u25c7 \u00a7f" + nbt.method_10558("category" + i).replace("simplyskills:", "").replace("puffish_skills:prom", "Talent Tree"))));
                }
                if (nbt.method_10558("skill" + i).isEmpty()) continue;
                ++skillPrintCount;
            }
            if (type.equals("skill")) {
                tooltip.add((class_2561)class_2561.method_43470((String)("  \u00a7b\u25c7 \u00a7f" + skillPrintCount)));
            }
            if (!nbt.method_10558("player_name").isEmpty()) {
                String name = nbt.method_10558("player_name");
                if (type.equals("name")) {
                    tooltip.add((class_2561)class_2561.method_43470((String)("\u00a77Bound to: " + name)));
                }
            }
        }
    }

    public static int getUnspentPoints(class_3222 player) {
        return SkillsAPI.streamUnlockedCategories((class_3222)player).mapToInt(category -> category.getPointsLeft(player)).sum();
    }

    public static double getHighestAttributeValue(class_1657 player) {
        double attackDamage = player.method_26825(class_5134.field_23721);
        double toughness = SpellPower.getSpellPower((SpellSchool)SpellSchools.FROST, (class_1309)player).baseValue();
        double fire = SpellPower.getSpellPower((SpellSchool)SpellSchools.FIRE, (class_1309)player).baseValue();
        double arcane = SpellPower.getSpellPower((SpellSchool)SpellSchools.ARCANE, (class_1309)player).baseValue();
        double soul = SpellPower.getSpellPower((SpellSchool)SpellSchools.SOUL, (class_1309)player).baseValue();
        double healing = SpellPower.getSpellPower((SpellSchool)SpellSchools.HEALING, (class_1309)player).baseValue();
        double lightning = SpellPower.getSpellPower((SpellSchool)SpellSchools.LIGHTNING, (class_1309)player).baseValue();
        Double[] attributeValues = new Double[]{attackDamage, toughness, fire, arcane, soul, healing, lightning};
        return Arrays.stream(attributeValues).max(Comparator.naturalOrder()).orElse((Double)Double.MIN_VALUE);
    }

    public static double getRelativeRangedAttribute(class_1657 player) {
        boolean dealtDamage = true;
        double rangedDamage = AttributesMod.applyAttributeModifiers((double)((double)dealtDamage), (Signed[])new Signed[]{Sign.POSITIVE.wrap((Object)player.method_5996(AttributesMod.RANGED_DAMAGE))});
        return player.method_26825(AttributesMod.RANGED_DAMAGE);
    }

    public static double getHighestSpecificAttributeValue(class_1657 player, class_1320 ... attributes) {
        double highestValue = Double.MIN_VALUE;
        for (class_1320 attribute : attributes) {
            double attributeValue = player.method_26825(attribute);
            if (!(attributeValue > highestValue)) continue;
            highestValue = attributeValue;
        }
        return highestValue;
    }

    public static void spawnWaistHeightParticles(class_3218 world, class_2394 particle, class_1297 entity1, class_1297 entity2, int count) {
        class_243 startPos = entity1.method_19538().method_1031(0.0, (double)entity1.method_17682() / 2.0, 0.0);
        class_243 endPos = entity2.method_19538().method_1031(0.0, (double)entity2.method_17682() / 2.0, 0.0);
        class_243 direction = endPos.method_1020(startPos);
        double distance = direction.method_1033();
        class_243 normalizedDirection = direction.method_1029();
        for (int i = 0; i < count; ++i) {
            double lerpFactor = (double)i / (double)(count - 1);
            class_243 currentPos = startPos.method_1019(normalizedDirection.method_1021(distance * lerpFactor));
            world.method_14199(particle, currentPos.field_1352, currentPos.field_1351, currentPos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnOrbitParticles(class_3218 world, class_243 center, class_2394 particleType, double radius, int particleCount) {
        for (int i = 0; i < particleCount; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)particleCount;
            double x = center.field_1352 + radius * Math.cos(angle);
            double z = center.field_1350 + radius * Math.sin(angle);
            double y = center.field_1351;
            world.method_14199(particleType, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static double getGroundDistance(class_1297 entity) {
        class_2338 pos = entity.method_24515();
        while (pos.method_10264() > 0 && !entity.method_37908().method_8320(pos).method_26212((class_1922)entity.method_37908(), pos)) {
            pos = pos.method_10074();
        }
        return entity.method_23318() - (double)pos.method_10264();
    }

    public static boolean hasHarmfulStatusEffect(class_1309 entity) {
        for (class_1293 effectInstance : entity.method_6026()) {
            if (effectInstance.method_5579().method_18792() != class_4081.field_18272) continue;
            return true;
        }
        return false;
    }

    public static int countHarmfulStatusEffects(class_1309 entity) {
        int harmfulEffectCount = 0;
        for (class_1293 effectInstance : entity.method_6026()) {
            if (effectInstance.method_5579().method_18792() != class_4081.field_18272) continue;
            ++harmfulEffectCount;
        }
        return harmfulEffectCount;
    }

    public static boolean isDualWielding(class_1309 livingEntity) {
        return !(!(livingEntity.method_6047().method_7909() instanceof class_1829) && !(livingEntity.method_6047().method_7909() instanceof class_1743) || !(livingEntity.method_6079().method_7909() instanceof class_1829) && !(livingEntity.method_6079().method_7909() instanceof class_1743));
    }

    public static void spawnDirectionalParticles(class_3218 world, class_2394 particle, class_1297 entity, int count, double distance) {
        class_243 startPos = entity.method_19538().method_1031(0.0, (double)entity.method_17682() / 2.0, 0.0);
        float pitch = entity.method_5695(1.0f);
        float yaw = entity.method_5705(1.0f);
        double pitchRadians = Math.toRadians(pitch);
        double yawRadians = Math.toRadians(yaw);
        double xDirection = -Math.sin(yawRadians) * Math.cos(pitchRadians);
        double yDirection = -Math.sin(pitchRadians);
        double zDirection = Math.cos(yawRadians) * Math.cos(pitchRadians);
        class_243 direction = new class_243(xDirection, yDirection, zDirection).method_1029();
        for (int i = 0; i < count; ++i) {
            double lerpFactor = (double)i / (double)(count - 1);
            class_243 currentPos = startPos.method_1019(direction.method_1021(distance * lerpFactor));
            world.method_14199(particle, currentPos.field_1352, currentPos.field_1351, currentPos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void damageEntitiesInTrajectory(class_3218 world, class_1297 sourceEntity, class_1657 playerEntity, double distance, float damage, class_1282 damageSource) {
        class_243 startPos = sourceEntity.method_19538().method_1031(0.0, (double)sourceEntity.method_17682() / 2.0, 0.0);
        float pitch = sourceEntity.method_5695(1.0f);
        float yaw = sourceEntity.method_5705(1.0f);
        double pitchRadians = Math.toRadians(pitch);
        double yawRadians = Math.toRadians(yaw);
        double xDirection = -Math.sin(yawRadians) * Math.cos(pitchRadians);
        double yDirection = -Math.sin(pitchRadians);
        double zDirection = Math.cos(yawRadians) * Math.cos(pitchRadians);
        class_243 direction = new class_243(xDirection, yDirection, zDirection).method_1029();
        class_243 endPos = startPos.method_1019(direction.method_1021(distance));
        double boxSize = 0.5;
        class_238 searchBox = new class_238(startPos, endPos).method_1014(boxSize);
        for (class_1297 entity : world.method_8335(sourceEntity, searchBox)) {
            class_1309 livingTarget;
            class_238 entityBox = entity.method_5829().method_1014((double)entity.method_5871());
            if (!entityBox.method_994(searchBox) || !(entity instanceof class_1309) || !HelperMethods.checkFriendlyFire(livingTarget = (class_1309)entity, playerEntity)) continue;
            livingTarget.method_5643(damageSource, damage);
            if (!(sourceEntity instanceof class_1309)) continue;
            class_1309 livingSource = (class_1309)sourceEntity;
            NecromancerAbilities.effectPestilence(playerEntity, livingSource, livingTarget);
        }
    }

    public static boolean isOpacLoaded() {
        return FabricLoader.getInstance().isModLoaded("openpartiesandclaims");
    }
}

