/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.abilities;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1753;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_6025;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.entity.SpellProjectile;
import net.spell_engine.internals.SpellHelper;
import net.sweenus.simplyskills.SimplySkills;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.util.HelperMethods;
import net.sweenus.simplyskills.util.SkillReferencePosition;

public class RangerAbilities {
    public static void passiveRangerReveal(class_1657 player) {
        int frequency = SimplySkills.rangerConfig.passiveRangerRevealFrequency;
        if (player.field_6012 % frequency == 0) {
            int radius = SimplySkills.rangerConfig.passiveRangerRevealRadius;
            class_238 box = HelperMethods.createBox((class_1297)player, radius);
            block0: for (class_1297 entities : player.method_37908().method_8333((class_1297)player, box, class_1301.field_6157)) {
                class_1309 le;
                if (entities == null || !(entities instanceof class_1309) || !HelperMethods.checkFriendlyFire(le = (class_1309)entities, player)) continue;
                for (class_1293 statusEffect : le.method_6026()) {
                    if (statusEffect == null || !statusEffect.method_5579().equals(EffectRegistry.STEALTH)) continue;
                    le.method_6016(statusEffect.method_5579());
                    le.method_6092(new class_1293(EffectRegistry.REVEALED, 180, 1, false, false, true));
                    continue block0;
                }
            }
        }
    }

    public static boolean isOwnPet(class_1297 entity, class_1657 player) {
        class_6025 te;
        if (entity instanceof class_6025 && (te = (class_6025)entity).method_35057() != null) {
            return Objects.equals(te.method_6139(), player.method_5667());
        }
        return false;
    }

    public static void passiveRangerTamer(class_1657 player) {
        int frequency = SimplySkills.rangerConfig.passiveRangerTamerFrequency;
        if (player.field_6012 % frequency == 0) {
            int radius = SimplySkills.rangerConfig.passiveRangerTamerRadius;
            int resistanceAmplifier = SimplySkills.rangerConfig.passiveRangerTamerResistanceAmplifier;
            int regenerationAmplifier = SimplySkills.rangerConfig.passiveRangerTamerRegenerationAmplifier;
            class_238 box = HelperMethods.createBox((class_1297)player, radius);
            for (class_1297 entities : player.method_37908().method_8333((class_1297)player, box, class_1301.field_6157)) {
                if (entities == null || !(entities instanceof class_1309)) continue;
                class_1309 le = (class_1309)entities;
                if (!RangerAbilities.isOwnPet(entities, player)) continue;
                le.method_6092(new class_1293(class_1294.field_5924, frequency + 5, regenerationAmplifier, false, false, true));
                le.method_6092(new class_1293(class_1294.field_5907, frequency + 5, resistanceAmplifier, false, false, true));
            }
        }
    }

    public static void passiveRangerBonded(class_1657 player) {
        int frequency = SimplySkills.rangerConfig.passiveRangerBondedFrequency;
        if (player.field_6012 % frequency == 0) {
            int radius = SimplySkills.rangerConfig.passiveRangerBondedRadius;
            int petMinimumHealthPercent = SimplySkills.rangerConfig.passiveRangerBondedPetMinimumHealthPercent;
            int healthTransferAmount = SimplySkills.rangerConfig.passiveRangerBondedHealthTransferAmount;
            class_238 box = HelperMethods.createBox((class_1297)player, radius);
            for (class_1297 entities : player.method_37908().method_8333((class_1297)player, box, class_1301.field_6157)) {
                float playerHealthPercent;
                float teHealthPercent;
                if (entities == null || !(entities instanceof class_1309)) continue;
                class_1309 le = (class_1309)entities;
                if (!RangerAbilities.isOwnPet(entities, player) || !((teHealthPercent = le.method_6032() / le.method_6063() * 100.0f) > (playerHealthPercent = player.method_6032() / player.method_6063() * 100.0f)) || !(teHealthPercent > (float)petMinimumHealthPercent)) continue;
                le.method_6033(le.method_6032() - (float)healthTransferAmount);
                player.method_6025((float)healthTransferAmount);
            }
        }
    }

    public static void passiveRangerTrained(class_1657 player) {
        int frequency = SimplySkills.rangerConfig.passiveRangerTrainedFrequency;
        if (player.field_6012 % frequency == 0) {
            int radius = SimplySkills.rangerConfig.passiveRangerTrainedRadius;
            int strengthAmplifier = SimplySkills.rangerConfig.passiveRangerTrainedStrengthAmplifier;
            int speedAmplifier = SimplySkills.rangerConfig.passiveRangerTrainedSpeedAmplifier;
            int minimumHealthPercent = SimplySkills.rangerConfig.passiveRangerTrainedMinimumHealthPercent;
            class_238 box = HelperMethods.createBox((class_1297)player, radius);
            for (class_1297 entities : player.method_37908().method_8333((class_1297)player, box, class_1301.field_6157)) {
                float teHealthPercent;
                if (entities == null || !(entities instanceof class_1309)) continue;
                class_1309 le = (class_1309)entities;
                if (!RangerAbilities.isOwnPet(entities, player) || !((teHealthPercent = le.method_6032() / le.method_6063() * 100.0f) > (float)minimumHealthPercent)) continue;
                le.method_6092(new class_1293(class_1294.field_5910, frequency + 5, strengthAmplifier, false, false, true));
                le.method_6092(new class_1293(class_1294.field_5904, frequency + 5, speedAmplifier, false, false, true));
            }
        }
    }

    public static void passiveRangerIncognito(class_1657 player) {
        int frequency = SimplySkills.rangerConfig.passiveRangerIncognitoFrequency;
        if (player.field_6012 % frequency == 0) {
            int radius = SimplySkills.rangerConfig.passiveRangerIncognitoRadius;
            class_238 box = HelperMethods.createBox((class_1297)player, radius);
            for (class_1297 entities : player.method_37908().method_8333((class_1297)player, box, class_1301.field_6157)) {
                if (entities == null || !(entities instanceof class_1309)) continue;
                class_1309 le = (class_1309)entities;
                if (!RangerAbilities.isOwnPet(entities, player) || !player.method_6059(EffectRegistry.STEALTH)) continue;
                le.method_6092(new class_1293(class_1294.field_5905, frequency + 5, 0, false, false, true));
            }
        }
    }

    public static void passiveRangerElementalArrowsRenewal(class_1657 player) {
        int random = new Random().nextInt(100);
        int renewalChance = SimplySkills.rangerConfig.passiveRangerElementalArrowsRenewalChance;
        int renewalDuration = SimplySkills.rangerConfig.passiveRangerElementalArrowsRenewalDuration;
        int renewalMaxStacks = SimplySkills.rangerConfig.passiveRangerElementalArrowsRenewalMaximumStacks;
        int renewalStacks = SimplySkills.rangerConfig.passiveRangerElementalArrowsRenewalStacks;
        if (random < renewalChance) {
            HelperMethods.incrementStatusEffect((class_1309)player, EffectRegistry.ELEMENTALARROWS, renewalDuration, renewalStacks, renewalMaxStacks);
        }
    }

    public static boolean signatureRangerDisengage(String rangerSkillTree, class_1657 player) {
        int radius = SimplySkills.rangerConfig.signatureRangerDisengageRadius;
        int velocity = SimplySkills.rangerConfig.signatureRangerDisengageVelocity;
        int height = SimplySkills.rangerConfig.signatureRangerDisengageHeight;
        int slownessDuration = SimplySkills.rangerConfig.signatureRangerDisengageSlownessDuration;
        int slownessAmplifier = SimplySkills.rangerConfig.signatureRangerDisengageSlownessAmplifier;
        int slowFallDuration = SimplySkills.rangerConfig.signatureRangerDisengageSlowFallDuration;
        int slowFallAmplifier = SimplySkills.rangerConfig.signatureRangerDisengageSlowFallAmplifier;
        class_238 box = HelperMethods.createBox((class_1297)player, radius);
        for (class_1297 entities : player.method_37908().method_8333((class_1297)player, box, class_1301.field_6157)) {
            class_1309 le;
            if (entities == null || !(entities instanceof class_1309) || !HelperMethods.checkFriendlyFire(le = (class_1309)entities, player)) continue;
            le.method_6092(new class_1293(class_1294.field_5909, slownessDuration, slownessAmplifier, false, false, true));
        }
        player.method_18799(player.method_5720().method_22882().method_1021((double)velocity));
        player.method_18800(player.method_18798().field_1352, (double)height, player.method_18798().field_1350);
        player.method_6092(new class_1293(class_1294.field_5906, slowFallDuration, slowFallAmplifier, false, false, true));
        player.field_6037 = true;
        if (HelperMethods.isUnlocked(rangerSkillTree, SkillReferencePosition.rangerSpecialisationDisengageRecuperate, (class_1309)player)) {
            RangerAbilities.signatureRangerDisengageRecuperate(player);
        }
        if (HelperMethods.isUnlocked(rangerSkillTree, SkillReferencePosition.rangerSpecialisationDisengageExploitation, (class_1309)player)) {
            RangerAbilities.signatureRangerDisengageExploitation(player);
        }
        if (HelperMethods.isUnlocked(rangerSkillTree, SkillReferencePosition.rangerSpecialisationDisengageMarksman, (class_1309)player)) {
            int marksmanDuration = SimplySkills.rangerConfig.signatureRangerDisengageMarksmanDuration;
            int marksmanStacks = SimplySkills.rangerConfig.signatureRangerDisengageMarksmanStacks;
            if (player.method_6047().method_7909() instanceof class_1753) {
                HelperMethods.incrementStatusEffect((class_1309)player, EffectRegistry.MARKSMAN, marksmanDuration, marksmanStacks, 99);
            } else {
                HelperMethods.incrementStatusEffect((class_1309)player, EffectRegistry.BARRIER, marksmanDuration, marksmanStacks, 6);
            }
        }
        return true;
    }

    public static void signatureRangerDisengageRecuperate(class_1657 player) {
        int radius = SimplySkills.rangerConfig.signatureRangerDisengageRecuperateRadius;
        class_238 box = HelperMethods.createBox((class_1297)player, radius);
        for (class_1297 entities : player.method_37908().method_8333((class_1297)player, box, class_1301.field_6157)) {
            if (entities == null || !(entities instanceof class_1309)) continue;
            class_1309 le = (class_1309)entities;
            if (!RangerAbilities.isOwnPet(entities, player)) continue;
            le.method_6025(le.method_6063());
        }
    }

    public static void signatureRangerDisengageExploitation(class_1657 player) {
        int radius = SimplySkills.rangerConfig.signatureRangerDisengageExploitationRadius;
        int effectDuration = SimplySkills.rangerConfig.signatureRangerDisengageExploitationDuration;
        class_238 box = HelperMethods.createBox((class_1297)player, radius);
        for (class_1297 entities : player.method_37908().method_8333((class_1297)player, box, class_1301.field_6157)) {
            if (entities == null || !(entities instanceof class_1309)) continue;
            class_1309 le = (class_1309)entities;
            if (!RangerAbilities.isOwnPet(entities, player)) continue;
            le.method_6092(new class_1293(EffectRegistry.IMMOBILIZINGAURA, effectDuration, 0, false, false, true));
        }
    }

    public static boolean signatureRangerElementalArrows(String rangerSkillTree, class_1657 player) {
        int elementalArrowsDuration = SimplySkills.rangerConfig.effectRangerElementalArrowsDuration;
        int elementalArrowsStacks = SimplySkills.rangerConfig.effectRangerElementalArrowsStacks;
        int elementalArrowsStacksIncreasePerTier = SimplySkills.rangerConfig.effectRangerElementalArrowsStacksIncreasePerTier;
        int amplifier = elementalArrowsStacks;
        if (HelperMethods.isUnlocked(rangerSkillTree, SkillReferencePosition.rangerSpecialisationElementalArrowsStacksOne, (class_1309)player)) {
            amplifier += elementalArrowsStacksIncreasePerTier;
        }
        if (HelperMethods.isUnlocked(rangerSkillTree, SkillReferencePosition.rangerSpecialisationElementalArrowsStacksTwo, (class_1309)player)) {
            amplifier += elementalArrowsStacksIncreasePerTier * 2;
        }
        if (HelperMethods.isUnlocked(rangerSkillTree, SkillReferencePosition.rangerSpecialisationElementalArrowsStacksThree, (class_1309)player)) {
            amplifier += elementalArrowsStacksIncreasePerTier * 3;
        }
        player.method_6092(new class_1293(EffectRegistry.ELEMENTALARROWS, elementalArrowsDuration, amplifier, false, false, true));
        return true;
    }

    public static boolean signatureRangerArrowRain(String rangerSkillTree, class_1657 player) {
        int arrowRainDuration = SimplySkills.rangerConfig.effectRangerArrowRainDuration;
        player.method_6092(new class_1293(EffectRegistry.ARROWRAIN, arrowRainDuration, 0, false, false, true));
        return true;
    }

    public static void signatureRangerElementalArtillery(class_3222 player, SpellProjectile spellProjectile, class_2960 spellId, SpellHelper.ImpactContext context, Spell.ProjectileData.Perks perks) {
        if (player != null && spellProjectile.field_6012 % 12 == 0 && spellProjectile.field_6012 > 30 && HelperMethods.isUnlocked("simplyskills:ranger", SkillReferencePosition.rangerSpecialisationArrowRainElementalArtillery, (class_1309)player) && spellId.toString().contains("arrow_rain")) {
            class_243 position = spellProjectile.method_19538();
            ArrayList<String> list = new ArrayList<String>();
            list.add("simplyskills:frost_arrow_homing");
            list.add("simplyskills:fire_arrow_homing");
            list.add("simplyskills:lightning_arrow_homing");
            Random rand = new Random();
            class_2960 randomSpell = new class_2960((String)list.get(rand.nextInt(list.size())));
            SpellProjectile projectile = new SpellProjectile(spellProjectile.method_37908(), (class_1309)spellProjectile.method_24921(), position.method_10216(), position.method_10214(), position.method_10215(), spellProjectile.behaviour(), randomSpell, (class_1297)null, context, perks.copy());
            projectile.method_18799(spellProjectile.method_18798());
            projectile.range = spellProjectile.range;
            class_1675.method_7484((class_1297)projectile, (float)0.2f);
            int radius = 20;
            class_238 box = new class_238(spellProjectile.method_23317() + (double)radius, spellProjectile.method_23318() + (double)((float)radius * 3.0f), spellProjectile.method_23321() + (double)radius, spellProjectile.method_23317() - (double)radius, spellProjectile.method_23318() - (double)((float)radius * 3.0f), spellProjectile.method_23321() - (double)radius);
            for (class_1297 entities : player.method_37908().method_8333((class_1297)player, box, class_1301.field_6157)) {
                class_1309 le;
                if (entities == null || player.method_6051().method_43048(100) >= 35 || !(entities instanceof class_1309) || !HelperMethods.checkFriendlyFire(le = (class_1309)entities, (class_1657)player)) continue;
                projectile.setFollowedTarget((class_1297)le);
                break;
            }
            spellProjectile.method_37908().method_8649((class_1297)projectile);
        }
    }
}

