/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.abilities;

import java.util.Comparator;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_7923;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;
import net.sweenus.simplyskills.abilities.SignatureAbilities;
import net.sweenus.simplyskills.effects.instance.SimplyStatusEffectInstance;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.registry.SoundRegistry;
import net.sweenus.simplyskills.util.HelperMethods;
import net.sweenus.simplyskills.util.SkillReferencePosition;

public class AscendancyAbilities {
    public static int getAscendancyPoints(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (FabricLoader.getInstance().isModLoaded("prominent") && class_7923.field_41190.method_10223(new class_2960("eldritch_end:corruption")) != null) {
                return (int)player.method_26825((class_1320)class_7923.field_41190.method_10223(new class_2960("eldritch_end:corruption")));
            }
            return HelperMethods.countUnlockedSkills("ascendancy", serverPlayer);
        }
        return 0;
    }

    public static boolean righteousHammers(class_1657 player) {
        player.method_6092(new class_1293(EffectRegistry.RIGHTEOUSHAMMERS, 800, 1 + AscendancyAbilities.getAscendancyPoints(player) / 10, false, false, true));
        return true;
    }

    public static boolean boneArmor(class_1657 player) {
        player.method_6092(new class_1293(EffectRegistry.BONEARMOR, 800, 3 + AscendancyAbilities.getAscendancyPoints(player) / 10, false, false, true));
        return true;
    }

    public static void boneArmorEffect(class_3222 player) {
        if (HelperMethods.isUnlocked("simplyskills:ascendancy", SkillReferencePosition.ascendancyBoneArmor, (class_1309)player) && player.method_6059(EffectRegistry.BONEARMOR)) {
            HelperMethods.decrementStatusEffect((class_1309)player, EffectRegistry.BONEARMOR);
        }
    }

    public static boolean cyclonicCleave(class_1657 player) {
        if (FabricLoader.getInstance().isModLoaded("prominent")) {
            SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:cyclonic_cleave_prom", 3, (class_1297)player, null);
        } else {
            SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:cyclonic_cleave", 3, (class_1297)player, null);
        }
        return true;
    }

    public static boolean magicCircle(class_1657 player) {
        player.method_6092(new class_1293(EffectRegistry.MAGICCIRCLE, 240 + AscendancyAbilities.getAscendancyPoints(player), 0, false, false, true));
        player.method_6092(new class_1293(EffectRegistry.IMMOBILIZE, 25, 0, false, false, true));
        player.method_37908().method_43129(null, (class_1297)player, SoundRegistry.SPELL_RADIANT_HIT, class_3419.field_15248, 0.2f, 0.9f);
        return true;
    }

    public static boolean magicCircleEffect(class_1657 player) {
        return AscendancyAbilities.getAscendancyPoints(player) > 29 && player.method_6059(EffectRegistry.MAGICCIRCLE);
    }

    public static boolean arcaneSlash(class_1657 player) {
        SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:arcane_slash", 3, (class_1297)player, null);
        player.method_37908().method_43129(null, (class_1297)player, SoundRegistry.SPELL_SLASH, class_3419.field_15248, 0.4f, 1.1f);
        if (AscendancyAbilities.getAscendancyPoints(player) > 9) {
            HelperMethods.incrementStatusEffect((class_1309)player, EffectRegistry.ARCANEATTUNEMENT, 60, 1 + AscendancyAbilities.getAscendancyPoints(player) / 10, 19);
        }
        return true;
    }

    public static boolean agony(class_1657 player) {
        class_1309 ee;
        class_238 box;
        class_3218 world = (class_3218)player.method_37908();
        class_1297 closestEntity = world.method_8333((class_1297)player, box = HelperMethods.createBox((class_1297)player, 10), class_1301.field_6157).stream().min(Comparator.comparingDouble(entity -> entity.method_5858((class_1297)player))).orElse(null);
        if (closestEntity != null && closestEntity instanceof class_1309 && HelperMethods.checkFriendlyFire(ee = (class_1309)closestEntity, player)) {
            SimplyStatusEffectInstance agonyEffect = new SimplyStatusEffectInstance(EffectRegistry.AGONY, 200 + AscendancyAbilities.getAscendancyPoints(player), 0, false, false, true);
            agonyEffect.setSourceEntity((class_1309)player);
            ee.method_6092((class_1293)agonyEffect);
            HelperMethods.spawnWaistHeightParticles(world, (class_2394)class_2398.field_11251, (class_1297)player, (class_1297)ee, 20);
            player.method_37908().method_43129(null, (class_1297)player, SoundRegistry.MAGIC_SHAMANIC_SPELL_04, class_3419.field_15248, 0.2f, 1.0f);
            return true;
        }
        return false;
    }

    public static void agonyEffect(class_1657 playerAttacker, class_1309 livingEntity) {
        class_1657 sourcePlayer;
        class_1309 sourceEntity;
        if (!(livingEntity.method_6112(EffectRegistry.AGONY) instanceof SimplyStatusEffectInstance)) {
            return;
        }
        SimplyStatusEffectInstance agonyEffect = (SimplyStatusEffectInstance)livingEntity.method_6112(EffectRegistry.AGONY);
        livingEntity.field_6008 = 0;
        livingEntity.method_5643(playerAttacker.method_48923().method_48815((class_1297)playerAttacker, (class_1297)playerAttacker), (float)(0.1 * HelperMethods.getHighestAttributeValue(playerAttacker)));
        livingEntity.field_6008 = 0;
        if (agonyEffect != null && (sourceEntity = agonyEffect.getSourceEntity()) instanceof class_1657 && AscendancyAbilities.getAscendancyPoints(sourcePlayer = (class_1657)sourceEntity) > 29) {
            playerAttacker.method_6025((float)(0.1 * SpellPower.getSpellPower((SpellSchool)SpellSchools.HEALING, (class_1309)sourcePlayer).randomValue()));
        }
    }

    public static boolean torment(class_1657 player) {
        class_1309 ee;
        class_238 box;
        class_3218 world = (class_3218)player.method_37908();
        class_1297 closestEntity = world.method_8333((class_1297)player, box = HelperMethods.createBox((class_1297)player, 10), class_1301.field_6157).stream().min(Comparator.comparingDouble(entity -> entity.method_5858((class_1297)player))).orElse(null);
        if (closestEntity != null && closestEntity instanceof class_1309 && HelperMethods.checkFriendlyFire(ee = (class_1309)closestEntity, player)) {
            SimplyStatusEffectInstance tormentEffect = new SimplyStatusEffectInstance(EffectRegistry.TORMENT, 160 + AscendancyAbilities.getAscendancyPoints(player), 0, false, false, true);
            tormentEffect.setSourceEntity((class_1309)player);
            ee.method_6092((class_1293)tormentEffect);
            player.method_37908().method_43129(null, (class_1297)player, SoundRegistry.MAGIC_SHAMANIC_SPELL_04, class_3419.field_15248, 0.2f, 1.0f);
            if (AscendancyAbilities.getAscendancyPoints(player) > 29) {
                SimplyStatusEffectInstance tauntedEffect = new SimplyStatusEffectInstance(EffectRegistry.TAUNTED, 160 + AscendancyAbilities.getAscendancyPoints(player), 0, false, false, true);
                tauntedEffect.setSourceEntity((class_1309)player);
                ee.method_6092((class_1293)tauntedEffect);
            }
            HelperMethods.spawnWaistHeightParticles(world, (class_2394)class_2398.field_11251, (class_1297)player, (class_1297)ee, 20);
            return true;
        }
        return false;
    }

    public static boolean tormentEffect(class_1657 player, class_1282 source, float amount) {
        class_1309 attacker;
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1309 && (attacker = (class_1309)class_12972).method_6059(EffectRegistry.TORMENT)) {
            class_1657 sourcePlayer;
            if (!(attacker.method_6112(EffectRegistry.TORMENT) instanceof SimplyStatusEffectInstance)) {
                return false;
            }
            SimplyStatusEffectInstance tormentEffect = (SimplyStatusEffectInstance)attacker.method_6112(EffectRegistry.TORMENT);
            class_1309 class_13092 = tormentEffect.getSourceEntity();
            if (class_13092 instanceof class_1657 && (sourcePlayer = (class_1657)class_13092) == player) {
                attacker.method_5643(source, amount);
                return true;
            }
        }
        return false;
    }

    public static boolean rapidfire(class_1657 player) {
        player.method_6092(new class_1293(EffectRegistry.RAPIDFIRE, 120 + AscendancyAbilities.getAscendancyPoints(player), 0, false, false, true));
        return true;
    }

    public static boolean cataclysm(class_1657 player) {
        SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:cataclysm", 3, (class_1297)player, null);
        player.method_37908().method_43129(null, (class_1297)player, SoundRegistry.ENERGY_CHARGE, class_3419.field_15248, 0.3f, 1.0f);
        return true;
    }

    public static boolean ghostwalk(class_1657 player) {
        SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:ghostwalk", 3, (class_1297)player, null);
        return true;
    }

    public static boolean skywardSunder(class_1657 player) {
        player.method_6092(new class_1293(EffectRegistry.SKYWARDSUNDER, 45, 0, false, false, true));
        player.method_37908().method_43129(null, (class_1297)player, SoundRegistry.SLASH_02, class_3419.field_15248, 0.6f, 1.0f);
        return true;
    }

    public static void goldenAegis(class_1657 player) {
        HelperMethods.incrementStatusEffect((class_1309)player, EffectRegistry.GOLDENAEGIS, 2400, 1, 15 + AscendancyAbilities.getAscendancyPoints(player) / 10);
    }

    public static boolean righteousShield(class_1657 player) {
        if (player.method_6059(EffectRegistry.GOLDENAEGIS)) {
            SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:righteous_shield", 3, (class_1297)player, null);
            return true;
        }
        return false;
    }

    public static boolean chainbreaker(class_1657 player) {
        HelperMethods.buffSteal((class_1309)player, (class_1309)player, true, false, true, true);
        player.method_37908().method_43129(null, (class_1297)player, SoundRegistry.SPELL_ARCANE_CAST, class_3419.field_15248, 0.3f, 1.1f);
        HelperMethods.incrementStatusEffect((class_1309)player, EffectRegistry.MIGHT, 120, 1 + AscendancyAbilities.getAscendancyPoints(player) / 10, 19);
        HelperMethods.incrementStatusEffect((class_1309)player, EffectRegistry.MARKSMANSHIP, 120, 1 + AscendancyAbilities.getAscendancyPoints(player) / 10, 19);
        HelperMethods.spawnParticlesPlane(player.method_37908(), (class_2394)class_2398.field_11203, player.method_24515(), 1, 0.0, 0.1, 0.0);
        if (AscendancyAbilities.getAscendancyPoints(player) > 29) {
            player.method_6092(new class_1293(EffectRegistry.UNDYING, 120, 0, false, false, true));
        }
        return true;
    }
}

