/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.valarian_conquest.procedures;

import java.util.List;
import java.util.UUID;
import net.mcreator.valarian_conquest.init.ValarianConquestModMobEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class LongPatrolActiveProcedure {
    public static void execute(LevelAccessor world, Entity entity) {
        Path path;
        boolean isLeader;
        UUID leaderID;
        if (entity == null || !(entity instanceof PathfinderMob)) {
            return;
        }
        PathfinderMob mob = (PathfinderMob)entity;
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)world;
        if (mob.m_5448_() != null && mob.m_5448_().m_6084_()) {
            return;
        }
        if (!entity.getPersistentData().m_128441_("patrolLeader")) {
            entity.getPersistentData().m_128362_("patrolLeader", entity.m_20148_());
            entity.getPersistentData().m_128379_("isLeader", true);
            List nearby = level.m_45933_(entity, mob.m_20191_().m_82400_(32.0));
            for (Entity e : nearby) {
                LivingEntity le;
                if (!(e instanceof LivingEntity) || !(le = (LivingEntity)e).m_21023_((MobEffect)ValarianConquestModMobEffects.LONG_PATROL_POTION.get()) || e == mob) continue;
                e.getPersistentData().m_128362_("patrolLeader", entity.m_20148_());
                e.getPersistentData().m_128379_("isLeader", false);
            }
            leaderID = entity.m_20148_();
        } else {
            leaderID = entity.getPersistentData().m_128342_("patrolLeader");
        }
        Entity leader = level.m_8791_(leaderID);
        if (leader == null || !leader.m_6084_()) {
            entity.getPersistentData().m_128362_("patrolLeader", entity.m_20148_());
            entity.getPersistentData().m_128379_("isLeader", true);
            leader = entity;
        }
        if ((isLeader = entity.getPersistentData().m_128471_("isLeader")) && !leader.getPersistentData().m_128471_("hasPatrolTarget")) {
            Player nearestPlayer = level.m_45930_(leader, 64.0);
            BlockPos startPos = nearestPlayer != null ? nearestPlayer.m_20183_() : leader.m_20183_();
            BlockPos firstTarget = LongPatrolActiveProcedure.findSafeRandomPos(level, startPos, 24, 32);
            leader.getPersistentData().m_128405_("patrolX", firstTarget.m_123341_());
            leader.getPersistentData().m_128405_("patrolY", firstTarget.m_123342_());
            leader.getPersistentData().m_128405_("patrolZ", firstTarget.m_123343_());
            leader.getPersistentData().m_128379_("hasPatrolTarget", true);
        }
        if (!isLeader && leader != null) {
            entity.getPersistentData().m_128405_("patrolX", leader.getPersistentData().m_128451_("patrolX"));
            entity.getPersistentData().m_128405_("patrolY", leader.getPersistentData().m_128451_("patrolY"));
            entity.getPersistentData().m_128405_("patrolZ", leader.getPersistentData().m_128451_("patrolZ"));
            entity.getPersistentData().m_128379_("hasPatrolTarget", true);
        }
        BlockPos patrolTarget = new BlockPos(entity.getPersistentData().m_128451_("patrolX"), entity.getPersistentData().m_128451_("patrolY"), entity.getPersistentData().m_128451_("patrolZ"));
        double distance = entity.m_20182_().m_82554_(Vec3.m_82512_((Vec3i)patrolTarget));
        if (isLeader && distance < 3.5) {
            BlockPos newTarget = LongPatrolActiveProcedure.findSafeRandomPos(level, entity.m_20183_(), 96, 128);
            leader.getPersistentData().m_128405_("patrolX", newTarget.m_123341_());
            leader.getPersistentData().m_128405_("patrolY", newTarget.m_123342_());
            leader.getPersistentData().m_128405_("patrolZ", newTarget.m_123343_());
            leader.getPersistentData().m_128379_("hasPatrolTarget", true);
            List nearby = level.m_45933_(leader, leader.m_20191_().m_82400_(64.0));
            for (Entity e : nearby) {
                if (!e.getPersistentData().m_128403_("patrolLeader") || !e.getPersistentData().m_128342_("patrolLeader").equals(leader.m_20148_()) || e == leader) continue;
                e.getPersistentData().m_128405_("patrolX", newTarget.m_123341_());
                e.getPersistentData().m_128405_("patrolY", newTarget.m_123342_());
                e.getPersistentData().m_128405_("patrolZ", newTarget.m_123343_());
            }
        }
        if (mob.m_21573_().m_26571_() && (path = mob.m_21573_().m_7864_(patrolTarget, 1)) != null) {
            mob.m_21573_().m_26536_(path, 0.7);
        }
    }

    private static BlockPos findSafeRandomPos(ServerLevel level, BlockPos origin, int minDist, int maxDist) {
        for (int i = 0; i < 20; ++i) {
            BlockPos checkPos;
            int dx = level.f_46441_.m_216332_(-maxDist, maxDist);
            int dz = level.f_46441_.m_216332_(-maxDist, maxDist);
            if (Math.abs(dx) < minDist && Math.abs(dz) < minDist || !level.m_8055_(checkPos = level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, origin.m_7918_(dx, 0, dz))).m_60819_().m_76178_()) continue;
            return checkPos;
        }
        return origin;
    }
}

