/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.valarian_conquest.network;

import java.util.function.Supplier;
import net.mcreator.valarian_conquest.ValarianConquestMod;
import net.mcreator.valarian_conquest.procedures.ClaimCitizenArcherProcedure;
import net.mcreator.valarian_conquest.procedures.ClaimCitizenProcedureProcedure;
import net.mcreator.valarian_conquest.procedures.ClaimCitizenSoldierProcedure;
import net.mcreator.valarian_conquest.procedures.NPCDecreaseHealthProcedure;
import net.mcreator.valarian_conquest.procedures.NPCGuardButtonProcedure;
import net.mcreator.valarian_conquest.procedures.NPCIncreaseHealthProcedure;
import net.mcreator.valarian_conquest.procedures.NPCLongPatrolButtonProcedure;
import net.mcreator.valarian_conquest.procedures.NPCMountButtonProcedure;
import net.mcreator.valarian_conquest.procedures.NPCPatrolButtonProcedure;
import net.mcreator.valarian_conquest.procedures.NPCSaveNameProcedure;
import net.mcreator.valarian_conquest.procedures.NPCSetFollowerProcedure;
import net.mcreator.valarian_conquest.procedures.NPCSheatheWeaponProcedure;
import net.mcreator.valarian_conquest.procedures.NPCStandGuardButtonProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class NPCInventoryGUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public NPCInventoryGUIButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public NPCInventoryGUIButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(NPCInventoryGUIButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(NPCInventoryGUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            NPCInventoryGUIButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            NPCIncreaseHealthProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 1) {
            NPCDecreaseHealthProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 2) {
            ClaimCitizenProcedureProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            NPCSetFollowerProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            ClaimCitizenArcherProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 5) {
            ClaimCitizenSoldierProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 6) {
            NPCStandGuardButtonProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 7) {
            NPCGuardButtonProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 8) {
            NPCPatrolButtonProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 9) {
            NPCSheatheWeaponProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 10) {
            NPCMountButtonProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 11) {
            NPCLongPatrolButtonProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 12) {
            NPCSaveNameProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        ValarianConquestMod.addNetworkMessage(NPCInventoryGUIButtonMessage.class, NPCInventoryGUIButtonMessage::buffer, NPCInventoryGUIButtonMessage::new, NPCInventoryGUIButtonMessage::handler);
    }
}

