/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.valarian_conquest.init;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.mcreator.valarian_conquest.ValarianConquestMod;
import net.mcreator.valarian_conquest.init.ValarianConquestModBlocks;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ValarianConquestModVillagerProfessions {
    private static final Map<String, ProfessionPoiType> POI_TYPES = new HashMap<String, ProfessionPoiType>();
    public static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.VILLAGER_PROFESSIONS, (String)"valarian_conquest");
    public static final RegistryObject<VillagerProfession> BARBER_SURGEON_PROFESSION = ValarianConquestModVillagerProfessions.registerProfession("barber_surgeon_profession", () -> (Block)ValarianConquestModBlocks.BARBER_SURGEON.get(), () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)"entity.zombie_villager.cure")));
    public static final RegistryObject<VillagerProfession> BUILDER_PROFESSION = ValarianConquestModVillagerProfessions.registerProfession("builder_profession", () -> (Block)ValarianConquestModBlocks.BUILDER.get(), () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)"entity.villager.work_toolsmith")));
    public static final RegistryObject<VillagerProfession> SIEGE_PROFESSION = ValarianConquestModVillagerProfessions.registerProfession("siege_profession", () -> (Block)ValarianConquestModBlocks.SIEGE.get(), () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)"entity.villager.work_toolsmith")));
    public static final RegistryObject<VillagerProfession> WEAPONSMITH_PROFESSION = ValarianConquestModVillagerProfessions.registerProfession("weaponsmith_profession", () -> (Block)ValarianConquestModBlocks.WEAPONSMITH.get(), () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)"entity.villager.work_toolsmith")));
    public static final RegistryObject<VillagerProfession> ARMORSMITH_PROFESSION = ValarianConquestModVillagerProfessions.registerProfession("armorsmith_profession", () -> (Block)ValarianConquestModBlocks.ARMORSMITH.get(), () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)"entity.villager.work_toolsmith")));
    public static final RegistryObject<VillagerProfession> SCRIBE_PROFESSION = ValarianConquestModVillagerProfessions.registerProfession("scribe_profession", () -> (Block)ValarianConquestModBlocks.SCRIBE.get(), () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)"entity.villager.work_cartographer")));
    public static final RegistryObject<VillagerProfession> VALARIAN_MERCHANT = ValarianConquestModVillagerProfessions.registerProfession("valarian_merchant", () -> (Block)ValarianConquestModBlocks.VALARIAN.get(), () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)"valarian_conquest:empty_audio")));
    public static final RegistryObject<VillagerProfession> BOHEMIAN_MERCHANT = ValarianConquestModVillagerProfessions.registerProfession("bohemian_merchant", () -> (Block)ValarianConquestModBlocks.BOHEMIAN.get(), () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)"valarian_conquest:empty_audio")));
    public static final RegistryObject<VillagerProfession> CALADRIAN_MERCHANT = ValarianConquestModVillagerProfessions.registerProfession("caladrian_merchant", () -> (Block)ValarianConquestModBlocks.CALADRIAN.get(), () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)"valarian_conquest:empty_audio")));
    public static final RegistryObject<VillagerProfession> NUMERIAN_MERCHANT = ValarianConquestModVillagerProfessions.registerProfession("numerian_merchant", () -> (Block)ValarianConquestModBlocks.NUMERIAN.get(), () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)"valarian_conquest:empty_audio")));
    public static final RegistryObject<VillagerProfession> VISGOTHIAN_MERCHANT = ValarianConquestModVillagerProfessions.registerProfession("visgothian_merchant", () -> (Block)ValarianConquestModBlocks.VISGOTHIAN.get(), () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)"valarian_conquest:empty_audio")));
    public static final RegistryObject<VillagerProfession> GARDONIAN_MERCHANT = ValarianConquestModVillagerProfessions.registerProfession("gardonian_merchant", () -> (Block)ValarianConquestModBlocks.GARDONIAN.get(), () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)"valarian_conquest:empty_audio")));
    public static final RegistryObject<VillagerProfession> LANCASTIAN_MERCHANT = ValarianConquestModVillagerProfessions.registerProfession("lancastian_merchant", () -> (Block)ValarianConquestModBlocks.LANCASTIAN.get(), () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)"valarian_conquest:empty_audio")));
    public static final RegistryObject<VillagerProfession> GALICIAN_MERCHANT = ValarianConquestModVillagerProfessions.registerProfession("galician_merchant", () -> (Block)ValarianConquestModBlocks.GALICIAN.get(), () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)"valarian_conquest:empty_audio")));
    public static final RegistryObject<VillagerProfession> TEMPLAR_MERCHANT = ValarianConquestModVillagerProfessions.registerProfession("templar_merchant", () -> (Block)ValarianConquestModBlocks.TEMPLAR.get(), () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)"valarian_conquest:empty_audio")));
    public static final RegistryObject<VillagerProfession> HOSPITALLER_MERCHANT = ValarianConquestModVillagerProfessions.registerProfession("hospitaller_merchant", () -> (Block)ValarianConquestModBlocks.HOSPITALLER.get(), () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)"valarian_conquest:empty_audio")));
    public static final RegistryObject<VillagerProfession> BARATHIAN_MERCHANT = ValarianConquestModVillagerProfessions.registerProfession("barathian_merchant", () -> (Block)ValarianConquestModBlocks.BARATHIAN.get(), () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)"valarian_conquest:empty_audio")));
    public static final RegistryObject<VillagerProfession> ORLEANIAN_MERCHANT = ValarianConquestModVillagerProfessions.registerProfession("orleanian_merchant", () -> (Block)ValarianConquestModBlocks.ORLEANIAN.get(), () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)"valarian_conquest:empty_audio")));

    private static RegistryObject<VillagerProfession> registerProfession(String name, Supplier<Block> block, Supplier<SoundEvent> soundEvent) {
        POI_TYPES.put(name, new ProfessionPoiType(block, null));
        return PROFESSIONS.register(name, () -> {
            Predicate<Holder> poiPredicate = poiTypeHolder -> ValarianConquestModVillagerProfessions.POI_TYPES.get((Object)name).poiType != null && poiTypeHolder.get() == ValarianConquestModVillagerProfessions.POI_TYPES.get((Object)name).poiType.get();
            return new VillagerProfession("valarian_conquest:" + name, poiPredicate, poiPredicate, ImmutableSet.of(), ImmutableSet.of(), (SoundEvent)soundEvent.get());
        });
    }

    @SubscribeEvent
    public static void registerProfessionPointsOfInterest(RegisterEvent event) {
        event.register(ForgeRegistries.Keys.POI_TYPES, registerHelper -> {
            for (Map.Entry<String, ProfessionPoiType> entry : POI_TYPES.entrySet()) {
                Block block = entry.getValue().block.get();
                String name = entry.getKey();
                Optional existingCheck = PoiTypes.m_218075_((BlockState)block.m_49966_());
                if (existingCheck.isPresent()) {
                    ValarianConquestMod.LOGGER.error("Skipping villager profession " + name + " that uses POI block " + String.valueOf(block) + " that is already in use by " + String.valueOf(existingCheck));
                    continue;
                }
                PoiType poiType = new PoiType((Set)ImmutableSet.copyOf((Collection)block.m_49965_().m_61056_()), 1, 1);
                registerHelper.register(name, (Object)poiType);
                entry.getValue().poiType = (Holder)ForgeRegistries.POI_TYPES.getHolder((Object)poiType).get();
            }
        });
    }

    private static class ProfessionPoiType {
        final Supplier<Block> block;
        Holder<PoiType> poiType;

        ProfessionPoiType(Supplier<Block> block, Holder<PoiType> poiType) {
            this.block = block;
            this.poiType = poiType;
        }
    }
}

