/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.valarian_conquest.entity;

import net.mcreator.valarian_conquest.api.ISheatheable;
import net.mcreator.valarian_conquest.init.ValarianConquestModEntities;
import net.mcreator.valarian_conquest.procedures.NotIsAggressiveAnimationProcedureProcedure;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class SoldierEntity
extends Monster
implements ISheatheable {
    public final AnimationState animationState0 = new AnimationState();
    private static final EntityDataAccessor<Integer> DATA_SHEATHE_STATE = SynchedEntityData.m_135353_(SoldierEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TEXTURE_VARIANT = SynchedEntityData.m_135353_(SoldierEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static int nextVariant = 1;

    public SoldierEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<SoldierEntity>)((EntityType)ValarianConquestModEntities.SOLDIER.get()), world);
    }

    public SoldierEntity(EntityType<SoldierEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.6f);
        this.f_21364_ = 5;
        this.m_21557_(false);
        this.m_21530_();
        if (!world.f_46443_) {
            this.setTextureVariant(nextVariant);
            if (++nextVariant > 24) {
                nextVariant = 1;
            }
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SHEATHE_STATE, (Object)0);
        this.f_19804_.m_135372_(TEXTURE_VARIANT, (Object)1);
    }

    @Override
    public int getSheatheState() {
        return (Integer)this.f_19804_.m_135370_(DATA_SHEATHE_STATE);
    }

    @Override
    public void setSheatheState(int state) {
        this.f_19804_.m_135381_(DATA_SHEATHE_STATE, (Object)state);
    }

    public void setTextureVariant(int variant) {
        this.f_19804_.m_135381_(TEXTURE_VARIANT, (Object)variant);
    }

    public int getTextureVariant() {
        return (Integer)this.f_19804_.m_135370_(TEXTURE_VARIANT);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("sheatheState", this.getSheatheState());
        tag.m_128405_("TextureVariant", this.getTextureVariant());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("sheatheState")) {
            this.setSheatheState(tag.m_128451_("sheatheState"));
        }
        if (tag.m_128441_("TextureVariant")) {
            this.setTextureVariant(tag.m_128451_("TextureVariant"));
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal<LivingEntity>((Mob)this, LivingEntity.class, 10, true, true, entity -> {
            if (entity instanceof Player || entity instanceof Monster) {
                return true;
            }
            if (entity instanceof Villager) {
                Villager villager = (Villager)entity;
                CompoundTag persistent = this.getPersistentData();
                return persistent == null || !persistent.m_128471_("claimed_citizen");
            }
            return false;
        }){

            public boolean m_8045_() {
                LivingEntity livingEntity = this.f_26050_;
                if (livingEntity instanceof Villager) {
                    Villager villager = (Villager)livingEntity;
                    CompoundTag persistent = SoldierEntity.this.getPersistentData();
                    if (persistent != null && persistent.m_128471_("claimed_citizen")) {
                        return false;
                    }
                }
                return super.m_8045_();
            }
        });
        this.f_21346_.m_25352_(5, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false){

            protected double m_6639_(LivingEntity entity) {
                return 3.61;
            }
        });
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 12.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new FloatGoal((Mob)this));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public double m_6049_() {
        return -0.35;
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("valarian_conquest:malehurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("valarian_conquest:maledie"));
    }

    public void m_8119_() {
        Entity entity;
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.animationState0.m_246184_(NotIsAggressiveAnimationProcedureProcedure.execute((Entity)this), this.f_19797_);
        }
        if ((entity = this.m_20202_()) instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)entity;
            LivingEntity target = this.m_5448_();
            double horseSpeed = horse.m_20069_() ? 0.7 : (target != null && target.m_6084_() ? 0.35 : 0.25);
            if (horse.m_21051_(Attributes.f_22279_).m_22115_() != horseSpeed) {
                horse.m_21051_(Attributes.f_22279_).m_22100_(horseSpeed);
            }
            if (target != null && target.m_6084_()) {
                float yawDiff;
                double dx = target.m_20185_() - horse.m_20185_();
                double dz = target.m_20189_() - horse.m_20189_();
                float targetYaw = (float)(Math.atan2(-dx, dz) * 57.29577951308232);
                float currentYaw = horse.m_146908_();
                for (yawDiff = targetYaw - currentYaw; yawDiff > 180.0f; yawDiff -= 360.0f) {
                }
                while (yawDiff < -180.0f) {
                    yawDiff += 360.0f;
                }
                float maxTurnSpeed = 2.0f;
                yawDiff = Math.max(-maxTurnSpeed, Math.min(maxTurnSpeed, yawDiff));
                horse.m_146922_(currentYaw + yawDiff);
                horse.m_5618_(horse.m_146908_());
                horse.m_5616_(horse.m_146908_());
            }
            this.m_146922_(horse.m_146908_());
            this.m_5618_(horse.m_146908_());
            if (horse.m_20069_()) {
                Vec3 motion = horse.m_20184_();
                if (!horse.m_20068_()) {
                    horse.m_20256_(motion.m_82520_(0.0, 0.04, 0.0));
                }
                horse.m_7292_(new MobEffectInstance(MobEffects.f_19608_, 40, 0, false, false));
            }
        }
        if (this.m_20069_() && !this.m_20077_()) {
            double boostedSpeed = 0.7;
            if (this.m_21051_(Attributes.f_22279_).m_22115_() != boostedSpeed) {
                this.m_21051_(Attributes.f_22279_).m_22100_(boostedSpeed);
            }
        } else {
            double normalSpeed = 0.25;
            if (this.m_21051_(Attributes.f_22279_).m_22115_() != normalSpeed) {
                this.m_21051_(Attributes.f_22279_).m_22100_(normalSpeed);
            }
        }
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22277_, 32.0);
    }
}

