/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.valarian_conquest.entity;

import net.mcreator.valarian_conquest.init.ValarianConquestModEntities;
import net.mcreator.valarian_conquest.procedures.IsMovingAnimationProcedure;
import net.mcreator.valarian_conquest.procedures.RamWallsProcedureProcedure;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class BatteringRamEntity
extends Monster {
    public final AnimationState animationState0 = new AnimationState();
    private float riderYawOffset = 0.0f;

    public BatteringRamEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<BatteringRamEntity>)((EntityType)ValarianConquestModEntities.BATTERING_RAM.get()), world);
    }

    public BatteringRamEntity(EntityType<BatteringRamEntity> type, Level world) {
        super(type, world);
        this.m_274367_(1.0f);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_21530_();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal<Player>((Mob)this, Player.class, true, false){

            protected AABB m_7255_(double targetDistance) {
                return this.f_26135_.m_20191_().m_82377_(targetDistance, 20.0, targetDistance);
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal<Monster>((Mob)this, Monster.class, true, false){

            protected AABB m_7255_(double targetDistance) {
                return this.f_26135_.m_20191_().m_82377_(targetDistance, 20.0, targetDistance);
            }
        });
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public InteractionResult m_6071_(Player sourceentity, InteractionHand hand) {
        InteractionResult retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        super.m_6071_(sourceentity, hand);
        sourceentity.m_20329_((Entity)this);
        this.riderYawOffset = this.m_146908_();
        return retval;
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction moveFunction) {
        super.m_19956_(passenger, moveFunction);
        if (this.m_20363_(passenger)) {
            LivingEntity living;
            float yawRad = this.m_146908_() * ((float)Math.PI / 180);
            double offsetX = Math.sin(yawRad) * 2.0;
            double offsetZ = -Math.cos(yawRad) * 2.0;
            double riderX = this.m_20185_() + offsetX;
            double riderY = this.m_20186_() + this.m_6048_() + passenger.m_6049_();
            double riderZ = this.m_20189_() + offsetZ;
            moveFunction.m_20372_(passenger, riderX, riderY, riderZ);
            if (passenger instanceof LivingEntity && (living = (LivingEntity)passenger) instanceof Mob) {
                Mob mob = (Mob)living;
                living.m_146922_(this.m_146908_());
                living.m_146926_(this.m_146909_());
                living.f_19859_ = living.m_146908_();
                living.f_19860_ = living.m_146909_();
                living.m_20256_(Vec3.f_82478_);
                mob.m_21557_(true);
            }
        }
    }

    public void m_20351_(Entity passenger) {
        LivingEntity living;
        super.m_20351_(passenger);
        if (passenger instanceof LivingEntity && (living = (LivingEntity)passenger) instanceof Mob) {
            Mob mob = (Mob)living;
            mob.m_21557_(false);
        }
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public double m_6048_() {
        return super.m_6048_() + -1.0;
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("valarian_conquest:seige_breaking"));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.animationState0.m_246184_(IsMovingAnimationProcedure.execute((Entity)this), this.f_19797_);
        }
    }

    public void m_6075_() {
        super.m_6075_();
        RamWallsProcedureProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), (Entity)this);
    }

    public boolean m_7337_(Entity entity) {
        return true;
    }

    public boolean m_5829_() {
        return true;
    }

    public void m_7023_(Vec3 dir) {
        Entity entity;
        Entity entity2 = entity = this.m_20197_().isEmpty() ? null : (Entity)this.m_20197_().get(0);
        if (this.m_20160_() && entity instanceof Player) {
            Player player = (Player)entity;
            this.m_146922_(player.m_146908_());
            this.f_19859_ = this.m_146908_();
            this.m_146926_(player.m_146909_() * 0.5f);
            this.m_19915_(this.m_146908_(), this.m_146909_());
            this.f_20883_ = player.m_146908_();
            this.f_20885_ = player.m_146908_();
            this.m_7910_(0.025f);
            float forward = player.f_20902_;
            float strafe = player.f_20900_;
            super.m_7023_(new Vec3((double)strafe, 0.0, (double)forward));
            double dX = this.m_20185_() - this.f_19854_;
            double dZ = this.m_20189_() - this.f_19856_;
            float f = (float)Math.sqrt(dX * dX + dZ * dZ) * 4.0f;
            if (f > 1.0f) {
                f = 1.0f;
            }
            this.f_267362_.m_267771_(this.f_267362_.m_267731_() + (f - this.f_267362_.m_267731_()) * 0.4f);
            this.f_267362_.m_267590_(this.f_267362_.m_267756_() + this.f_267362_.m_267731_());
            this.m_267651_(true);
            return;
        }
        super.m_7023_(dir);
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.15);
        builder = builder.m_22268_(Attributes.f_22276_, 30.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 5.0);
        builder = builder.m_22268_(Attributes.f_22277_, 48.0);
        builder = builder.m_22268_(Attributes.f_22278_, 5.0);
        return builder;
    }
}

