/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.valarian_conquest.entity;

import javax.annotation.Nullable;
import net.mcreator.valarian_conquest.init.ValarianConquestModEntities;
import net.mcreator.valarian_conquest.procedures.BallistaAnimationLogicProcedure;
import net.mcreator.valarian_conquest.procedures.BallistaLaunchArrowProcedureProcedure;
import net.mcreator.valarian_conquest.procedures.BallistaSpawnRotateProcedureProcedure;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class BallistaEntity
extends Monster {
    public static final EntityDataAccessor<Boolean> DATA_BallistaShoot = SynchedEntityData.m_135353_(BallistaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final AnimationState animationState0 = new AnimationState();
    private float riderYawOffset = 0.0f;

    public BallistaEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<BallistaEntity>)((EntityType)ValarianConquestModEntities.BALLISTA.get()), world);
    }

    public BallistaEntity(EntityType<BallistaEntity> type, Level world) {
        super(type, world);
        this.m_274367_(1.0f);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_21530_();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_BallistaShoot, (Object)false);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal<LivingEntity>((Mob)this, LivingEntity.class, 10, true, true, entity -> {
            boolean validType = false;
            if (entity instanceof Player || entity instanceof Monster) {
                validType = true;
            } else if (entity instanceof Villager) {
                Villager villager = (Villager)entity;
                CompoundTag persistent = this.getPersistentData();
                boolean bl = validType = persistent == null || !persistent.m_128471_("claimed_citizen");
            }
            if (!validType) {
                return false;
            }
            return this.isInFrontArc((Entity)entity, 180.0);
        }){

            protected AABB m_7255_(double targetDistance) {
                return this.f_26135_.m_20191_().m_82377_(targetDistance, 20.0, targetDistance);
            }

            public boolean m_8045_() {
                if (this.f_26050_ != null && !BallistaEntity.this.isInFrontArc((Entity)this.f_26050_, 180.0)) {
                    return false;
                }
                LivingEntity livingEntity = this.f_26050_;
                if (livingEntity instanceof Villager) {
                    Villager villager = (Villager)livingEntity;
                    CompoundTag persistent = BallistaEntity.this.getPersistentData();
                    if (persistent != null && persistent.m_128471_("claimed_citizen")) {
                        return false;
                    }
                }
                return super.m_8045_();
            }
        });
    }

    private boolean isInFrontArc(Entity target, double arcDegrees) {
        double angleDiff;
        double dx = target.m_20185_() - this.m_20185_();
        double dz = target.m_20189_() - this.m_20189_();
        double angleToTarget = Math.toDegrees(Math.atan2(-dx, dz));
        double ballistaYaw = this.m_146908_();
        for (angleDiff = angleToTarget - ballistaYaw; angleDiff > 180.0; angleDiff -= 360.0) {
        }
        while (angleDiff < -180.0) {
            angleDiff += 360.0;
        }
        return Math.abs(angleDiff) <= arcDegrees / 2.0;
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public InteractionResult m_6071_(Player sourceentity, InteractionHand hand) {
        InteractionResult retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        super.m_6071_(sourceentity, hand);
        sourceentity.m_20329_((Entity)this);
        this.riderYawOffset = this.m_146908_();
        return retval;
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction moveFunction) {
        super.m_19956_(passenger, moveFunction);
        if (this.m_20363_(passenger)) {
            LivingEntity living;
            float yawRad = this.m_146908_() * ((float)Math.PI / 180);
            double offsetX = Math.sin(yawRad) * 1.6;
            double offsetZ = -Math.cos(yawRad) * 1.6;
            double riderX = this.m_20185_() + offsetX;
            double riderY = this.m_20186_() + this.m_6048_() + passenger.m_6049_();
            double riderZ = this.m_20189_() + offsetZ;
            moveFunction.m_20372_(passenger, riderX, riderY, riderZ);
            if (passenger instanceof LivingEntity && (living = (LivingEntity)passenger) instanceof Mob) {
                Mob mob = (Mob)living;
                living.m_146922_(this.m_146908_());
                living.m_146926_(this.m_146909_());
                living.f_19859_ = living.m_146908_();
                living.f_19860_ = living.m_146909_();
                living.m_20256_(Vec3.f_82478_);
                mob.m_21557_(true);
            }
        }
    }

    public void m_20351_(Entity passenger) {
        LivingEntity living;
        super.m_20351_(passenger);
        if (passenger instanceof LivingEntity && (living = (LivingEntity)passenger) instanceof Mob) {
            Mob mob = (Mob)living;
            mob.m_21557_(false);
        }
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public double m_6048_() {
        return super.m_6048_() + -0.75;
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("valarian_conquest:seige_breaking"));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata, @Nullable CompoundTag tag) {
        SpawnGroupData retval = super.m_6518_(world, difficulty, reason, livingdata, tag);
        BallistaSpawnRotateProcedureProcedure.execute((LevelAccessor)world, this.m_20185_(), this.m_20186_(), this.m_20189_(), (Entity)this);
        return retval;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("DataBallistaShoot", ((Boolean)this.f_19804_.m_135370_(DATA_BallistaShoot)).booleanValue());
        compound.m_128350_("RiderYawOffset", this.riderYawOffset);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("DataBallistaShoot")) {
            this.f_19804_.m_135381_(DATA_BallistaShoot, (Object)compound.m_128471_("DataBallistaShoot"));
        }
        if (compound.m_128441_("RiderYawOffset")) {
            this.riderYawOffset = compound.m_128457_("RiderYawOffset");
        }
    }

    protected void updatePassengerPosition(Entity passenger, Entity.MoveFunction moveFunction) {
        this.m_19956_(passenger, moveFunction);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.animationState0.m_246184_(BallistaAnimationLogicProcedure.execute((Entity)this), this.f_19797_);
        }
    }

    public void m_6075_() {
        super.m_6075_();
        BallistaLaunchArrowProcedureProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), (Entity)this);
    }

    public void m_7023_(Vec3 dir) {
        Entity entity;
        Entity entity2 = entity = this.m_20197_().isEmpty() ? null : (Entity)this.m_20197_().get(0);
        if (this.m_20160_() && entity instanceof Player) {
            Player player = (Player)entity;
            this.m_146922_(player.m_146908_());
            this.f_19859_ = this.m_146908_();
            this.m_146926_(player.m_146909_() * 0.5f);
            this.m_19915_(this.m_146908_(), this.m_146909_());
            this.f_20883_ = player.m_146908_();
            this.f_20885_ = player.m_146908_();
            this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
            float forward = player.f_20902_;
            float strafe = player.f_20900_;
            super.m_7023_(new Vec3((double)strafe, 0.0, (double)forward));
            double dX = this.m_20185_() - this.f_19854_;
            double dZ = this.m_20189_() - this.f_19856_;
            float f = (float)Math.sqrt(dX * dX + dZ * dZ) * 4.0f;
            if (f > 1.0f) {
                f = 1.0f;
            }
            this.f_267362_.m_267771_(this.f_267362_.m_267731_() + (f - this.f_267362_.m_267731_()) * 0.4f);
            this.f_267362_.m_267590_(this.f_267362_.m_267756_() + this.f_267362_.m_267731_());
            this.m_267651_(true);
            return;
        }
        super.m_7023_(dir);
    }

    public boolean m_7337_(Entity entity) {
        return true;
    }

    public boolean m_5829_() {
        return true;
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.0);
        builder = builder.m_22268_(Attributes.f_22276_, 30.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 5.0);
        builder = builder.m_22268_(Attributes.f_22277_, 40.0);
        builder = builder.m_22268_(Attributes.f_22278_, 5.0);
        return builder;
    }
}

