/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.valarian_conquest.entity;

import net.mcreator.valarian_conquest.api.ISheatheable;
import net.mcreator.valarian_conquest.init.ValarianConquestModEntities;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class ArcherEntity
extends Monster
implements RangedAttackMob,
ISheatheable {
    private static final EntityDataAccessor<Integer> DATA_SHEATHE_STATE = SynchedEntityData.m_135353_(ArcherEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TEXTURE_VARIANT = SynchedEntityData.m_135353_(ArcherEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_CHARGING_CROSSBOW = SynchedEntityData.m_135353_(ArcherEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CROSSBOW_CHARGED = SynchedEntityData.m_135353_(ArcherEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_AIMING = SynchedEntityData.m_135353_(ArcherEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static int nextVariant = 1;

    public ArcherEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<ArcherEntity>)((EntityType)ValarianConquestModEntities.ARCHER.get()), world);
    }

    public ArcherEntity(EntityType<ArcherEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.6f);
        this.f_21364_ = 5;
        this.m_21557_(false);
        this.m_21530_();
        if (!world.f_46443_) {
            this.setTextureVariant(nextVariant);
            if (++nextVariant > 24) {
                nextVariant = 1;
            }
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SHEATHE_STATE, (Object)0);
        this.f_19804_.m_135372_(TEXTURE_VARIANT, (Object)1);
        this.f_19804_.m_135372_(IS_CHARGING_CROSSBOW, (Object)false);
        this.f_19804_.m_135372_(CROSSBOW_CHARGED, (Object)false);
        this.f_19804_.m_135372_(IS_AIMING, (Object)false);
    }

    @Override
    public int getSheatheState() {
        return (Integer)this.f_19804_.m_135370_(DATA_SHEATHE_STATE);
    }

    @Override
    public void setSheatheState(int state) {
        this.f_19804_.m_135381_(DATA_SHEATHE_STATE, (Object)state);
    }

    public void setChargingCrossbow(boolean charging) {
        this.f_19804_.m_135381_(IS_CHARGING_CROSSBOW, (Object)charging);
    }

    public boolean isChargingCrossbow() {
        return (Boolean)this.f_19804_.m_135370_(IS_CHARGING_CROSSBOW);
    }

    public void setCrossbowCharged(boolean charged) {
        this.f_19804_.m_135381_(CROSSBOW_CHARGED, (Object)charged);
    }

    public boolean isCrossbowCharged() {
        return (Boolean)this.f_19804_.m_135370_(CROSSBOW_CHARGED);
    }

    public void setAiming(boolean aiming) {
        this.f_19804_.m_135381_(IS_AIMING, (Object)aiming);
    }

    public boolean isAiming() {
        return (Boolean)this.f_19804_.m_135370_(IS_AIMING);
    }

    public void setTextureVariant(int variant) {
        this.f_19804_.m_135381_(TEXTURE_VARIANT, (Object)variant);
    }

    public int getTextureVariant() {
        return (Integer)this.f_19804_.m_135370_(TEXTURE_VARIANT);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("sheatheState", this.getSheatheState());
        tag.m_128405_("TextureVariant", this.getTextureVariant());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("sheatheState")) {
            this.setSheatheState(tag.m_128451_("sheatheState"));
        }
        if (tag.m_128441_("TextureVariant")) {
            this.setTextureVariant(tag.m_128451_("TextureVariant"));
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean isHoldingRangedWeapon() {
        return this.m_21205_().m_41720_() instanceof BowItem || this.m_21205_().m_41720_() instanceof CrossbowItem || this.m_21206_().m_41720_() instanceof BowItem || this.m_21206_().m_41720_() instanceof CrossbowItem;
    }

    public boolean isHoldingCrossbow() {
        return this.m_21205_().m_41720_() instanceof CrossbowItem || this.m_21206_().m_41720_() instanceof CrossbowItem;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new CustomRangedAttackGoal(this, 0.75, 60, 32.0f));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal<LivingEntity>((Mob)this, LivingEntity.class, 10, true, true, entity -> {
            if (entity instanceof Player || entity instanceof Monster) {
                return true;
            }
            if (entity instanceof Villager) {
                Villager villager = (Villager)entity;
                CompoundTag persistent = this.getPersistentData();
                return persistent == null || !persistent.m_128471_("claimed_citizen");
            }
            return false;
        }){

            protected AABB m_7255_(double targetDistance) {
                return this.f_26135_.m_20191_().m_82377_(targetDistance, 20.0, targetDistance);
            }

            public boolean m_8045_() {
                LivingEntity livingEntity = this.f_26050_;
                if (livingEntity instanceof Villager) {
                    Villager villager = (Villager)livingEntity;
                    CompoundTag persistent = ArcherEntity.this.getPersistentData();
                    if (persistent != null && persistent.m_128471_("claimed_citizen")) {
                        return false;
                    }
                }
                return super.m_8045_();
            }
        });
        this.f_21346_.m_25352_(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 12.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new FloatGoal((Mob)this));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public double m_6049_() {
        return -0.35;
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("valarian_conquest:malehurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("valarian_conquest:maledie"));
    }

    public void m_8107_() {
        super.m_8107_();
        LivingEntity target = this.m_5448_();
        if (target != null) {
            float yawDifference;
            this.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            for (yawDifference = this.f_20885_ - this.f_20883_; yawDifference < -180.0f; yawDifference += 360.0f) {
            }
            while (yawDifference >= 180.0f) {
                yawDifference -= 360.0f;
            }
            this.f_20883_ += yawDifference * 0.3f;
        }
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        ItemStack mainHand = this.m_21205_();
        ItemStack offHand = this.m_21206_();
        if (mainHand.m_41720_() instanceof CrossbowItem) {
            this.performCrossbowAttack((LivingEntity)this, target, mainHand, 1.6f);
        } else if (offHand.m_41720_() instanceof CrossbowItem) {
            this.performCrossbowAttack((LivingEntity)this, target, offHand, 1.6f);
        } else {
            this.performBowAttack(target, distanceFactor);
        }
    }

    private void performBowAttack(LivingEntity target, float distanceFactor) {
        Arrow arrow = new Arrow(this.m_9236_(), (LivingEntity)this);
        Vec3 lookVec = this.m_20252_(1.0f);
        double spawnDist = 1.0;
        double spawnX = this.m_20185_() + lookVec.f_82479_ * spawnDist;
        double spawnY = this.m_20188_() - 0.1;
        double spawnZ = this.m_20189_() + lookVec.f_82481_ * spawnDist;
        arrow.m_6034_(spawnX, spawnY, spawnZ);
        arrow.m_5602_((Entity)this);
        arrow.m_36781_(4.0);
        arrow.f_36705_ = AbstractArrow.Pickup.ALLOWED;
        arrow.m_36762_(false);
        double dx = target.m_20185_() - arrow.m_20185_();
        double dy = target.m_20186_() + (double)target.m_20206_() * 0.5 - arrow.m_20186_();
        double dz = target.m_20189_() - arrow.m_20189_();
        double distHoriz = Math.sqrt(dx * dx + dz * dz);
        float velocity = Math.min(3.0f, 1.0f + (float)distHoriz / 15.0f);
        arrow.m_6686_(dx, dy + distHoriz * 0.15, dz, velocity, 1.0f);
        this.m_5496_(SoundEvents.f_11687_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)arrow);
    }

    private void performCrossbowAttack(LivingEntity shooter, LivingEntity target, ItemStack crossbow, float velocity) {
        AbstractArrow arrow = ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)Items.f_42412_.m_7968_(), (float)1.6f);
        Vec3 lookVec = this.m_20252_(1.0f);
        double spawnDist = 1.0;
        double spawnX = this.m_20185_() + lookVec.f_82479_ * spawnDist;
        double spawnY = this.m_20188_() - 0.1;
        double spawnZ = this.m_20189_() + lookVec.f_82481_ * spawnDist;
        arrow.m_6034_(spawnX, spawnY, spawnZ);
        arrow.m_5602_((Entity)this);
        arrow.f_36705_ = AbstractArrow.Pickup.ALLOWED;
        if (arrow instanceof Arrow) {
            Arrow regularArrow = (Arrow)arrow;
            regularArrow.m_36762_(false);
        }
        double dx = target.m_20185_() - arrow.m_20185_();
        double dy = target.m_20186_() + (double)target.m_20206_() * 0.5 - arrow.m_20186_();
        double dz = target.m_20189_() - arrow.m_20189_();
        double distHoriz = Math.sqrt(dx * dx + dz * dz);
        arrow.m_6686_(dx, dy + distHoriz * 0.2, dz, 1.6f, (float)(14 - this.m_9236_().m_46791_().m_19028_() * 4));
        this.m_5496_(SoundEvents.f_11847_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)arrow);
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22277_, 40.0);
    }

    private static class CustomRangedAttackGoal
    extends RangedAttackGoal {
        private final ArcherEntity archer;
        private final double speedModifier;
        private int attackTime = -1;
        private int seeTime;
        private int aimingTicks = 0;
        private boolean crossbowCharged = false;

        public CustomRangedAttackGoal(ArcherEntity mob, double speedModifier, int attackInterval, float attackRadius) {
            super((RangedAttackMob)mob, speedModifier, attackInterval, attackRadius);
            this.archer = mob;
            this.speedModifier = speedModifier;
        }

        public boolean m_8036_() {
            boolean canUse;
            boolean bl = canUse = super.m_8036_() && this.archer.isHoldingRangedWeapon();
            if (canUse) {
                this.archer.setAiming(true);
            }
            return canUse;
        }

        public void m_8056_() {
            ItemStack weapon;
            super.m_8056_();
            this.attackTime = -1;
            this.seeTime = 0;
            this.crossbowCharged = false;
            this.aimingTicks = 0;
            this.archer.setAiming(true);
            this.archer.setChargingCrossbow(false);
            this.archer.setCrossbowCharged(false);
            ItemStack itemStack = weapon = this.archer.m_21205_().m_41720_() instanceof BowItem || this.archer.m_21205_().m_41720_() instanceof CrossbowItem ? this.archer.m_21205_() : this.archer.m_21206_();
            if (!weapon.m_41619_()) {
                this.archer.m_6672_(weapon == this.archer.m_21205_() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
                if (this.archer.isHoldingCrossbow()) {
                    this.archer.setChargingCrossbow(true);
                }
            }
        }

        public void m_8041_() {
            super.m_8041_();
            this.archer.m_5810_();
            this.archer.setChargingCrossbow(false);
            this.archer.setCrossbowCharged(false);
            this.archer.setAiming(false);
            this.crossbowCharged = false;
            this.aimingTicks = 0;
        }

        public void m_8037_() {
            LivingEntity target = this.archer.m_5448_();
            if (target == null) {
                return;
            }
            double distSq = this.archer.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            boolean canSee = this.archer.m_21574_().m_148306_((Entity)target);
            this.seeTime = canSee ? ++this.seeTime : 0;
            this.archer.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            this.archer.m_5618_(this.archer.m_6080_());
            if (distSq <= 1024.0 && this.seeTime >= 5) {
                this.archer.m_21573_().m_26573_();
            } else {
                this.archer.m_21573_().m_5624_((Entity)target, this.speedModifier);
            }
            if (--this.attackTime == 0) {
                ItemStack weapon;
                if (!canSee) {
                    this.attackTime = 60;
                    return;
                }
                this.archer.setAiming(true);
                ItemStack itemStack = weapon = this.archer.m_21205_().m_41720_() instanceof BowItem || this.archer.m_21205_().m_41720_() instanceof CrossbowItem ? this.archer.m_21205_() : this.archer.m_21206_();
                if (!weapon.m_41619_()) {
                    this.archer.m_6672_(weapon == this.archer.m_21205_() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
                    if (this.archer.isHoldingCrossbow()) {
                        this.archer.setChargingCrossbow(true);
                        this.archer.setCrossbowCharged(false);
                        this.crossbowCharged = false;
                        this.aimingTicks = 0;
                    }
                }
                this.attackTime = -1;
            } else if (this.attackTime < 0) {
                int useTime = this.archer.m_21252_();
                if (useTime == 0 || !this.archer.m_6117_()) {
                    ItemStack weapon;
                    ItemStack itemStack = weapon = this.archer.m_21205_().m_41720_() instanceof BowItem || this.archer.m_21205_().m_41720_() instanceof CrossbowItem ? this.archer.m_21205_() : this.archer.m_21206_();
                    if (!weapon.m_41619_()) {
                        this.archer.m_6672_(weapon == this.archer.m_21205_() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
                    }
                }
                if (this.archer.isHoldingCrossbow()) {
                    if (!this.crossbowCharged) {
                        if (useTime >= 25) {
                            this.archer.setChargingCrossbow(false);
                            this.archer.setCrossbowCharged(true);
                            this.crossbowCharged = true;
                            this.aimingTicks = 0;
                        }
                    } else {
                        ++this.aimingTicks;
                        if (this.aimingTicks >= 15) {
                            float distFactor = (float)Math.sqrt(distSq) / 32.0f;
                            this.archer.m_6504_(target, distFactor);
                            this.archer.m_5810_();
                            this.archer.setCrossbowCharged(false);
                            this.archer.setChargingCrossbow(false);
                            this.archer.setAiming(false);
                            this.attackTime = 60;
                            this.crossbowCharged = false;
                            this.aimingTicks = 0;
                        }
                    }
                } else if (useTime >= 20) {
                    float distFactor = (float)Math.sqrt(distSq) / 32.0f;
                    this.archer.m_6504_(target, distFactor);
                    this.archer.m_5810_();
                    this.archer.setAiming(false);
                    this.attackTime = 60;
                }
            }
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }
    }
}

