/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slopeslab;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.blockentity.doubled.FramedDoubleSlopeSlabBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;
import xfacthd.framedblocks.common.util.DoubleBlockTopInteractionMode;

public class FramedDoubleSlopeSlabBlock
extends AbstractFramedDoubleBlock {
    private static final VoxelShape SHAPE_BOTTOM = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape SHAPE_TOP = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public FramedDoubleSlopeSlabBlock() {
        super(BlockType.FRAMED_DOUBLE_SLOPE_SLAB);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)PropertyHolder.TOP_HALF, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.TOP_HALF, BlockStateProperties.f_61362_, FramedProperties.Y_SLOPE});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withTargetOrHorizontalFacing()).withTop(PropertyHolder.TOP_HALF)).withWater()).build();
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        if (this.isIntangible(state, level, pos, ctx)) {
            return Shapes.m_83040_();
        }
        return (Boolean)state.m_61143_((Property)PropertyHolder.TOP_HALF) != false ? SHAPE_TOP : SHAPE_BOTTOM;
    }

    @Override
    public boolean doesBlockOccludeBeaconBeam(BlockState state, LevelReader level, BlockPos pos) {
        return true;
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        if (Utils.isY(face)) {
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(dir));
        }
        if (rot != Rotation.NONE) {
            return (BlockState)state.m_61122_((Property)PropertyHolder.TOP_HALF);
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return this.rotate(state, Direction.UP, rot);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return Utils.mirrorFaceBlock(state, mirror);
    }

    @Override
    public Tuple<BlockState, BlockState> calculateBlockPair(BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean topHalf = (Boolean)state.m_61143_((Property)PropertyHolder.TOP_HALF);
        boolean ySlope = (Boolean)state.m_61143_((Property)FramedProperties.Y_SLOPE);
        BlockState defState = ((Block)FBContent.BLOCK_FRAMED_SLOPE_SLAB.get()).m_49966_();
        return new Tuple((Object)((BlockState)((BlockState)((BlockState)((BlockState)defState.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing)).m_61124_((Property)PropertyHolder.TOP_HALF, (Comparable)Boolean.valueOf(topHalf))).m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))), (Object)((BlockState)((BlockState)((BlockState)((BlockState)defState.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing.m_122424_())).m_61124_((Property)PropertyHolder.TOP_HALF, (Comparable)Boolean.valueOf(topHalf))).m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(true))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))));
    }

    @Override
    public DoubleBlockTopInteractionMode calculateTopInteractionMode(BlockState state) {
        return DoubleBlockTopInteractionMode.SECOND;
    }

    @Override
    public CamoGetter calculateCamoGetter(BlockState state, Direction side, @Nullable Direction edge) {
        Direction dirTwo;
        Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean top = (Boolean)state.m_61143_((Property)PropertyHolder.TOP_HALF);
        Direction direction = dirTwo = top ? Direction.UP : Direction.DOWN;
        if (side == Direction.UP && top || side == facing.m_122424_() && edge == dirTwo) {
            return CamoGetter.SECOND;
        }
        if (side == Direction.DOWN && !top || side == facing && edge == dirTwo) {
            return CamoGetter.FIRST;
        }
        if (side.m_122434_() == facing.m_122427_().m_122434_() && edge == dirTwo) {
            return top ? CamoGetter.SECOND : CamoGetter.FIRST;
        }
        return CamoGetter.NONE;
    }

    @Override
    public SolidityCheck calculateSolidityCheck(BlockState state, Direction side) {
        boolean topHalf = (Boolean)state.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (topHalf && side == Direction.UP) {
            return SolidityCheck.SECOND;
        }
        if (!topHalf && side == Direction.DOWN) {
            return SolidityCheck.FIRST;
        }
        return SolidityCheck.NONE;
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FramedDoubleSlopeSlabBlockEntity(pos, state);
    }

    public static BlockState itemModelSource() {
        return ((Block)FBContent.BLOCK_FRAMED_DOUBLE_SLOPE_SLAB.get()).m_49966_();
    }
}

