/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.network;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.internals.SpellCastSyncHelper;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.SpellRegistry;
import net.spell_engine.network.Packets;

public class ServerNetwork {
    private static class_2540 configSerialized = PacketByteBufs.create();

    public static void initializeHandlers() {
        configSerialized = Packets.ConfigSync.write(SpellEngineMod.config);
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            sender.sendPacket(Packets.SpellRegistrySync.ID, SpellRegistry.encoded);
            sender.sendPacket(Packets.ConfigSync.ID, configSerialized);
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Packets.SpellCastSync.ID, (server, player, handler, buf, responseSender) -> {
            class_3218 world = (class_3218)Iterables.tryFind((Iterable)server.method_3738(), element -> element == player.method_37908()).orNull();
            if (world == null || world.field_9236) {
                return;
            }
            Packets.SpellCastSync packet = Packets.SpellCastSync.read(buf);
            world.method_8503().method_40000(() -> {
                if (packet.spellId() == null) {
                    SpellCastSyncHelper.clearCasting((class_1657)player);
                } else {
                    SpellHelper.startCasting((class_1657)player, packet.spellId(), packet.speed(), packet.length());
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Packets.SpellRequest.ID, (server, player, handler, buf, responseSender) -> {
            class_3218 world = (class_3218)Iterables.tryFind((Iterable)server.method_3738(), element -> element == player.method_37908()).orNull();
            if (world == null || world.field_9236) {
                return;
            }
            Packets.SpellRequest packet = Packets.SpellRequest.read(buf);
            world.method_8503().method_40000(() -> {
                ArrayList<class_1297> targets = new ArrayList<class_1297>();
                for (int targetId : packet.targets()) {
                    class_1297 entity = world.method_31424(targetId);
                    if (entity != null) {
                        targets.add(entity);
                        continue;
                    }
                    System.err.println("Spell Engine: Trying to perform spell " + packet.spellId().toString() + " Entity not found: " + targetId);
                }
                SpellHelper.performSpell((class_1937)world, (class_1657)player, packet.spellId(), targets, packet.action(), packet.progress());
            });
        });
    }
}

