/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.internals;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.spell_engine.network.Packets;

public class SpellCooldownManager {
    private final Map<class_2960, Entry> entries = Maps.newHashMap();
    private int tick;
    private final class_1657 owner;

    public SpellCooldownManager(class_1657 owner) {
        this.owner = owner;
    }

    public boolean isCoolingDown(class_2960 spell) {
        return this.getCooldownProgress(spell, 0.0f) > 0.0f;
    }

    public float getCooldownProgress(class_2960 spell, float tickDelta) {
        Entry entry = this.entries.get(spell);
        if (entry != null) {
            float f = entry.endTick - entry.startTick;
            float g = (float)entry.endTick - ((float)this.tick + tickDelta);
            return class_3532.method_15363((float)(g / f), (float)0.0f, (float)1.0f);
        }
        return 0.0f;
    }

    public void update() {
        ++this.tick;
        if (!this.entries.isEmpty()) {
            Iterator<Map.Entry<class_2960, Entry>> iterator = this.entries.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<class_2960, Entry> entry = iterator.next();
                if (entry.getValue().endTick > this.tick) continue;
                iterator.remove();
                this.cooldownCleared(entry.getKey());
            }
        }
    }

    public void set(class_2960 spell, int duration, boolean force) {
        if (force || !this.entries.containsKey(spell) || this.entries.get(spell).timeLeft(this.tick) < duration) {
            this.entries.put(spell, new Entry(this.tick, this.tick + duration));
            this.cooldownSet(spell, duration);
        }
    }

    public void set(class_2960 spell, int duration) {
        this.set(spell, duration, true);
    }

    public void remove(class_2960 spell) {
        this.entries.remove(spell);
        this.cooldownCleared(spell);
    }

    protected void cooldownSet(class_2960 spell, int duration) {
        class_1657 class_16572 = this.owner;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            ServerPlayNetworking.send((class_3222)serverPlayer, (class_2960)Packets.SpellCooldown.ID, (class_2540)new Packets.SpellCooldown(spell, duration).write());
        }
    }

    protected void cooldownCleared(class_2960 spell) {
        class_1657 class_16572 = this.owner;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            ServerPlayNetworking.send((class_3222)serverPlayer, (class_2960)Packets.SpellCooldown.ID, (class_2540)new Packets.SpellCooldown(spell, 0).write());
        }
    }

    record Entry(int startTick, int endTick) {
        int timeLeft(int currentTick) {
            return Math.max(0, this.endTick - currentTick);
        }
    }
}

