/*
 * Decompiled with CFR 0.152.
 */
package com.respawningstructures.event;

import com.respawningstructures.RespawningStructures;
import com.respawningstructures.config.CommonConfiguration;
import com.respawningstructures.structure.RespawnLevelData;
import com.respawningstructures.structure.RespawnManager;
import java.util.Calendar;
import java.util.HashSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventHandler {
    private static final TagKey<Block> REDSTONE = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("respawningstructures", "redstone"));
    public static final TagKey<Block> KEEP_EXISTING = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("respawningstructures", "keepexisting"));
    public static final TagKey<Block> NO_RESPAWN = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("respawningstructures", "norespawn"));
    private static long lastTime = 0L;

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.getServer().m_129921_() % 100 == 35) {
            if (lastTime == 0L) {
                lastTime = Calendar.getInstance().getTimeInMillis();
                return;
            }
            if (event.getServer().m_7416_() > 0 && Calendar.getInstance().getTimeInMillis() - lastTime > 300000L) {
                lastTime = Calendar.getInstance().getTimeInMillis();
                for (ServerLevel level : event.getServer().m_129785_()) {
                    RespawnLevelData respawnLevelData = (RespawnLevelData)level.m_8895_().m_164861_(RespawnLevelData::load, RespawnLevelData::new, "respawningdungeonsdata");
                    if (respawnLevelData == null) continue;
                    respawnLevelData.increaseTime(300);
                }
            }
        }
        if (((CommonConfiguration)RespawningStructures.config.getCommonConfig()).needReload) {
            ((CommonConfiguration)RespawningStructures.config.getCommonConfig()).needReload = false;
            HashSet toAddBlackList = new HashSet();
            try {
                for (String string : ((CommonConfiguration)RespawningStructures.config.getCommonConfig()).blacklistedStructures) {
                    ResourceLocation id;
                    if (!string.startsWith("#") || (id = ResourceLocation.m_135820_((String)string.replace("#", ""))) == null) continue;
                    ((Registry)event.getServer().m_206579_().m_6632_(Registries.f_256944_).get()).m_203561_(TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)id)).forEach(a -> toAddBlackList.add(((ResourceKey)a.m_203543_().get()).m_135782_().toString()));
                }
            }
            catch (Exception e) {
                RespawningStructures.LOGGER.warn("Error during trying to parse structure blacklist for tags: ", (Throwable)e);
            }
            ((CommonConfiguration)RespawningStructures.config.getCommonConfig()).blacklistedStructures.addAll(toAddBlackList);
            HashSet toAddWhitelist = new HashSet();
            try {
                for (String blackListEntry : ((CommonConfiguration)RespawningStructures.config.getCommonConfig()).respawnableStructureIDs) {
                    ResourceLocation id;
                    if (!blackListEntry.startsWith("#") || (id = ResourceLocation.m_135820_((String)blackListEntry.replace("#", ""))) == null) continue;
                    ((Registry)event.getServer().m_206579_().m_6632_(Registries.f_256944_).get()).m_203561_(TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)id)).forEach(a -> toAddWhitelist.add(((ResourceKey)a.m_203543_().get()).m_135782_().toString()));
                }
            }
            catch (Exception exception) {
                RespawningStructures.LOGGER.warn("Error during trying to parse structure whitelist for tags: ", (Throwable)exception);
            }
            ((CommonConfiguration)RespawningStructures.config.getCommonConfig()).respawnableStructureIDs.addAll(toAddWhitelist);
        }
    }

    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.level.f_46443_ && event.level.m_46467_() % 1000L == 17L) {
            RespawnManager.onLevelTick((ServerLevel)event.level);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getPlayer() instanceof ServerPlayer) {
            if (event.getState().m_155947_() && event.getLevel().m_7702_(event.getPos()) instanceof SpawnerBlockEntity) {
                RespawnManager.onSpawnerKilled((SpawnerBlockEntity)event.getLevel().m_7702_(event.getPos()));
            } else if (event.getState().m_61138_((Property)BlockStateProperties.f_61426_) || event.getState().m_204336_(REDSTONE)) {
                RespawnManager.onRedstoneDestroyed((ServerPlayer)event.getPlayer(), event.getPos());
            } else {
                RespawnManager.onBlockBreak((ServerPlayer)event.getPlayer(), event.getPos());
            }
        }
    }

    @SubscribeEvent
    public static void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            if (event.getState().m_60791_() > 0) {
                RespawnManager.onLightPlaced((ServerPlayer)event.getEntity(), event.getPos());
            } else if (event.getState().m_61138_((Property)BlockStateProperties.f_61426_) || event.getState().m_204336_(REDSTONE)) {
                RespawnManager.onRedstonePlaced((ServerPlayer)event.getEntity(), event.getPos());
            } else {
                RespawnManager.onBlockPlaced((ServerPlayer)event.getEntity(), event.getPos());
            }
        }
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Detonate event) {
        if (!event.getLevel().f_46443_) {
            RespawnManager.onExplosion(event.getLevel(), event.getExplosion(), event.getAffectedBlocks());
        }
    }

    @SubscribeEvent
    public static void onLevelLoad(LevelEvent.Load event) {
        if (!event.getLevel().m_5776_()) {
            // empty if block
        }
    }

    @SubscribeEvent
    public static void onMobKilled(LivingDeathEvent event) {
        if (!event.getEntity().m_9236_().m_5776_() && event.getSource().m_7639_() instanceof ServerPlayer) {
            RespawnManager.onMobKilled(event.getEntity());
        } else if (event.getEntity() instanceof ServerPlayer) {
            RespawnManager.onPlayerDeath((ServerPlayer)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onEntityAdded(EntityJoinLevelEvent event) {
        if (!event.getLevel().f_46443_ && !RespawnManager.tryAddEntityDuringRespawn(event.getEntity(), (ServerLevel)event.getLevel(), event.getEntity().m_20183_())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityAdded(MobSpawnEvent.FinalizeSpawn event) {
        if (!event.getLevel().m_5776_() && event.getSpawnType() == MobSpawnType.SPAWNER && event.getEntity() != null) {
            RespawnManager.onSpawnerSpawn(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            RespawnManager.onPlayerLogin((ServerPlayer)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            RespawnManager.onPlayerRespawn((ServerPlayer)event.getEntity());
        }
    }
}

