/*
 * Decompiled with CFR 0.152.
 */
package weather2.util;

import com.corosus.coroutil.util.CoroUtilEntOrParticle;
import extendedrenderer.particle.entity.EntityRotFX;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import weather2.util.WeatherUtilBlock;
import weather2.util.WeatherUtilParticle;

public class WeatherUtilEntity {
    public static HashMap<Item, Float> armorToWeight = new HashMap();

    public static float getWeight(Object entity1, boolean forTornado) {
        float var;
        Level world = CoroUtilEntOrParticle.getWorld((Object)entity1);
        if (world == null) {
            return 1.0f;
        }
        if (WeatherUtilEntity.isParticleRotServerSafe(world, entity1) && (var = WeatherUtilParticle.getParticleWeight((EntityRotFX)entity1)) != -1.0f) {
            return var;
        }
        if (entity1 instanceof Squid) {
            return 400.0f;
        }
        if (entity1 instanceof LivingEntity) {
            LivingEntity livingEnt = (LivingEntity)entity1;
            int airTime = livingEnt.getPersistentData().m_128451_("timeInAir");
            airTime = livingEnt.m_20096_() || livingEnt.m_20069_() ? 0 : ++airTime;
            livingEnt.getPersistentData().m_128405_("timeInAir", airTime);
            if (entity1 instanceof Player) {
                if (((Player)entity1).f_36077_.f_35937_) {
                    return 1.0E8f;
                }
                return 5.0f + (float)airTime / 400.0f;
            }
            return 500.0f + (livingEnt.m_20096_() ? 2.0f : 0.0f) + (float)airTime / 400.0f;
        }
        if (entity1 instanceof Boat || entity1 instanceof ItemEntity || entity1 instanceof FishingHook) {
            return 4000.0f;
        }
        if (entity1 instanceof AbstractMinecart) {
            return 80.0f;
        }
        return 1.0f;
    }

    public static float getWeightAdjFromEquipment(float weightIn, Player player) {
        float influence = 1.2f;
        for (ItemStack stack : player.m_6168_()) {
            if (!armorToWeight.containsKey(stack.m_41720_())) continue;
            weightIn += armorToWeight.get(stack.m_41720_()).floatValue() * influence;
        }
        return weightIn;
    }

    public static float getWeight(Object entity1) {
        float var;
        Level world = CoroUtilEntOrParticle.getWorld((Object)entity1);
        if (world == null) {
            return 1.0f;
        }
        if (WeatherUtilEntity.isParticleRotServerSafe(world, entity1) && (var = WeatherUtilParticle.getParticleWeight((EntityRotFX)entity1)) != -1.0f) {
            return var;
        }
        if (entity1 instanceof Squid) {
            return 400.0f;
        }
        if (entity1 instanceof LivingEntity) {
            LivingEntity livingEnt = (LivingEntity)entity1;
            int airTime = livingEnt.getPersistentData().m_128451_("timeInAir");
            airTime = livingEnt.m_20096_() || livingEnt.m_20069_() ? 0 : ++airTime;
            livingEnt.getPersistentData().m_128405_("timeInAir", airTime);
            if (entity1 instanceof Player) {
                if (((Player)entity1).f_36077_.f_35937_) {
                    return 1.0E8f;
                }
                return 5.0f + (float)airTime / 400.0f;
            }
            return 500.0f + (livingEnt.m_20096_() ? 2.0f : 0.0f) + (float)airTime / 400.0f;
        }
        if (entity1 instanceof Boat || entity1 instanceof ItemEntity || entity1 instanceof FishingHook) {
            return 4000.0f;
        }
        if (entity1 instanceof AbstractMinecart) {
            return 80.0f;
        }
        return 1.0f;
    }

    public static boolean isParticleRotServerSafe(Level world, Object obj) {
        if (EffectiveSide.get().equals((Object)LogicalSide.SERVER)) {
            return false;
        }
        if (!world.f_46443_) {
            return false;
        }
        return WeatherUtilEntity.isParticleRotClientCheck(obj);
    }

    public static boolean isParticleRotClientCheck(Object obj) {
        return obj instanceof EntityRotFX;
    }

    public static double getDistanceSqEntToPos(Entity ent, BlockPos pos) {
        return ent.m_20182_().m_82557_(Vec3.m_82512_((Vec3i)pos));
    }

    public static boolean isEntityOutside(Entity parEnt) {
        return WeatherUtilEntity.isEntityOutside(parEnt, false);
    }

    public static boolean isEntityOutside(Entity parEnt, boolean cheapCheck) {
        return WeatherUtilEntity.isPosOutside(parEnt.m_9236_(), parEnt.m_20182_(), cheapCheck, false);
    }

    public static boolean isPosOutside(Level parWorld, Vec3 parPos) {
        return WeatherUtilEntity.isPosOutside(parWorld, parPos, false, false);
    }

    public static boolean isPosOutside(Level parWorld, Vec3 parPos, boolean cheapCheck, boolean eachSideClearCheck) {
        int height = WeatherUtilBlock.getPrecipitationHeightSafe(parWorld, new BlockPos(Mth.m_14107_((double)parPos.f_82479_), 0, Mth.m_14107_((double)parPos.f_82481_))).m_123342_();
        if ((double)height < parPos.f_82480_ + 1.0) {
            return true;
        }
        if (cheapCheck) {
            return false;
        }
        int rangeCheck = 5;
        boolean yOffset = false;
        int xzInitialOffset = 1;
        boolean nsCheck = false;
        Vec3 vecTry = new Vec3(parPos.f_82479_ + (double)(Direction.NORTH.m_122429_() * rangeCheck), parPos.f_82480_ + (double)yOffset, parPos.f_82481_ + (double)(Direction.NORTH.m_122431_() * rangeCheck));
        Vec3 parPosTry = new Vec3(parPos.f_82479_ + (double)(Direction.NORTH.m_122429_() * xzInitialOffset), parPos.f_82480_ + (double)yOffset, parPos.f_82481_ + (double)(Direction.NORTH.m_122431_() * xzInitialOffset));
        if (WeatherUtilEntity.checkVecOutside(parWorld, parPosTry, vecTry)) {
            if (eachSideClearCheck) {
                nsCheck = true;
            } else {
                return true;
            }
        }
        vecTry = new Vec3(parPos.f_82479_ + (double)(Direction.SOUTH.m_122429_() * rangeCheck), parPos.f_82480_ + (double)yOffset, parPos.f_82481_ + (double)(Direction.SOUTH.m_122431_() * rangeCheck));
        parPosTry = new Vec3(parPos.f_82479_ + (double)(Direction.SOUTH.m_122429_() * xzInitialOffset), parPos.f_82480_ + (double)yOffset, parPos.f_82481_ + (double)(Direction.SOUTH.m_122431_() * xzInitialOffset));
        if (WeatherUtilEntity.checkVecOutside(parWorld, parPosTry, vecTry)) {
            if (eachSideClearCheck) {
                return nsCheck;
            }
            return true;
        }
        nsCheck = false;
        vecTry = new Vec3(parPos.f_82479_ + (double)(Direction.EAST.m_122429_() * rangeCheck), parPos.f_82480_ + (double)yOffset, parPos.f_82481_ + (double)(Direction.EAST.m_122431_() * rangeCheck));
        parPosTry = new Vec3(parPos.f_82479_ + (double)(Direction.EAST.m_122429_() * xzInitialOffset), parPos.f_82480_ + (double)yOffset, parPos.f_82481_ + (double)(Direction.EAST.m_122431_() * xzInitialOffset));
        if (WeatherUtilEntity.checkVecOutside(parWorld, parPosTry, vecTry)) {
            if (eachSideClearCheck) {
                nsCheck = true;
            } else {
                return true;
            }
        }
        vecTry = new Vec3(parPos.f_82479_ + (double)(Direction.WEST.m_122429_() * rangeCheck), parPos.f_82480_ + (double)yOffset, parPos.f_82481_ + (double)(Direction.WEST.m_122431_() * rangeCheck));
        parPosTry = new Vec3(parPos.f_82479_ + (double)(Direction.WEST.m_122429_() * xzInitialOffset), parPos.f_82480_ + (double)yOffset, parPos.f_82481_ + (double)(Direction.WEST.m_122431_() * xzInitialOffset));
        if (WeatherUtilEntity.checkVecOutside(parWorld, parPosTry, vecTry)) {
            if (eachSideClearCheck) {
                return nsCheck;
            }
            return true;
        }
        return false;
    }

    public static boolean checkVecOutside(Level parWorld, Vec3 parPos, Vec3 parCheckPos) {
        int height;
        BlockHitResult blockhitresult = parWorld.m_45547_(new ClipContext(parPos, parCheckPos, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, null));
        return blockhitresult.m_6662_() == HitResult.Type.MISS && (double)(height = WeatherUtilBlock.getPrecipitationHeightSafe(parWorld, new BlockPos(Mth.m_14107_((double)parCheckPos.f_82479_), 0, Mth.m_14107_((double)parCheckPos.f_82481_))).m_123342_()) < parCheckPos.f_82480_;
    }

    public static boolean isPlayerSheltered(Entity player) {
        int x = Mth.m_14107_((double)player.m_20185_());
        int y = Mth.m_14107_((double)(player.m_20186_() + (double)player.m_20192_()));
        int z = Mth.m_14107_((double)player.m_20189_());
        return player.m_9236_().m_6924_(Heightmap.Types.MOTION_BLOCKING, x, z) > y;
    }

    public static boolean canPosSeePos(Level level, Vec3 pos1, Vec3 pos2) {
        Vec3 vec3 = new Vec3(pos1.m_7096_(), pos1.m_7098_(), pos1.m_7094_());
        Vec3 vec31 = new Vec3(pos2.m_7096_(), pos2.m_7098_(), pos2.m_7094_());
        if (vec31.m_82554_(vec3) > 128.0) {
            return false;
        }
        return level.m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null)).m_6662_() == HitResult.Type.MISS;
    }

    static {
        armorToWeight.put(Items.f_42468_, Float.valueOf(0.1f));
        armorToWeight.put(Items.f_42469_, Float.valueOf(0.2f));
        armorToWeight.put(Items.f_42470_, Float.valueOf(0.15f));
        armorToWeight.put(Items.f_42471_, Float.valueOf(0.1f));
        armorToWeight.put(Items.f_42476_, Float.valueOf(0.1f));
        armorToWeight.put(Items.f_42477_, Float.valueOf(0.2f));
        armorToWeight.put(Items.f_42478_, Float.valueOf(0.15f));
        armorToWeight.put(Items.f_42479_, Float.valueOf(0.1f));
        armorToWeight.put(Items.f_42472_, Float.valueOf(0.1f));
        armorToWeight.put(Items.f_42473_, Float.valueOf(0.2f));
        armorToWeight.put(Items.f_42474_, Float.valueOf(0.15f));
        armorToWeight.put(Items.f_42475_, Float.valueOf(0.1f));
    }
}

