/*
 * Decompiled with CFR 0.152.
 */
package weather2;

import com.corosus.coroutil.util.CULog;
import extendedrenderer.ParticleManagerExtended;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;
import weather2.ClientWeatherHelper;
import weather2.ClientWeatherProxy;
import weather2.PacketNBTFromClient;
import weather2.Weather;
import weather2.WeatherNetworking;
import weather2.client.SceneEnhancer;
import weather2.config.ClientConfigData;
import weather2.config.ConfigDebug;
import weather2.util.WeatherUtil;
import weather2.util.WindReader;
import weather2.weathersystem.WeatherManagerClient;

@Mod.EventBusSubscriber(modid="weather2", value={Dist.CLIENT})
public class ClientTickHandler {
    public static final ClientTickHandler INSTANCE = new ClientTickHandler();
    public static Level lastWorld;
    public static WeatherManagerClient weatherManager;
    public static SceneEnhancer sceneEnhancer;
    public static ClientConfigData clientConfigData;
    public float smoothAngle = 0.0f;
    public float smoothAngleRotationalVelAccel = 0.0f;
    public float smoothAngleAdj = 0.1f;
    public int prevDir = 0;
    public long lastParticleResetTime = 0L;
    private static ParticleManagerExtended particleManagerExtended;

    private ClientTickHandler() {
        if (sceneEnhancer == null) {
            sceneEnhancer = new SceneEnhancer();
            new Thread((Runnable)sceneEnhancer, "Weather2 Scene Enhancer").start();
        }
        clientConfigData = new ClientConfigData();
    }

    @SubscribeEvent
    public static void tick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            INSTANCE.onTickInGame();
        }
    }

    public void onTickInGame() {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel world = mc.f_91073_;
        if (world != null) {
            ClientTickHandler.getClientWeather();
            weatherManager.tick();
            sceneEnhancer.tickClient();
            if (!WeatherUtil.isPausedForClient() && ConfigDebug.Particle_engine_tick) {
                ClientTickHandler.particleManagerExtended().tick();
            }
            if (ConfigDebug.Particle_Reset_Frequency > 0 && this.lastParticleResetTime + (long)ConfigDebug.Particle_Reset_Frequency < world.m_46467_()) {
                CULog.log((String)"clearing vanilla particles, set Weather2 Debug Particle_Reset_Frequency to 0 to disable");
                this.lastParticleResetTime = world.m_46467_();
                mc.f_91061_.m_263560_();
            }
            float windDir = WindReader.getWindAngle((Level)world);
            float windSpeed = WindReader.getWindSpeed((Level)world, mc.f_91074_ != null ? mc.f_91074_.m_20183_() : null);
            float diff = Math.abs(windDir - this.smoothAngle);
            if (diff > 10.0f) {
                if (this.smoothAngle > 180.0f) {
                    this.smoothAngle -= 360.0f;
                }
                if (this.smoothAngle < -180.0f) {
                    this.smoothAngle += 360.0f;
                }
                float bestMove = Mth.m_14177_((float)(windDir - this.smoothAngle));
                this.smoothAngleAdj = windSpeed;
                if (Math.abs(bestMove) < 180.0f) {
                    float realAdj = this.smoothAngleAdj;
                    if (realAdj * 2.0f > windSpeed) {
                        if (bestMove > 0.0f) {
                            this.smoothAngleRotationalVelAccel -= realAdj;
                            if (this.prevDir < 0) {
                                this.smoothAngleRotationalVelAccel = 0.0f;
                            }
                            this.prevDir = 1;
                        } else if (bestMove < 0.0f) {
                            this.smoothAngleRotationalVelAccel += realAdj;
                            if (this.prevDir > 0) {
                                this.smoothAngleRotationalVelAccel = 0.0f;
                            }
                            this.prevDir = -1;
                        }
                    }
                    if ((double)this.smoothAngleRotationalVelAccel > 0.3 || (double)this.smoothAngleRotationalVelAccel < -0.3) {
                        this.smoothAngle += this.smoothAngleRotationalVelAccel * 0.3f;
                    }
                    this.smoothAngleRotationalVelAccel *= 0.8f;
                }
            }
        } else {
            ClientTickHandler.resetClientWeather();
        }
    }

    public static void resetClientWeather() {
        weatherManager = null;
        ClientWeatherProxy.get().reset();
        ClientWeatherHelper.get().reset();
    }

    public static WeatherManagerClient getClientWeather() {
        try {
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            if (weatherManager == null || world != lastWorld) {
                ClientTickHandler.init((Level)world);
            }
        }
        catch (Exception ex) {
            Weather.dbg("Weather2: Warning, client received packet before it was ready to use, and failed to init client weather due to null world");
        }
        return weatherManager;
    }

    public static void init(Level world) {
        Weather.dbg("Weather2: Initializing WeatherManagerClient for client world and requesting full sync");
        lastWorld = world;
        weatherManager = new WeatherManagerClient((ResourceKey<Level>)world.m_46472_());
        Minecraft mc = Minecraft.m_91087_();
        if (particleManagerExtended == null) {
            particleManagerExtended = new ParticleManagerExtended(mc.f_91073_, mc.f_90987_);
        } else {
            particleManagerExtended.setLevel((ClientLevel)world);
        }
        CompoundTag data = new CompoundTag();
        data.m_128359_("command", "syncFull");
        data.m_128359_("packetCommand", "WeatherData");
        WeatherNetworking.HANDLER.sendTo((Object)new PacketNBTFromClient(data), mc.f_91074_.f_108617_.m_104910_(), NetworkDirection.PLAY_TO_SERVER);
    }

    public static ParticleManagerExtended particleManagerExtended() {
        return particleManagerExtended;
    }
}

