/*
 * Decompiled with CFR 0.152.
 */
package teamrazor.deepaether.world.structure.brass;

import com.aetherteam.aether.block.AetherBlocks;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import teamrazor.deepaether.block.SquashBlock;
import teamrazor.deepaether.init.DABlocks;
import teamrazor.deepaether.world.structure.brass.BrassDungeonPiece;

public abstract class AbstractBrassRoom
extends BrassDungeonPiece {
    public AbstractBrassRoom(StructurePieceType type, StructureTemplateManager manager, String name, StructurePlaceSettings settings, BlockPos pos) {
        super(type, manager, name, settings, pos);
    }

    public AbstractBrassRoom(StructurePieceType type, CompoundTag tag, StructureTemplateManager manager, Function<ResourceLocation, StructurePlaceSettings> settingsFactory) {
        super(type, tag, manager, settingsFactory);
    }

    public static StructurePlaceSettings makeSettingsWithPivot(StructurePlaceSettings settings, Rotation rotation) {
        settings.m_74385_(new BlockPos(0, 0, 0).m_5484_(Direction.EAST, 31));
        settings.m_74379_(rotation);
        return settings;
    }

    protected void m_213704_(String name, BlockPos pos, ServerLevelAccessor level, RandomSource random, BoundingBox box) {
        switch (name) {
            case "Aerlavender Flowers": {
                Block block = AbstractBrassRoom.getRandomAerlavenderFlower(random);
                level.m_7731_(pos.m_7495_(), ((Block)AetherBlocks.AETHER_GRASS_BLOCK.get()).m_49966_(), 2);
                level.m_7731_(pos, block.m_49966_(), 2);
                if (!(block instanceof DoublePlantBlock)) break;
                level.m_7731_(pos.m_7494_(), (BlockState)block.m_49966_().m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER), 2);
                break;
            }
            case "Golden Flowers": {
                Block block = AbstractBrassRoom.getRandomGoldenFlower(random);
                level.m_7731_(pos.m_7495_(), ((Block)DABlocks.GOLDEN_GRASS_BLOCK.get()).m_49966_(), 2);
                level.m_7731_(pos, block.m_49966_(), 2);
                if (!(block instanceof DoublePlantBlock)) break;
                level.m_7731_(pos.m_7494_(), (BlockState)block.m_49966_().m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER), 2);
                break;
            }
            case "Squash": {
                Block block = AbstractBrassRoom.getRandomSquash(random);
                level.m_7731_(pos, block.m_49966_(), 2);
            }
        }
    }

    public static Block getRandomAerlavenderFlower(RandomSource random) {
        return switch (random.m_188503_(4)) {
            case 0 -> (Block)DABlocks.TALL_AERLAVENDER.get();
            case 1 -> (Block)DABlocks.FEATHER_GRASS.get();
            case 2 -> (Block)DABlocks.TALL_FEATHER_GRASS.get();
            default -> (Block)DABlocks.AERLAVENDER.get();
        };
    }

    public static Block getRandomGoldenFlower(RandomSource random) {
        return switch (random.m_188503_(4)) {
            case 0 -> (Block)DABlocks.GOLDEN_ASPESS.get();
            case 1 -> (Block)DABlocks.MINI_GOLDEN_GRASS.get();
            case 2 -> (Block)DABlocks.MEDIUM_GOLDEN_GRASS.get();
            default -> (Block)DABlocks.GOLDEN_FLOWER.get();
        };
    }

    public static Block getRandomSquash(RandomSource random) {
        return switch (random.m_188503_(3)) {
            case 0 -> (SquashBlock)((Object)DABlocks.GREEN_SQUASH.get());
            case 1 -> (SquashBlock)((Object)DABlocks.BLUE_SQUASH.get());
            default -> (SquashBlock)((Object)DABlocks.PURPLE_SQUASH.get());
        };
    }

    public static class AbstractBossRoom
    extends AbstractBrassRoom {
        public AbstractBossRoom(StructurePieceType type, StructureTemplateManager manager, String name, StructurePlaceSettings settings, BlockPos pos) {
            super(type, manager, name, settings, pos);
        }

        public AbstractBossRoom(StructurePieceType type, CompoundTag tag, StructureTemplateManager manager, Function<ResourceLocation, StructurePlaceSettings> settingsFactory) {
            super(type, tag, manager, settingsFactory);
        }

        @Override
        protected void m_213704_(String name, BlockPos pos, ServerLevelAccessor level, RandomSource random, BoundingBox box) {
            super.m_213704_(name, pos, level, random, box);
        }
    }
}

