/*
 * Decompiled with CFR 0.152.
 */
package teamrazor.deepaether.item.gear;

import java.util.EnumMap;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import teamrazor.deepaether.datagen.tags.DATags;
import teamrazor.deepaether.init.DASounds;

public enum DaArmorMaterials implements StringRepresentable,
ArmorMaterial
{
    STRATUS("stratus", 37, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 3);
        map.put(ArmorItem.Type.LEGGINGS, 6);
        map.put(ArmorItem.Type.CHESTPLATE, 8);
        map.put(ArmorItem.Type.HELMET, 3);
    }), 15, (Supplier<SoundEvent>)DASounds.ITEM_ARMOR_EQUIP_STRATUS, 2.5f, 0.0f, () -> Ingredient.m_204132_(DATags.Items.STRATUS_REPAIRING)),
    SKYJADE("skyjade", 3, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 3);
        map.put(ArmorItem.Type.LEGGINGS, 6);
        map.put(ArmorItem.Type.CHESTPLATE, 8);
        map.put(ArmorItem.Type.HELMET, 3);
    }), 0, (Supplier<SoundEvent>)DASounds.ITEM_ARMOR_EQUIP_SKYJADE, 0.0f, 0.0f, () -> Ingredient.m_204132_(DATags.Items.SKYJADE_REPAIRING)),
    STORMFORGED("stormforged", 33, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 3);
        map.put(ArmorItem.Type.LEGGINGS, 6);
        map.put(ArmorItem.Type.CHESTPLATE, 8);
        map.put(ArmorItem.Type.HELMET, 3);
    }), 10, (Supplier<SoundEvent>)DASounds.ITEM_ARMOR_EQUIP_STORMFORGED, 1.5f, 0.15f, () -> Ingredient.m_43927_((ItemStack[])new ItemStack[]{ItemStack.f_41583_}));

    private static final EnumMap<ArmorItem.Type, Integer> DURABILITY_MAP;
    private final String name;
    private final int maxDamageFactor;
    private final EnumMap<ArmorItem.Type, Integer> protectionAmountMap;
    private final int enchantability;
    private final Supplier<SoundEvent> soundEvent;
    private final float toughness;
    private final Supplier<Ingredient> repairMaterial;
    private final float knockbackResistance;
    public static final StringRepresentable.EnumCodec<ArmorMaterials> CODEC;

    private DaArmorMaterials(String name, int maxDamageFactor, EnumMap<ArmorItem.Type, Integer> protectionAmountMap, int enchantability, Supplier<SoundEvent> soundEvent, float toughness, float knockbackResistance, Supplier<Ingredient> repairMaterial) {
        this.name = name;
        this.maxDamageFactor = maxDamageFactor;
        this.protectionAmountMap = protectionAmountMap;
        this.enchantability = enchantability;
        this.soundEvent = soundEvent;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.repairMaterial = repairMaterial;
    }

    public int m_266425_(ArmorItem.Type type) {
        return DURABILITY_MAP.get(type) * this.maxDamageFactor;
    }

    public int m_7366_(ArmorItem.Type type) {
        return this.protectionAmountMap.get(type);
    }

    public int m_6646_() {
        return this.enchantability;
    }

    public SoundEvent m_7344_() {
        return this.soundEvent.get();
    }

    public Ingredient m_6230_() {
        return this.repairMaterial.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public String m_6082_() {
        return this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    public String m_7912_() {
        return this.name;
    }

    static {
        DURABILITY_MAP = (EnumMap)Util.m_137469_(new EnumMap(ArmorItem.Type.class), map -> {
            map.put(ArmorItem.Type.BOOTS, 13);
            map.put(ArmorItem.Type.LEGGINGS, 15);
            map.put(ArmorItem.Type.CHESTPLATE, 16);
            map.put(ArmorItem.Type.HELMET, 11);
        });
        CODEC = StringRepresentable.m_216439_(ArmorMaterials::values);
    }
}

