/*
 * Decompiled with CFR 0.152.
 */
package teamrazor.deepaether.item.gear;

import com.aetherteam.aether.capability.player.AetherPlayer;
import com.aetherteam.aether.item.accessories.ring.RingItem;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import teamrazor.deepaether.init.DAItems;
import teamrazor.deepaether.item.gear.EquipmentUtil;

@Mod.EventBusSubscriber(modid="deep_aether")
public class DaAbilityListener {
    @SubscribeEvent
    public static void onEntityFall(LivingFallEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!event.isCanceled()) {
            event.setCanceled(DaAbilityListener.fallCancellation(livingEntity));
        }
    }

    @SubscribeEvent
    public static void onEntityJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (com.aetherteam.aether.item.EquipmentUtil.hasFullGravititeSet((LivingEntity)livingEntity) && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            AetherPlayer.get((Player)player).ifPresent(aetherPlayer -> {
                if (aetherPlayer.isGravititeJumpActive()) {
                    player.m_5997_(0.0, EquipmentUtil.handleStratusRingBoost(livingEntity) - 1.0, 0.0);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)serverPlayer));
                    }
                }
            });
        }
    }

    public static boolean fallCancellation(LivingEntity entity) {
        return EquipmentUtil.hasFullStratusSet(entity);
    }

    @SubscribeEvent
    public static void onMiningSpeed(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        if (!event.isCanceled()) {
            event.setNewSpeed(EquipmentUtil.handleSkyjadeRingAbility((LivingEntity)player, event.getNewSpeed()));
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (!event.isCanceled()) {
            EquipmentUtil.damageRing((LivingEntity)player, (RingItem)DAItems.SKYJADE_RING.get());
        }
    }
}

