/*
 * Decompiled with CFR 0.152.
 */
package net.luckperms.api.context;

import java.util.Objects;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.context.Context;
import net.luckperms.api.context.ContextSet;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface MutableContextSet
extends ContextSet {
    public static @NonNull MutableContextSet create() {
        return LuckPermsProvider.get().getContextManager().getContextSetFactory().mutable();
    }

    public static @NonNull MutableContextSet of(@NonNull String key, @NonNull String value) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        MutableContextSet set = MutableContextSet.create();
        set.add(key, value);
        return set;
    }

    public void add(@NonNull String var1, @NonNull String var2);

    default public void add(@NonNull Context entry) {
        Objects.requireNonNull(entry, "entry");
        this.add(entry.getKey(), entry.getValue());
    }

    default public void addAll(@NonNull Iterable<Context> iterable) {
        for (Context e : Objects.requireNonNull(iterable, "iterable")) {
            this.add(e);
        }
    }

    public void addAll(@NonNull ContextSet var1);

    public void remove(@NonNull String var1, @NonNull String var2);

    public void removeAll(@NonNull String var1);

    public void clear();
}

