/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.forge.loader;

import java.lang.reflect.InvocationTargetException;
import java.util.function.Supplier;
import me.lucko.luckperms.common.loader.JarInJarClassLoader;
import me.lucko.luckperms.common.loader.LoaderBootstrap;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="luckperms")
public class ForgeLoaderPlugin
implements Supplier<ModContainer> {
    private static final Logger LOGGER = LogManager.getLogger((String)"luckperms");
    private static final String JAR_NAME = "luckperms-forge.jarinjar";
    private static final String BOOTSTRAP_CLASS = "me.lucko.luckperms.forge.LPForgeBootstrap";
    private final ModContainer container = ModList.get().getModContainerByObject((Object)this).orElse(null);
    private JarInJarClassLoader loader;
    private LoaderBootstrap plugin;

    public ForgeLoaderPlugin() {
        ForgeLoaderPlugin.markAsNotRequiredClientSide();
        if (FMLEnvironment.dist.isClient()) {
            LOGGER.info("Skipping LuckPerms init (not supported on the client!)");
            return;
        }
        this.loader = new JarInJarClassLoader(this.getClass().getClassLoader(), JAR_NAME);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onCommonSetup);
    }

    @Override
    public ModContainer get() {
        return this.container;
    }

    public void onCommonSetup(FMLCommonSetupEvent event) {
        this.plugin = this.loader.instantiatePlugin(BOOTSTRAP_CLASS, Supplier.class, this);
        this.plugin.onLoad();
    }

    private static void markAsNotRequiredClientSide() {
        try {
            ModLoadingContext.class.getDeclaredMethod("registerExtensionPoint", Class.class, Supplier.class).invoke((Object)ModLoadingContext.get(), IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }
}

