/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.mixin.common.minecolonies;

import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.util.ItemStackUtils;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import steve_gall.minecolonies_tweaks.api.common.tool.ToolTypeExtension;
import steve_gall.minecolonies_tweaks.api.common.tool.ToolTypeTags;

@Mixin(value={EquipmentTypeEntry.class}, remap=false)
public abstract class EquipmentTypeEntryMixin {
    @Inject(method={"checkIsEquipment"}, remap=false, at={@At(value="HEAD")}, cancellable=true)
    private void checkIsEquipment(ItemStack itemStack, CallbackInfoReturnable<Boolean> cir) {
        EquipmentTypeEntry toolType = (EquipmentTypeEntry)this;
        if (!ItemStackUtils.isEmpty((ItemStack)itemStack)) {
            if (ToolTypeTags.isInBlacklist(itemStack, toolType.getRegistryName())) {
                cir.setReturnValue((Object)false);
            } else if (ToolTypeExtension.from(toolType).isCustomTool(itemStack)) {
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Inject(method={"getMiningLevel"}, remap=false, at={@At(value="HEAD")}, cancellable=true)
    private void getMiningLevel(ItemStack itemStack, CallbackInfoReturnable<Integer> cir) {
        ToolTypeExtension extension;
        int level;
        EquipmentTypeEntry toolType = (EquipmentTypeEntry)this;
        if (toolType.checkIsEquipment(itemStack) && (level = (extension = ToolTypeExtension.from(toolType)).getCustomLevel(itemStack)) > -1) {
            cir.setReturnValue((Object)level);
        }
    }
}

