/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.network.message;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.network.NetworkEvent;
import steve_gall.minecolonies_tweaks.api.common.network.AbstractMessage;
import steve_gall.minecolonies_tweaks.core.common.CuriosCompat;
import steve_gall.minecolonies_tweaks.core.common.MineColoniesTweaks;
import steve_gall.minecolonies_tweaks.core.common.item.ItemResourceScrollBook;

public class ResourcescrollBookOpenMessage
extends AbstractMessage {
    private final boolean request;
    private final ItemStack stack;

    public ResourcescrollBookOpenMessage() {
        this.request = true;
        this.stack = ItemStack.f_41583_;
    }

    public ResourcescrollBookOpenMessage(ItemStack stack) {
        this.request = false;
        this.stack = stack.m_41777_();
    }

    public ResourcescrollBookOpenMessage(FriendlyByteBuf buffer) {
        super(buffer);
        this.request = buffer.readBoolean();
        this.stack = buffer.m_130267_();
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.writeBoolean(this.request);
        buffer.m_130055_(this.stack);
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        super.handle(context);
        if (this.request) {
            ServerPlayer player = context.getSender();
            ItemStack stack = this.findResourcescrollBook((Player)player);
            if (!stack.m_41619_()) {
                MineColoniesTweaks.network().sendToPlayer(new ResourcescrollBookOpenMessage(stack), player);
            }
        } else {
            Item item = this.stack.m_41720_();
            if (item instanceof ItemResourceScrollBook) {
                ItemResourceScrollBook item2 = (ItemResourceScrollBook)item;
                item2.openWindow(this.stack);
            }
        }
    }

    public ItemStack findResourcescrollBook(Player player) {
        IItemHandlerModifiable handler;
        Inventory inventory = player.m_150109_();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (!this.testResourcescrollBook(stack)) continue;
            return stack;
        }
        if (ModList.get().isLoaded("curios") && (handler = CuriosCompat.getEquippedCurios(player)) != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (!this.testResourcescrollBook(stack)) continue;
                return stack;
            }
        }
        return ItemStack.f_41583_;
    }

    public boolean testResourcescrollBook(ItemStack stack) {
        return stack.m_41720_() instanceof ItemResourceScrollBook;
    }

    public boolean isRequest() {
        return this.request;
    }

    public ItemStack getStack() {
        return this.stack.m_41777_();
    }
}

