/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.item;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IBuildingModuleView;
import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IEntityListModule;
import com.minecolonies.api.colony.buildings.modules.IItemListModule;
import com.minecolonies.api.colony.buildings.modules.IMinimumStockModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.colony.buildings.modules.ISettingsModule;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.core.colony.buildings.modules.RestaurantMenuModule;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import steve_gall.minecolonies_tweaks.api.common.building.module.IIdListModule;
import steve_gall.minecolonies_tweaks.api.common.building.module.IMaximumStockModule;
import steve_gall.minecolonies_tweaks.core.common.MineColoniesTweaks;
import steve_gall.minecolonies_tweaks.core.common.building.BuildingUtils;

public class ItemCopyScroll
extends Item {
    public static final String NBT_DATA = MineColoniesTweaks.rl("copyscroll").toString();
    public static final String NBT_BUILDING_NAME = "name";
    public static final String NBT_ENTRIES = "tagList";
    public static final String NBT_ENTRY_KEY = "key";
    public static final String NBT_ENTRY_TAG = "tag";
    public static final Component MESSAGE_NO_DATA = Component.m_237115_((String)"item.minecolonies_tweaks.copyscroll.no_data");
    public static final Component MESSAGE_CLEARED = Component.m_237115_((String)"item.minecolonies_tweaks.copyscroll.cleared");
    public static final List<Component> TOOLTIPS = Arrays.asList(Component.m_237115_((String)"item.minecolonies_tweaks.copyscroll.tooltip1"), Component.m_237115_((String)"item.minecolonies_tweaks.copyscroll.tooltip2"), Component.m_237115_((String)"item.minecolonies_tweaks.copyscroll.tooltip3"));

    public ItemCopyScroll(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        tooltip.addAll(TOOLTIPS);
        CompoundTag tag = stack.m_41737_(NBT_DATA);
        if (tag == null) {
            return;
        }
        tooltip.add((Component)Component.m_237119_());
        tooltip.add((Component)Component.m_237110_((String)"item.minecolonies_tweaks.copyscroll.data", (Object[])new Object[]{Component.Serializer.m_130701_((String)tag.m_128461_(NBT_BUILDING_NAME)).m_130940_(ChatFormatting.DARK_PURPLE)}));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (!level.m_5776_() && player.m_6144_()) {
            ItemStack stack = player.m_21120_(hand);
            stack.m_41749_(NBT_DATA);
            player.m_213846_(MESSAGE_CLEARED);
        }
        return super.m_7203_(level, player, hand);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        BlockEntity blockEntity = context.m_43725_().m_7702_(context.m_8083_());
        if (blockEntity instanceof AbstractTileEntityColonyBuilding) {
            AbstractTileEntityColonyBuilding be = (AbstractTileEntityColonyBuilding)blockEntity;
            if (context.m_43725_().m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            IBuilding building = be.getBuilding();
            if (building == null) {
                return InteractionResult.PASS;
            }
            Player player = context.m_43723_();
            if (player == null) {
                return InteractionResult.PASS;
            }
            if (player.m_6144_()) {
                ListTag entries = new ListTag();
                MutableComponent names = Component.m_237119_();
                for (BuildingEntry.ModuleProducer moduleProducer : BuildingEntry.getALlModuleProducers().values()) {
                    IPersistentModule persistentModule;
                    IBuildingModule module;
                    if (!building.hasModule(moduleProducer) || !((module = building.getModule(moduleProducer)) instanceof IPersistentModule) || !ItemCopyScroll.canCopy(persistentModule = (IPersistentModule)module)) continue;
                    Component text = ItemCopyScroll.getModuleViewText(module);
                    CompoundTag entry = new CompoundTag();
                    entry.m_128359_(NBT_ENTRY_KEY, moduleProducer.key);
                    entry.m_128365_(NBT_ENTRY_TAG, (Tag)ItemCopyScroll.copy(persistentModule));
                    entries.add((Object)entry);
                    if (entries.size() > 1) {
                        names.m_130946_(", ");
                    }
                    names.m_7220_((Component)Component.m_237110_((String)"'%s'", (Object[])new Object[]{text}));
                }
                CompoundTag data = stack.m_41698_(NBT_DATA);
                data.m_128359_(NBT_BUILDING_NAME, Component.Serializer.m_130703_((Component)BuildingUtils.getDisplayName(building)));
                data.m_128365_(NBT_ENTRIES, (Tag)entries);
                player.m_213846_((Component)Component.m_237110_((String)"item.minecolonies_tweaks.copyscroll.copied", (Object[])new Object[]{entries.size(), names}));
            } else {
                CompoundTag data = stack.m_41737_(NBT_DATA);
                if (data == null) {
                    player.m_213846_(MESSAGE_NO_DATA);
                    return InteractionResult.SUCCESS;
                }
                ListTag entries = data.m_128437_(NBT_ENTRIES, 10);
                int pasted = 0;
                MutableComponent names = Component.m_237119_();
                for (int i = 0; i < entries.size(); ++i) {
                    IPersistentModule persistentModule;
                    IBuildingModule module;
                    CompoundTag entry = entries.m_128728_(i);
                    String key = entry.m_128461_(NBT_ENTRY_KEY);
                    CompoundTag tag = entry.m_128469_(NBT_ENTRY_TAG);
                    BuildingEntry.ModuleProducer producer = BuildingEntry.getProducer((String)key);
                    if (producer == null || !building.hasModule(producer) || !((module = building.getModule(producer)) instanceof IPersistentModule) || !ItemCopyScroll.canCopy(persistentModule = (IPersistentModule)module)) continue;
                    try {
                        Component text = ItemCopyScroll.getModuleViewText(module);
                        ItemCopyScroll.paste(persistentModule, tag);
                        if (++pasted > 1) {
                            names.m_130946_(", ");
                        }
                        names.m_7220_((Component)Component.m_237110_((String)"'%s'", (Object[])new Object[]{text}));
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                player.m_213846_((Component)Component.m_237110_((String)"item.minecolonies_tweaks.copyscroll.pasted", (Object[])new Object[]{pasted, names}));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static CompoundTag copy(IPersistentModule module) {
        CompoundTag tag = new CompoundTag();
        module.serializeNBT(tag);
        return tag;
    }

    public static void paste(IPersistentModule module, CompoundTag tag) {
        ItemCopyScroll.onPastePre(module);
        module.deserializeNBT(tag);
        module.markDirty();
        ItemCopyScroll.onPastePost(module);
    }

    private static void onPastePre(IPersistentModule module) {
        if (module instanceof ICraftingBuildingModule) {
            ICraftingBuildingModule craftingModule = (ICraftingBuildingModule)module;
            for (IToken token : new ArrayList(craftingModule.getRecipes())) {
                craftingModule.removeRecipe(token);
            }
        }
    }

    private static void onPastePost(IPersistentModule module) {
        if (module instanceof ICraftingBuildingModule) {
            ICraftingBuildingModule craftingModule = (ICraftingBuildingModule)module;
            IRequestManager requestManager = craftingModule.getBuilding().getColony().getRequestManager();
            for (IToken token : new ArrayList(craftingModule.getRecipes())) {
                IRecipeStorage recipeStorage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get((Object)token);
                if (recipeStorage == null) continue;
                List<ItemStack> allOutputs = Stream.concat(Stream.of(recipeStorage.getPrimaryOutput()), recipeStorage.getAlternateOutputs().stream()).filter(stack -> !stack.m_41619_()).toList();
                requestManager.onColonyUpdate(request -> {
                    IRequestable patt8387$temp = request.getRequest();
                    if (!(patt8387$temp instanceof IDeliverable)) return false;
                    IDeliverable delivery = (IDeliverable)patt8387$temp;
                    if (!allOutputs.stream().anyMatch(i -> delivery.matches(i))) return false;
                    return true;
                });
            }
        }
    }

    public static boolean canCopy(IPersistentModule module) {
        return module instanceof ISettingsModule || module instanceof IMinimumStockModule || module instanceof IEntityListModule || module instanceof IItemListModule || module instanceof RestaurantMenuModule || module instanceof ICraftingBuildingModule || module instanceof IMaximumStockModule || module instanceof IIdListModule;
    }

    public static Component getModuleViewText(IBuildingModule module) {
        IBuildingModuleView view = BuildingEntry.produceViewWithoutBuilding((String)module.getProducer().key);
        if (view != null) {
            try {
                FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                module.serializeToView(buf, true);
                view.deserialize(buf);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return view.getDesc();
        }
        return Component.m_237113_((String)module.getProducer().key);
    }
}

