/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.colony;

import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.NBTUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import steve_gall.minecolonies_tweaks.core.common.util.SerializationHelper;

public record BuildingCost(BlockPos id, List<ItemStorage> costs) {
    public static final String TAG_ID = "id";
    public static final String TAG_COSTS = "costs";

    public static BuildingCost deserialize(CompoundTag tag) {
        BlockPos id = BlockPosUtil.read((CompoundTag)tag, (String)TAG_ID);
        List<ItemStorage> costs = NBTUtils.streamCompound((ListTag)tag.m_128437_(TAG_COSTS, 10)).map(SerializationHelper.deserializerTag()).toList();
        return new BuildingCost(id, costs);
    }

    public static CompoundTag serialize(BuildingCost data) {
        CompoundTag tag = new CompoundTag();
        BlockPosUtil.write((CompoundTag)tag, (String)TAG_ID, (BlockPos)data.id);
        tag.m_128365_(TAG_COSTS, (Tag)data.costs.stream().map(SerializationHelper.serializerTag()).collect(NBTUtils.toListNBT()));
        return tag;
    }

    public static BuildingCost decode(FriendlyByteBuf buffer) {
        BlockPos id = buffer.m_130135_();
        List costs = buffer.m_236845_(SerializationHelper.deserializer());
        return new BuildingCost(id, costs);
    }

    public static void encode(FriendlyByteBuf buffer, BuildingCost data) {
        buffer.m_130064_(data.id);
        buffer.m_236828_(data.costs, SerializationHelper.serializer());
    }
}

