/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.client.gui;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.buildings.modules.IBuildingModuleView;
import com.minecolonies.core.client.gui.AbstractModuleWindow;
import com.minecolonies.core.client.gui.WindowSelectRes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_tweaks.api.common.building.module.IMaximumStockEntry;
import steve_gall.minecolonies_tweaks.api.common.building.module.IMaximumStockModuleView;
import steve_gall.minecolonies_tweaks.core.common.MineColoniesTweaks;

public class MaximumStockModuleWindow
extends AbstractModuleWindow<IMaximumStockModuleView> {
    private static final String LABEL_ADD = "com.minecolonies.coremod.gui.warehouse.add";
    private static final String LABEL_LIMIT_REACHED = "com.minecolonies.coremod.gui.warehouse.limitreached";
    private final ScrollingList resourceList;
    private final IMaximumStockModuleView moduleView;
    private final List<IMaximumStockEntry> entries;
    private Button confirmButton;

    public MaximumStockModuleWindow(IMaximumStockModuleView moduleView) {
        super((IBuildingModuleView)moduleView, MineColoniesTweaks.rl("gui/layouthuts/layoutmaximumstock.xml"));
        this.moduleView = moduleView;
        this.entries = new ArrayList<IMaximumStockEntry>();
        this.resourceList = (ScrollingList)this.window.findPaneOfTypeByID("resourcesstock", ScrollingList.class);
        this.resourceList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return MaximumStockModuleWindow.this.entries.size();
            }

            public void updateElement(int index, Pane rowPane) {
                IMaximumStockEntry entry = MaximumStockModuleWindow.this.entries.get(index);
                ItemStack resource = entry.stack();
                resource.m_41764_(resource.m_41741_());
                ((Text)rowPane.findPaneOfTypeByID("resourceName", Text.class)).setText(resource.m_41786_());
                ((Text)rowPane.findPaneOfTypeByID("resourceQty", Text.class)).setText(Component.m_237113_((String)String.valueOf(entry.quantity())));
                ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(resource);
            }
        });
    }

    public void onButtonClicked(@NotNull Button button) {
        super.onButtonClicked(button);
        Button confirmButton = this.confirmButton;
        if (confirmButton != null) {
            confirmButton.setText(Component.m_237113_((String)"X"));
            this.confirmButton = null;
        }
        if (button.getID().equals("removeStock")) {
            if (confirmButton == button) {
                int row = this.resourceList.getListElementIndexByPane((Pane)button);
                IMaximumStockEntry entry = this.entries.get(row);
                this.moduleView.removeMaximumStock(entry.stack());
                this.updateStockList();
            } else {
                this.confirmButton = button;
                this.confirmButton.setText(Component.m_237115_((String)"minecolonies_tweaks.gui.surely"));
            }
        } else if (button.getID().equals("addStock") && !this.moduleView.hasMaximumStockReachedLimit()) {
            new WindowSelectRes((BOWindow)this, stack -> true, (stack, qty) -> {
                this.moduleView.addMaximumStock((ItemStack)stack, (int)qty);
                this.updateStockList();
            }, true).open();
        }
    }

    public void onOpened() {
        super.onOpened();
        this.updateStockList();
    }

    private void updateStockList() {
        this.entries.clear();
        this.entries.addAll(this.moduleView.getMaximumStocks());
        ButtonImage button = (ButtonImage)this.findPaneOfTypeByID("addStock", ButtonImage.class);
        if (this.moduleView.hasMaximumStockReachedLimit()) {
            button.setText(Component.m_237115_((String)LABEL_LIMIT_REACHED));
            button.setImage(new ResourceLocation("minecolonies", "textures/gui/builderhut/builder_button_medium_disabled.png"), false);
        } else {
            button.setText(Component.m_237115_((String)LABEL_ADD));
            button.setImage(new ResourceLocation("minecolonies", "textures/gui/builderhut/builder_button_medium.png"), false);
        }
        Text kindsText = (Text)this.findPaneOfTypeByID("kinds", Text.class);
        kindsText.setText(Component.m_237113_((String)(this.entries.size() + "/" + this.moduleView.getMaximumStockLimit())));
    }
}

