/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.api.common.tool;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_tweaks.core.common.MineColoniesTweaks;

public class ToolTypeTags {
    private static final Map<ResourceLocation, TagKey<Item>> CUSTOM_ITEMS = new HashMap<ResourceLocation, TagKey<Item>>();
    private static final Map<ResourceLocation, Int2ObjectOpenHashMap<TagKey<Item>>> CUSTOM_LEVELS = new HashMap<ResourceLocation, Int2ObjectOpenHashMap<TagKey<Item>>>();
    private static final Map<ResourceLocation, TagKey<Item>> BLACKLISTS = new HashMap<ResourceLocation, TagKey<Item>>();
    public static final String CUSTOM_PREFIX = "custom_tools";
    public static final String BLACKLIST_PREFIX = "tool_blacklists";
    public static final TagKey<Item> BLACKLIST_ALL = ToolTypeTags.getBlacklist(MineColoniesTweaks.rl("all"));

    @NotNull
    public static String getTagPath(@NotNull ResourceLocation toolTypeId) {
        String namespace = toolTypeId.m_135827_();
        if (namespace.equals("minecolonies") || namespace.equals("minecolonies_tweaks")) {
            return toolTypeId.m_135815_();
        }
        return namespace + "/" + toolTypeId.m_135815_();
    }

    @NotNull
    public static TagKey<Item> getCustomItem(@NotNull ResourceLocation toolTypeId) {
        return CUSTOM_ITEMS.computeIfAbsent(toolTypeId, n -> {
            String path = "custom_tools/" + ToolTypeTags.getTagPath(n);
            return ItemTags.create((ResourceLocation)MineColoniesTweaks.rl(path));
        });
    }

    @NotNull
    public static TagKey<Item> getCustomLevel(@NotNull ResourceLocation toolTypeId, int level) {
        return (TagKey)CUSTOM_LEVELS.computeIfAbsent(toolTypeId, p -> new Int2ObjectOpenHashMap()).computeIfAbsent(level, l -> {
            String path = "custom_tools/" + ToolTypeTags.getTagPath(toolTypeId) + "/" + l;
            return ItemTags.create((ResourceLocation)MineColoniesTweaks.rl(path));
        });
    }

    public static boolean isInBlacklist(@NotNull ItemStack stack, @NotNull ResourceLocation toolTypeId) {
        return stack.m_204117_(BLACKLIST_ALL) || stack.m_204117_(ToolTypeTags.getBlacklist(toolTypeId));
    }

    @NotNull
    public static TagKey<Item> getBlacklist(@NotNull ResourceLocation toolTypeId) {
        return BLACKLISTS.computeIfAbsent(toolTypeId, n -> {
            String path = "tool_blacklists/" + ToolTypeTags.getTagPath(n);
            return ItemTags.create((ResourceLocation)MineColoniesTweaks.rl(path));
        });
    }

    private ToolTypeTags() {
    }
}

