/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.domesticationinnovation.server.entity;

import com.github.alexthe668.domesticationinnovation.server.entity.DIEntityRegistry;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class RecallBallEntity
extends Entity {
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(RecallBallEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<String> CONTAINED_ENTITY_TYPE = SynchedEntityData.m_135353_(RecallBallEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<CompoundTag> CONTAINED_ENTITY_DATA = SynchedEntityData.m_135353_(RecallBallEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final EntityDataAccessor<Boolean> OPENED = SynchedEntityData.m_135353_(RecallBallEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FINISHED = SynchedEntityData.m_135353_(RecallBallEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private float prevOpenProgress;
    private float openProgress;

    public RecallBallEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public RecallBallEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        this((EntityType)DIEntityRegistry.RECALL_BALL.get(), world);
        this.m_20331_(true);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
        this.f_19804_.m_135372_(CONTAINED_ENTITY_TYPE, (Object)"minecraft:pig");
        this.f_19804_.m_135372_(CONTAINED_ENTITY_DATA, (Object)new CompoundTag());
        this.f_19804_.m_135372_(OPENED, (Object)false);
        this.f_19804_.m_135372_(FINISHED, (Object)false);
    }

    public InteractionResult m_7111_(Player player, Vec3 vec3, InteractionHand hand) {
        return this.m_6096_(player, hand);
    }

    public boolean m_6087_() {
        return !this.isFinished();
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (!this.isFinished()) {
            if (this.getOwnerUUID() == null) {
                this.m_146870_();
            } else if (player.m_20148_().equals(this.getOwnerUUID()) && !((Boolean)this.f_19804_.m_135370_(OPENED)).booleanValue()) {
                this.m_5496_(SoundEvents.f_11889_, 1.0f, 1.5f);
                this.f_19804_.m_135381_(OPENED, (Object)true);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_8119_() {
        EntityType type;
        super.m_8119_();
        this.m_146922_(this.m_146908_() + 1.0f);
        this.m_146926_(0.0f);
        this.prevOpenProgress = this.openProgress;
        if (this.m_20072_() || this.m_20077_()) {
            this.m_146884_(this.m_20182_().m_82520_(0.0, 0.08, 0.0));
        }
        if (((Boolean)this.f_19804_.m_135370_(OPENED)).booleanValue() && this.openProgress < 1.0f) {
            this.openProgress += 0.1f;
        }
        if (!((Boolean)this.f_19804_.m_135370_(OPENED)).booleanValue() && this.openProgress > 0.0f) {
            this.openProgress -= 0.1f;
        }
        if (this.f_19796_.m_188501_() < 0.4f) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
        }
        if (this.m_20186_() < (double)this.m_9236_().m_141937_()) {
            this.m_6034_(this.m_20185_(), (float)this.m_9236_().m_141937_() + 1.2f, this.m_20189_());
        }
        if (((Boolean)this.f_19804_.m_135370_(OPENED)).booleanValue() && this.openProgress >= 1.0f && !this.isFinished() && !this.m_9236_().f_46443_ && (type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(this.getContainedEntityType()))) != null) {
            Entity entity = type.m_20615_(this.m_9236_());
            if (entity instanceof LivingEntity) {
                LivingEntity alive = (LivingEntity)entity;
                alive.m_7378_(this.getContainedData());
                alive.m_21153_(Math.max(2.0f, alive.m_21233_() * 0.25f));
                alive.m_146922_(this.f_19796_.m_188501_() * 360.0f - 180.0f);
                alive.m_20359_((Entity)this);
                this.m_9236_().m_7967_((Entity)alive);
            }
            this.f_19804_.m_135381_(FINISHED, (Object)true);
            this.f_19804_.m_135381_(OPENED, (Object)false);
        }
        if (this.isFinished() && this.openProgress <= 0.01f) {
            this.m_146870_();
        }
    }

    public boolean m_20068_() {
        return true;
    }

    public boolean m_142391_() {
        return !this.isFinished() && super.m_142391_();
    }

    public boolean isFinished() {
        return (Boolean)this.f_19804_.m_135370_(FINISHED);
    }

    protected void m_7378_(CompoundTag compoundNBT) {
        UUID uuid;
        if (compoundNBT.m_128403_("Owner")) {
            uuid = compoundNBT.m_128342_("Owner");
        } else {
            String s = compoundNBT.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setOwnerUUID(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.setContainedEntityType(compoundNBT.m_128461_("ContainedEntityType"));
        if (!compoundNBT.m_128469_("ContainedData").m_128456_()) {
            this.setContainedData(compoundNBT.m_128469_("ContainedData"));
        }
        this.f_19804_.m_135381_(FINISHED, (Object)compoundNBT.m_128471_("Finished"));
    }

    protected void m_7380_(CompoundTag compoundNBT) {
        if (this.getOwnerUUID() != null) {
            compoundNBT.m_128362_("Owner", this.getOwnerUUID());
        }
        compoundNBT.m_128359_("ContainedEntityType", this.getContainedEntityType());
        compoundNBT.m_128365_("ContainedData", (Tag)this.getContainedData());
        compoundNBT.m_128379_("Finished", this.isFinished());
    }

    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UUID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(OWNER_UUID, Optional.ofNullable(uuid));
    }

    public String getContainedEntityType() {
        return (String)this.f_19804_.m_135370_(CONTAINED_ENTITY_TYPE);
    }

    public void setContainedEntityType(String containedEntityType) {
        this.f_19804_.m_135381_(CONTAINED_ENTITY_TYPE, (Object)containedEntityType);
    }

    public CompoundTag getContainedData() {
        return (CompoundTag)this.f_19804_.m_135370_(CONTAINED_ENTITY_DATA);
    }

    public void setContainedData(CompoundTag containedData) {
        this.f_19804_.m_135381_(CONTAINED_ENTITY_DATA, (Object)containedData);
    }

    public boolean m_6673_(DamageSource damageSource) {
        return damageSource.m_19390_();
    }

    public float getOpenProgress(float f) {
        return Mth.m_14179_((float)f, (float)this.prevOpenProgress, (float)this.openProgress);
    }
}

