/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.domesticationinnovation.client.render;

import com.github.alexthe668.domesticationinnovation.client.render.DIRenderTypes;
import com.github.alexthe668.domesticationinnovation.server.entity.PsychicWallEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class RenderPsychicWall
extends EntityRenderer<PsychicWallEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("domesticationinnovation", "textures/psychic_wall_border.png");

    public RenderPsychicWall(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn);
    }

    public void render(PsychicWallEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light) {
        super.m_7392_((Entity)entity, yaw, partialTicks, poseStack, buffer, light);
        poseStack.m_85836_();
        float growth = Math.min(10.0f, (float)entity.f_19797_ + partialTicks) / 10.0f;
        if (entity.getLifespan() < 10) {
            growth = ((float)entity.getLifespan() - partialTicks) / 10.0f;
        }
        float f = (float)entity.getBlockWidth() * growth;
        poseStack.m_252781_(entity.getWallDirection().m_122424_().m_253075_());
        poseStack.m_85841_(f * 0.5f, f * 0.5f, f * 0.5f);
        this.renderWall(poseStack, f, buffer, buffer.m_6299_(DIRenderTypes.PSYCHIC_WALL));
        this.renderWall(poseStack, 1.0f, buffer, buffer.m_6299_(DIRenderTypes.PSYCHIC_WALL_BORDER));
        poseStack.m_85849_();
    }

    private void renderWall(PoseStack matrixStackIn, float size, MultiBufferSource bufferIn, VertexConsumer ivertexbuilder) {
        matrixStackIn.m_85836_();
        PoseStack.Pose lvt_19_1_ = matrixStackIn.m_85850_();
        Matrix4f lvt_20_1_ = lvt_19_1_.m_252922_();
        Matrix3f lvt_21_1_ = lvt_19_1_.m_252943_();
        this.drawVertex(lvt_20_1_, lvt_21_1_, ivertexbuilder, -1, 0, -1, 0.0f, 0.0f, 1, 0, 1, 240);
        this.drawVertex(lvt_20_1_, lvt_21_1_, ivertexbuilder, -1, 0, 1, 0.0f, size, 1, 0, 1, 240);
        this.drawVertex(lvt_20_1_, lvt_21_1_, ivertexbuilder, 1, 0, 1, size, size, 1, 0, 1, 240);
        this.drawVertex(lvt_20_1_, lvt_21_1_, ivertexbuilder, 1, 0, -1, size, 0.0f, 1, 0, 1, 240);
        matrixStackIn.m_85849_();
    }

    public void drawVertex(Matrix4f p_229039_1_, Matrix3f p_229039_2_, VertexConsumer p_229039_3_, int p_229039_4_, int p_229039_5_, int p_229039_6_, float p_229039_7_, float p_229039_8_, int p_229039_9_, int p_229039_10_, int p_229039_11_, int p_229039_12_) {
        p_229039_3_.m_252986_(p_229039_1_, (float)p_229039_4_, (float)p_229039_5_, (float)p_229039_6_).m_6122_(255, 255, 255, 255).m_7421_(p_229039_7_, p_229039_8_).m_86008_(OverlayTexture.f_118083_).m_85969_(p_229039_12_).m_252939_(p_229039_2_, (float)p_229039_9_, (float)p_229039_11_, (float)p_229039_10_).m_5752_();
    }

    public ResourceLocation getTextureLocation(PsychicWallEntity entity) {
        return TEXTURE;
    }
}

