/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.domesticationinnovation.client.model;

import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.github.alexthe668.domesticationinnovation.server.entity.RecallBallEntity;
import com.google.common.collect.ImmutableList;

public class RecallBallModel
extends AdvancedEntityModel<RecallBallEntity> {
    private final AdvancedModelBox bottom;
    private final AdvancedModelBox top;

    public RecallBallModel() {
        this.texWidth = 64;
        this.texHeight = 64;
        this.bottom = new AdvancedModelBox((AdvancedEntityModel)this);
        this.bottom.setPos(0.0f, 24.0f, 0.0f);
        this.bottom.setTextureOffset(0, 0).addBox(-4.5f, -6.0f, -4.5f, 9.0f, 6.0f, 9.0f, 0.0f, false);
        this.top = new AdvancedModelBox((AdvancedEntityModel)this);
        this.top.setPos(0.0f, -6.0f, 4.5f);
        this.bottom.addChild((BasicModelPart)this.top);
        this.top.setTextureOffset(0, 15).addBox(-4.5f, -3.0f, -9.0f, 9.0f, 3.0f, 9.0f, 0.0f, false);
        this.updateDefaultPose();
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.bottom);
    }

    public void setupAnim(RecallBallEntity recallBallEntity, float limbSwing, float limbSwingAmount, float age, float yaw, float pitch) {
        this.resetToDefaultPose();
    }

    public void animateBall(RecallBallEntity entity, float partialTick) {
        this.bottom.setShouldScaleChildren(true);
        this.resetToDefaultPose();
        float open = entity.getOpenProgress(partialTick);
        this.top.rotateAngleX = (float)((double)this.top.rotateAngleX - (double)open * Math.PI * 0.75);
        this.bottom.rotateAngleX = (float)((double)this.bottom.rotateAngleX + (double)open * Math.PI * 0.25);
        if (entity.isFinished()) {
            this.bottom.setScale(open, open * open, open);
        } else {
            this.bottom.setScale(1.0f, 1.0f, 1.0f);
        }
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.bottom, (Object)this.top);
    }
}

