/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api;

import com.google.common.collect.Multimap;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.AccessoriesHolder;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.EquipAction;
import io.wispforest.accessories.api.EquipCheck;
import io.wispforest.accessories.api.EquipmentChecking;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.api.slot.SlotTypeReference;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface AccessoriesCapability {
    @Nullable
    public static AccessoriesCapability get(@NotNull LivingEntity livingEntity) {
        return livingEntity.accessoriesCapability();
    }

    public static Optional<AccessoriesCapability> getOptionally(@NotNull LivingEntity livingEntity) {
        return Optional.ofNullable(AccessoriesCapability.get(livingEntity));
    }

    public LivingEntity entity();

    public AccessoriesHolder getHolder();

    public void reset(boolean var1);

    public Map<String, AccessoriesContainer> getContainers();

    @Nullable
    default public AccessoriesContainer getContainer(SlotType slotType) {
        return this.getContainers().get(slotType.name());
    }

    @Nullable
    default public AccessoriesContainer getContainer(SlotTypeReference reference) {
        return this.getContainers().get(reference.slotName());
    }

    public void updateContainers();

    @Deprecated
    @Nullable
    default public Pair<SlotReference, List<ItemStack>> equipAccessory(ItemStack stack) {
        return this.equipAccessory(stack, false);
    }

    @Deprecated
    default public Pair<SlotReference, List<ItemStack>> equipAccessory(ItemStack stack, boolean allowSwapping) {
        ItemStack stackCopy = stack.m_41777_();
        Pair<SlotReference, Optional<ItemStack>> result = this.attemptToEquipAccessory(stackCopy, allowSwapping);
        if (result == null) {
            return null;
        }
        ArrayList<ItemStack> returnStacks = new ArrayList<ItemStack>();
        if (!stackCopy.m_41619_()) {
            returnStacks.add(stackCopy);
        }
        ((Optional)result.second()).ifPresent(returnStacks::add);
        return Pair.of((Object)((SlotReference)result.first()), returnStacks);
    }

    @Nullable
    default public SlotReference attemptToEquipAccessory(ItemStack stack) {
        Pair<SlotReference, Optional<ItemStack>> result = this.attemptToEquipAccessory(stack, false);
        return result != null ? (SlotReference)result.first() : null;
    }

    @Nullable
    default public Pair<SlotReference, Optional<ItemStack>> attemptToEquipAccessory(ItemStack stack, boolean allowSwapping) {
        Pair<SlotReference, EquipAction> result = this.canEquipAccessory(stack, allowSwapping, (slotStack, slotReference) -> true);
        return result != null ? Pair.of((Object)((SlotReference)result.first()), ((EquipAction)result.second()).equipStack(stack)) : null;
    }

    default public Pair<SlotReference, EquipAction> canEquipAccessory(ItemStack stack, boolean allowSwapping) {
        return this.canEquipAccessory(stack, allowSwapping, (slotStack, slotReference) -> true);
    }

    @Nullable
    public Pair<SlotReference, EquipAction> canEquipAccessory(ItemStack var1, boolean var2, EquipCheck var3);

    default public boolean isEquipped(Item item) {
        return this.isEquipped(item, EquipmentChecking.ACCESSORIES_ONLY);
    }

    default public boolean isEquipped(Item item, EquipmentChecking check) {
        return this.isEquipped((ItemStack stack) -> stack.m_41720_() == item, check);
    }

    default public boolean isEquipped(Predicate<ItemStack> predicate) {
        return this.isEquipped(predicate, EquipmentChecking.ACCESSORIES_ONLY);
    }

    default public boolean isEquipped(Predicate<ItemStack> predicate, EquipmentChecking check) {
        return this.getFirstEquipped(predicate, check) != null;
    }

    default public boolean isAnotherEquipped(SlotReference slotReference, Item item) {
        return this.isAnotherEquipped(slotReference, (ItemStack stack) -> stack.m_41720_().equals(item));
    }

    default public boolean isAnotherEquipped(SlotReference slotReference, Predicate<ItemStack> predicate) {
        List<SlotEntryReference> equippedStacks = this.getEquipped(predicate);
        if (equippedStacks.size() > 2) {
            for (SlotEntryReference equippedStack : equippedStacks) {
                if (equippedStack.reference().equals(slotReference)) continue;
                return true;
            }
        } else if (equippedStacks.size() == 1) {
            return !equippedStacks.get(0).reference().equals(slotReference);
        }
        return false;
    }

    @Nullable
    default public SlotEntryReference getFirstEquipped(Item item) {
        return this.getFirstEquipped(item, EquipmentChecking.ACCESSORIES_ONLY);
    }

    @Nullable
    default public SlotEntryReference getFirstEquipped(Item item, EquipmentChecking check) {
        return this.getFirstEquipped((ItemStack stack) -> stack.m_41720_() == item, check);
    }

    @Nullable
    default public SlotEntryReference getFirstEquipped(Predicate<ItemStack> predicate) {
        return this.getFirstEquipped(predicate, EquipmentChecking.ACCESSORIES_ONLY);
    }

    @Nullable
    public SlotEntryReference getFirstEquipped(Predicate<ItemStack> var1, EquipmentChecking var2);

    default public List<SlotEntryReference> getEquipped(Item item) {
        return this.getEquipped((ItemStack stack) -> stack.m_41720_() == item);
    }

    public List<SlotEntryReference> getEquipped(Predicate<ItemStack> var1);

    default public List<SlotEntryReference> getAllEquipped() {
        return this.getAllEquipped(true);
    }

    public List<SlotEntryReference> getAllEquipped(boolean var1);

    public void addTransientSlotModifiers(Multimap<String, AttributeModifier> var1);

    public void addPersistentSlotModifiers(Multimap<String, AttributeModifier> var1);

    public void removeSlotModifiers(Multimap<String, AttributeModifier> var1);

    public Multimap<String, AttributeModifier> getSlotModifiers();

    public void clearSlotModifiers();

    public void clearCachedSlotModifiers();

    @Deprecated
    @Nullable
    default public Pair<SlotReference, List<ItemStack>> equipAccessory(ItemStack stack, boolean allowSwapping, TriFunction<Accessory, ItemStack, SlotReference, Boolean> additionalCheck) {
        return this.equipAccessory(stack, allowSwapping);
    }
}

