/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.data.block_growths.growths.builtin;

import com.ordana.immersive_weathering.blocks.snowy.Snowy;
import com.ordana.immersive_weathering.data.block_growths.TickSource;
import com.ordana.immersive_weathering.data.block_growths.growths.builtin.BuiltinBlockGrowth;
import com.ordana.immersive_weathering.reg.ModTags;
import com.ordana.immersive_weathering.util.TemperatureManager;
import com.ordana.immersive_weathering.util.WeatheringHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class SnowGrowth
extends BuiltinBlockGrowth {
    protected SnowGrowth(String name, @Nullable HolderSet<Block> owners, List<TickSource> sources, float chance) {
        super(name, owners, sources, chance);
    }

    @Nullable
    public Iterable<Block> getOwners() {
        return new ArrayList<Block>(Snowy.NORMAL_TO_SNOWY.get().keySet());
    }

    @Override
    public void tryGrowing(BlockPos pos, BlockState state, ServerLevel level, Supplier<Holder<Biome>> biome) {
        Optional<BlockState> snowyBlock;
        if (this.growthChance != 1.0f && !(level.f_46441_.m_188501_() < this.growthChance)) {
            return;
        }
        if (TemperatureManager.snowGrowthCanGrowSnowyBlock(pos, biome) && (snowyBlock = Snowy.getSnowy(state)).isPresent() && level.m_45517_(LightLayer.BLOCK, pos.m_7494_()) <= 11) {
            level.m_46597_(pos, snowyBlock.get());
            BlockPos downPos = pos.m_7495_();
            BlockState downBlock = level.m_8055_(downPos);
            if (WeatheringHelper.isRandomWeatheringPos(downPos)) {
                Optional<BlockState> snowyBlock2 = Snowy.getSnowy(downBlock);
                if (downBlock.m_204336_(ModTags.DOUBLE_SNOWABLE) && snowyBlock2.isPresent()) {
                    level.m_46597_(pos.m_7495_(), snowyBlock2.get());
                }
            }
        }
    }
}

