/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.data.block_growths.growths.builtin;

import com.ordana.immersive_weathering.data.block_growths.TickSource;
import com.ordana.immersive_weathering.data.block_growths.growths.builtin.BuiltinBlockGrowth;
import com.ordana.immersive_weathering.data.block_growths.growths.builtin.CampfireSootGrowth;
import com.ordana.immersive_weathering.data.block_growths.growths.builtin.FireSootGrowth;
import com.ordana.immersive_weathering.data.block_growths.growths.builtin.IceGrowth;
import com.ordana.immersive_weathering.data.block_growths.growths.builtin.LeavesGrowth;
import com.ordana.immersive_weathering.data.block_growths.growths.builtin.LightningGrowth;
import com.ordana.immersive_weathering.data.block_growths.growths.builtin.NoOpBlockGrowth;
import com.ordana.immersive_weathering.data.block_growths.growths.builtin.SandGrowth;
import com.ordana.immersive_weathering.data.block_growths.growths.builtin.SandLayerGrowth;
import com.ordana.immersive_weathering.data.block_growths.growths.builtin.SnowGrowth;
import com.ordana.immersive_weathering.data.block_growths.growths.builtin.SnowIcicleGrowth;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderSet;
import net.minecraft.world.level.block.Block;

public class BuiltinGrowthsRegistry {
    static final Map<String, BuiltinGrowthFactory> BUILTIN_GROWTHS = new HashMap<String, BuiltinGrowthFactory>();

    public static void register(String name, BuiltinGrowthFactory factory) {
        BUILTIN_GROWTHS.put(name, factory);
    }

    static {
        BuiltinGrowthsRegistry.register("no_op", NoOpBlockGrowth::new);
        BuiltinGrowthsRegistry.register("campfire_soot", CampfireSootGrowth::new);
        BuiltinGrowthsRegistry.register("fire_soot", FireSootGrowth::new);
        BuiltinGrowthsRegistry.register("ice_icicle_and_melt", IceGrowth::new);
        BuiltinGrowthsRegistry.register("leaf_piles_from_leaves", LeavesGrowth::new);
        BuiltinGrowthsRegistry.register("icicle_from_snow", SnowIcicleGrowth::new);
        BuiltinGrowthsRegistry.register("lightning_vitrified_sand", LightningGrowth::new);
        BuiltinGrowthsRegistry.register("snowy_stones", SnowGrowth::new);
        BuiltinGrowthsRegistry.register("sandy_stones", SandGrowth::new);
        BuiltinGrowthsRegistry.register("sand_layer_seeping", SandLayerGrowth::new);
    }

    @FunctionalInterface
    public static interface BuiltinGrowthFactory {
        public BuiltinBlockGrowth create(String var1, HolderSet<Block> var2, List<TickSource> var3, float var4);
    }
}

