/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.blocks.soil_types;

import com.ordana.immersive_weathering.blocks.soil_types.BaseSoilBlock;
import com.ordana.immersive_weathering.reg.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class EarthenClayBlockGrassy
extends BaseSoilBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public EarthenClayBlockGrassy(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_56637_, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{WATERLOGGED}).m_61104_(new Property[]{f_56637_});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        boolean bl = fluidState.m_76152_() == Fluids.f_76193_;
        return (BlockState)super.m_5573_(context).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(bl));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockPos blockpos;
        BlockState blockstate;
        if (!(!((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue() || random.m_188503_(25) != 1 || (blockstate = level.m_8055_(blockpos = pos.m_7495_())).m_60815_() && blockstate.m_60783_((BlockGetter)level, blockpos, Direction.UP))) {
            double d0 = (double)pos.m_123341_() + random.m_188500_();
            double d1 = (double)pos.m_123342_() - 0.05;
            double d2 = (double)pos.m_123343_() + random.m_188500_();
            level.m_7106_((ParticleOptions)ParticleTypes.f_123803_, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public static boolean isNearWater(LevelReader level, BlockPos pos) {
        boolean isNear = false;
        for (Direction dir : Direction.values()) {
            BlockState relativeBlock = level.m_8055_(pos.m_121945_(dir));
            if (!level.m_6425_(pos.m_121945_(dir)).m_205070_(FluidTags.f_13131_) || relativeBlock.m_60713_(ModBlocks.EARTHEN_CLAY.get()) || relativeBlock.m_60713_(ModBlocks.GRASSY_EARTHEN_CLAY.get())) continue;
            isNear = true;
        }
        return isNear;
    }

    @Override
    public void m_213898_(BlockState blockState, ServerLevel serverLevel, BlockPos pos, RandomSource random) {
        if (!EarthenClayBlockGrassy.canBeGrass(blockState, (LevelReader)serverLevel, pos)) {
            serverLevel.m_46597_(pos, ModBlocks.EARTHEN_CLAY.get().m_49966_());
        }
        if (!((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue() && serverLevel.m_46758_(pos.m_7494_()) || EarthenClayBlockGrassy.isNearWater((LevelReader)serverLevel, pos)) {
            serverLevel.m_7731_(pos, (BlockState)blockState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 2);
        } else if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue() && serverLevel.m_6042_().f_63857_()) {
            serverLevel.m_7731_(pos, (BlockState)blockState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 2);
        }
        super.m_213898_(blockState, serverLevel, pos, random);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof HoeItem) {
            level.m_5594_(player, pos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
            stack.m_41622_(1, (LivingEntity)player, l -> l.m_21190_(hand));
            if (player instanceof ServerPlayer) {
                if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
                    level.m_46597_(pos, (BlockState)ModBlocks.EARTHEN_CLAY_FARMLAND.get().m_49966_().m_61124_((Property)BlockStateProperties.f_61423_, (Comparable)Integer.valueOf(7)));
                } else {
                    level.m_46597_(pos, ModBlocks.EARTHEN_CLAY_FARMLAND.get().m_49966_());
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, hitResult);
    }
}

