/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.worldgen;

import com.drmangotea.tfmg.TFMG;
import com.drmangotea.tfmg.worldgen.TFMGPlacedFeatures;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;

public class TFMGBiomeModifiers {
    public static final ResourceKey<BiomeModifier> OIL_DEPOSIT = TFMGBiomeModifiers.key("oil_deposit");
    public static final ResourceKey<BiomeModifier> OIL_WELL = TFMGBiomeModifiers.key("oil_well");
    public static final ResourceKey<BiomeModifier> LEAD_ORE = TFMGBiomeModifiers.key("lead_ore");
    public static final ResourceKey<BiomeModifier> NICKEL_ORE = TFMGBiomeModifiers.key("nickel_ore");
    public static final ResourceKey<BiomeModifier> LITHIUM_ORE = TFMGBiomeModifiers.key("lithium_ore");
    public static final ResourceKey<BiomeModifier> TFMG_STRIATED_ORES_OVERWORLD = TFMGBiomeModifiers.key("tfmg_striated_ores_overworld");
    public static final ResourceKey<BiomeModifier> TFMG_STRIATED_ORES_NETHER = TFMGBiomeModifiers.key("tfmg_striated_ores_nether");

    private static ResourceKey<BiomeModifier> key(String name) {
        return ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)TFMG.asResource(name));
    }

    public static void bootstrap(BootstapContext<BiomeModifier> ctx) {
        HolderGetter biomeLookup = ctx.m_255420_(Registries.f_256952_);
        HolderSet.Named isOverworld = biomeLookup.m_254956_(BiomeTags.f_215817_);
        HolderSet.Named isNether = biomeLookup.m_254956_(BiomeTags.f_207612_);
        HolderSet.Named isDesert = biomeLookup.m_254956_(BiomeTags.f_207614_);
        HolderGetter featureLookup = ctx.m_255420_(Registries.f_256988_);
        Holder.Reference oilDeposit = featureLookup.m_255043_(TFMGPlacedFeatures.OIL_DEPOSIT);
        Holder.Reference oilWell = featureLookup.m_255043_(TFMGPlacedFeatures.OIL_WELL);
        Holder.Reference leadOre = featureLookup.m_255043_(TFMGPlacedFeatures.LEAD_ORE);
        Holder.Reference nickelOre = featureLookup.m_255043_(TFMGPlacedFeatures.NICKEL_ORE);
        Holder.Reference lithiumOre = featureLookup.m_255043_(TFMGPlacedFeatures.LITHIUM_ORE);
        Holder.Reference striatedOresOverworld = featureLookup.m_255043_(TFMGPlacedFeatures.TFMG_STRIATED_ORES_OVERWORLD);
        Holder.Reference striatedOresNether = featureLookup.m_255043_(TFMGPlacedFeatures.TFMG_STRIATED_ORES_NETHER);
        ctx.m_255272_(OIL_DEPOSIT, (Object)TFMGBiomeModifiers.addOre((HolderSet<Biome>)isOverworld, (Holder<PlacedFeature>)oilDeposit));
        ctx.m_255272_(OIL_WELL, (Object)TFMGBiomeModifiers.addOilWell((HolderSet<Biome>)isDesert, (Holder<PlacedFeature>)oilWell));
        ctx.m_255272_(LEAD_ORE, (Object)TFMGBiomeModifiers.addOre((HolderSet<Biome>)isOverworld, (Holder<PlacedFeature>)leadOre));
        ctx.m_255272_(NICKEL_ORE, (Object)TFMGBiomeModifiers.addOre((HolderSet<Biome>)isOverworld, (Holder<PlacedFeature>)nickelOre));
        ctx.m_255272_(LITHIUM_ORE, (Object)TFMGBiomeModifiers.addOre((HolderSet<Biome>)isOverworld, (Holder<PlacedFeature>)lithiumOre));
        ctx.m_255272_(TFMG_STRIATED_ORES_OVERWORLD, (Object)TFMGBiomeModifiers.addOre((HolderSet<Biome>)isOverworld, (Holder<PlacedFeature>)striatedOresOverworld));
        ctx.m_255272_(TFMG_STRIATED_ORES_NETHER, (Object)TFMGBiomeModifiers.addOre((HolderSet<Biome>)isNether, (Holder<PlacedFeature>)striatedOresNether));
    }

    private static ForgeBiomeModifiers.AddFeaturesBiomeModifier addOre(HolderSet<Biome> biomes, Holder<PlacedFeature> feature) {
        return new ForgeBiomeModifiers.AddFeaturesBiomeModifier(biomes, (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{feature}), GenerationStep.Decoration.UNDERGROUND_ORES);
    }

    private static ForgeBiomeModifiers.AddFeaturesBiomeModifier addOilWell(HolderSet<Biome> biomes, Holder<PlacedFeature> feature) {
        return new ForgeBiomeModifiers.AddFeaturesBiomeModifier(biomes, (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{feature}), GenerationStep.Decoration.FLUID_SPRINGS);
    }
}

